/*
 * Decompiled with CFR 0.152.
 */
package org.sputnikdev.bluetooth.gattparser.num;

import java.util.BitSet;
import org.sputnikdev.bluetooth.gattparser.num.FloatingPointNumberFormatter;
import org.sputnikdev.bluetooth.gattparser.num.TwosComplementNumberFormatter;

public class IEEE11073FloatingPointNumberFormatter
implements FloatingPointNumberFormatter {
    public static final int SFLOAT_NaN = 2047;
    public static final int SFLOAT_NRes = 2048;
    public static final int SFLOAT_POSITIVE_INFINITY = 2046;
    public static final int SFLOAT_NEGATIVE_INFINITY = 2050;
    public static final int SFLOAT_RESERVED = 2049;
    public static final int FLOAT_NaN = 0x7FFFFF;
    public static final int FLOAT_NRes = 0x800000;
    public static final int FLOAT_POSITIVE_INFINITY = 0x7FFFFE;
    public static final int FLOAT_NEGATIVE_INFINITY = 0x800002;
    public static final int FLOAT_RESERVED = 0x800001;
    private static final int SFLOAT_NEGATIVE_INFINITY_SIGNED = -2046;
    private static final int FLOAT_NEGATIVE_INFINITY_SIGNED = -8388606;
    private TwosComplementNumberFormatter twosComplementNumberFormatter = new TwosComplementNumberFormatter();

    @Override
    public Float deserializeSFloat(BitSet bits) {
        BitSet exponentBits = bits.get(12, 16);
        BitSet mantissaBits = bits.get(0, 12);
        int exponent = this.twosComplementNumberFormatter.deserializeInteger(exponentBits, 4, true);
        int mantissa = this.twosComplementNumberFormatter.deserializeInteger(mantissaBits, 12, true);
        if (exponent == 0) {
            if (mantissa == 2047) {
                return Float.valueOf(Float.NaN);
            }
            if (mantissa == 2046) {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            if (mantissa == -2046) {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
        }
        return Float.valueOf((float)((double)mantissa * Math.pow(10.0, exponent)));
    }

    @Override
    public Float deserializeFloat(BitSet bits) {
        BitSet exponentBits = bits.get(24, 32);
        BitSet mantissaBits = bits.get(0, 24);
        int exponent = this.twosComplementNumberFormatter.deserializeInteger(exponentBits, 8, true);
        int mantissa = this.twosComplementNumberFormatter.deserializeInteger(mantissaBits, 24, true);
        if (exponent == 0) {
            if (mantissa == 0x7FFFFF) {
                return Float.valueOf(Float.NaN);
            }
            if (mantissa == 0x7FFFFE) {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            if (mantissa == -8388606) {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
        }
        return Float.valueOf((float)((double)mantissa * Math.pow(10.0, exponent)));
    }

    @Override
    public Double deserializeDouble(BitSet bits) {
        throw new IllegalStateException("Operation not supported");
    }

    @Override
    public BitSet serializeSFloat(Float number) {
        throw new IllegalStateException("Operation not supported");
    }

    @Override
    public BitSet serializeFloat(Float number) {
        throw new IllegalStateException("Operation not supported");
    }

    @Override
    public BitSet serializeDouble(Double number) {
        throw new IllegalStateException("Operation not supported");
    }
}

