/*
 * Decompiled with CFR 0.152.
 */
package org.sputnikdev.bluetooth.gattparser.spec;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sputnikdev.bluetooth.gattparser.spec.FieldType;

public class FieldFormat {
    public static final int FULL_SIZE = -1;
    private static final Map<String, FieldFormat> PREDEFINED = Collections.unmodifiableMap(new HashMap<String, FieldFormat>(){
        {
            this.put("boolean", new FieldFormat("boolean", FieldType.BOOLEAN, 1));
            this.put("nibble", new FieldFormat("nibble", FieldType.UINT, 4));
            this.put("float32", new FieldFormat("float32", FieldType.FLOAT_IEE754, 32));
            this.put("float64", new FieldFormat("float64", FieldType.FLOAT_IEE754, 64));
            this.put("sfloat", new FieldFormat("SFLOAT", FieldType.FLOAT_IEE11073, 16));
            this.put("float", new FieldFormat("FLOAT", FieldType.FLOAT_IEE11073, 32));
            this.put("utf8s", new FieldFormat("utf8s", FieldType.UTF8S, -1));
            this.put("utf16s", new FieldFormat("utf16s", FieldType.UTF16S, -1));
            this.put("struct", new FieldFormat("struct", FieldType.STRUCT, -1));
            this.put("reg-cert-data-list", new FieldFormat("struct", FieldType.STRUCT, -1));
        }
    });
    private final String name;
    private final FieldType type;
    private final int size;

    FieldFormat(String name, FieldType type, int size) {
        this.name = name;
        this.type = type;
        this.size = size;
    }

    public static FieldFormat valueOf(String name) {
        if (name == null) {
            return null;
        }
        String fieldName = name.toLowerCase();
        if (PREDEFINED.containsKey(fieldName)) {
            return PREDEFINED.get(fieldName);
        }
        if (fieldName.startsWith("uint") || fieldName.endsWith("bit")) {
            return new FieldFormat(fieldName, FieldType.UINT, FieldFormat.parseSize(fieldName));
        }
        if (fieldName.startsWith("sint")) {
            return new FieldFormat(fieldName, FieldType.SINT, FieldFormat.parseSize(fieldName));
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public FieldType getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isReal() {
        return this.type == FieldType.UINT || this.type == FieldType.SINT;
    }

    public boolean isDecimal() {
        return this.type == FieldType.FLOAT_IEE754 || this.type == FieldType.FLOAT_IEE11073;
    }

    public boolean isBoolean() {
        return this.type == FieldType.BOOLEAN;
    }

    public boolean isString() {
        return this.type == FieldType.UTF8S || this.type == FieldType.UTF16S;
    }

    public boolean isStruct() {
        return this.type == FieldType.STRUCT;
    }

    public boolean isNumber() {
        return this.isReal() || this.isDecimal();
    }

    private static int parseSize(String name) {
        try {
            return Integer.parseInt(name.replace("uint", "").replace("sint", "").replace("bit", ""));
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

