package org.sputnikdev.bluetooth.manager;

/*-
 * #%L
 * org.sputnikdev:bluetooth-manager
 * %%
 * Copyright (C) 2017 Sputnik Dev
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import org.sputnikdev.bluetooth.URL;

/**
 * A listener to handle discovery results for Bluetooth adapters.
 *
 * @author Vlad Kolotov
 */
@FunctionalInterface
public interface AdapterDiscoveryListener {

    /**
     * Method is called when a new Bluetooth adapter gets discovered.
     *
     * @param adapter a new discovered adapter
     */
    void discovered(DiscoveredAdapter adapter);

    /**
     * Method is called when a Bluetooth adapter gets lost for any reason, e.g. disconnected from the system.
     *
     * @param address adapter URL
     */
    default void adapterLost(URL address) { }

}
