/*
 * Decompiled with CFR 0.152.
 */
package org.sputnikdev.bluetooth;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Set;
import org.sputnikdev.bluetooth.AddressType;
import org.sputnikdev.bluetooth.URL;

public class AddressUtils {
    private static volatile Set ouiRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isOui(String address) {
        if (ouiRegistry != null) return ouiRegistry.contains(Integer.valueOf(address.replace(":", "").substring(0, 6), 16));
        Class<AddressUtils> clazz = AddressUtils.class;
        synchronized (AddressUtils.class) {
            if (ouiRegistry != null) return ouiRegistry.contains(Integer.valueOf(address.replace(":", "").substring(0, 6), 16));
            ouiRegistry = AddressUtils.loadOuiRegistry();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ouiRegistry.contains(Integer.valueOf(address.replace(":", "").substring(0, 6), 16));
        }
    }

    public static AddressType guessDeviceAddressType(URL url) {
        if (url.getDeviceAddress() == null) {
            return AddressType.COMPOSITE;
        }
        return AddressUtils.guessAddressType(url.getDeviceAddress());
    }

    public static AddressType guessAddressType(String address) {
        if (address.equals("XX:XX:XX:XX:XX:XX")) {
            return AddressType.COMPOSITE;
        }
        if (AddressUtils.isOui(address)) {
            return AddressType.PUBLIC;
        }
        Integer msb = Integer.parseUnsignedInt(address.substring(0, 2), 16) >> 6;
        switch (msb) {
            case 3: {
                return AddressType.STATIC;
            }
            case 1: {
                return AddressType.NON_RESOLVABLE;
            }
            case 0: {
                return AddressType.RESOLVABLE;
            }
        }
        return AddressType.PUBLIC;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set loadOuiRegistry() {
        try (InputStream fileIn = AddressUtils.class.getResourceAsStream("/oui_registry.ser");){
            ObjectInputStream objectIn = new ObjectInputStream(fileIn);
            Set set = (Set)objectIn.readObject();
            return set;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }
}

