/*
 * Decompiled with CFR 0.152.
 */
package org.sputnikdev.bluetooth;

import org.sputnikdev.bluetooth.Filter;

public class RssiKalmanFilter
implements Filter<Short> {
    private static final double RSSI_PROCESS_NOISE = 0.125;
    private static final double RSSI_MEASUREMENT_NOISE = 30.0;
    private double processNoise;
    private double measurementNoise;
    private double currentRssi;
    private double errorCovariance;

    public RssiKalmanFilter() {
        this.processNoise = 0.125;
        this.measurementNoise = 30.0;
    }

    public RssiKalmanFilter(double processNoise, double measurementNoise) {
        this.processNoise = processNoise;
        this.measurementNoise = measurementNoise;
    }

    @Override
    public Short next(Short next) {
        double interimCovariance;
        double interimRssi;
        if (this.currentRssi == 0.0) {
            interimRssi = next.shortValue();
            interimCovariance = 1.0;
        } else {
            interimRssi = this.currentRssi;
            interimCovariance = this.errorCovariance + this.processNoise;
        }
        double kalmanGain = interimCovariance / (interimCovariance + this.measurementNoise);
        this.currentRssi = interimRssi + kalmanGain * ((double)next.shortValue() - interimRssi);
        this.errorCovariance = (1.0 - kalmanGain) * interimCovariance;
        return (short)this.currentRssi;
    }

    @Override
    public Short current() {
        return (short)this.currentRssi;
    }

    public double getProcessNoise() {
        return this.processNoise;
    }

    public void setProcessNoise(double processNoise) {
        this.processNoise = processNoise;
    }

    public double getMeasurementNoise() {
        return this.measurementNoise;
    }

    public void setMeasurementNoise(double measurementNoise) {
        this.measurementNoise = measurementNoise;
    }
}

