/*
 * Decompiled with CFR 0.152.
 */
package org.sputnikdev.bluetooth;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class URL
implements Comparable<URL> {
    private static final Pattern URL_PATTERN = Pattern.compile("^((?<protocol>\\w*):)?/(?<adapter>(\\w\\w:){5}\\w\\w)?(/(?<device>(\\w\\w:){5}\\w\\w)?(\\[name=(?<devicename>[\\w\\s'-]+)\\])?)?(/(?<service>[0-9A-Fa-f]{4,8}(-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{12})?))?(/(?<charact>[0-9A-Fa-f]{4,8}(-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{12})?))?(/(?<field>\\w+))?$");
    public static final URL ROOT = new URL("/");
    private final String protocol;
    private final String adapterAddress;
    private final String deviceAddress;
    private final Map<String, String> deviceAttributes = new HashMap<String, String>();
    private final String serviceUUID;
    private final String characteristicUUID;
    private final String fieldName;

    public URL(String url) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (matcher.find()) {
            this.protocol = URL.toLowerCase(matcher.group("protocol"));
            this.adapterAddress = URL.toUpperCase(matcher.group("adapter"));
            this.deviceAddress = URL.toUpperCase(matcher.group("device"));
            String deviceName = matcher.group("devicename");
            if (deviceName != null) {
                this.deviceAttributes.put("name", deviceName);
            }
        } else {
            throw new IllegalArgumentException("Invalid URL: " + url);
        }
        this.serviceUUID = URL.toLowerCase(matcher.group("service"));
        this.characteristicUUID = URL.toLowerCase(matcher.group("charact"));
        this.fieldName = matcher.group("field");
        this.validate();
    }

    public URL() {
        this(null, null);
    }

    public URL(String adapterAddress, String deviceAddress) {
        this(adapterAddress, deviceAddress, null, null, null);
    }

    public URL(String protocol, String adapterAddress, String deviceAddress) {
        this(protocol, adapterAddress, deviceAddress, null, null, null);
    }

    public URL(String adapterAddress, String deviceAddress, String serviceUUID, String characteristicUUID) {
        this(adapterAddress, deviceAddress, serviceUUID, characteristicUUID, null);
    }

    public URL(String adapterAddress, String deviceAddress, String serviceUUID, String characteristicUUID, String fieldName) {
        this(null, adapterAddress, deviceAddress, serviceUUID, characteristicUUID, fieldName);
    }

    public URL(String protocol, String adapterAddress, String deviceAddress, String serviceUUID, String characteristicUUID, String fieldName) {
        this.protocol = URL.toLowerCase(protocol);
        this.adapterAddress = URL.toUpperCase(adapterAddress);
        this.deviceAddress = URL.toUpperCase(deviceAddress);
        this.serviceUUID = URL.toLowerCase(serviceUUID);
        this.characteristicUUID = URL.toLowerCase(characteristicUUID);
        this.fieldName = fieldName;
        this.validate();
    }

    public URL(String protocol, String adapterAddress, Map<String, String> deviceAttributes, String serviceUUID, String characteristicUUID, String fieldName) {
        this.protocol = URL.toLowerCase(protocol);
        this.adapterAddress = URL.toUpperCase(adapterAddress);
        this.deviceAddress = null;
        if (deviceAttributes != null && !deviceAttributes.isEmpty()) {
            this.deviceAttributes.putAll(deviceAttributes);
        }
        this.serviceUUID = URL.toLowerCase(serviceUUID);
        this.characteristicUUID = URL.toLowerCase(characteristicUUID);
        this.fieldName = fieldName;
        this.validate();
    }

    URL(String protocol, String adapterAddress, String deviceAddress, Map<String, String> deviceAttributes, String serviceUUID, String characteristicUUID, String fieldName) {
        this.protocol = URL.toLowerCase(protocol);
        this.adapterAddress = URL.toUpperCase(adapterAddress);
        this.deviceAddress = URL.toUpperCase(deviceAddress);
        if (deviceAttributes != null && !deviceAttributes.isEmpty()) {
            this.deviceAttributes.putAll(deviceAttributes);
        }
        this.serviceUUID = URL.toLowerCase(serviceUUID);
        this.characteristicUUID = URL.toLowerCase(characteristicUUID);
        this.fieldName = fieldName;
        this.validate();
    }

    public URL copyWithProtocol(String protocol) {
        return new URL(protocol, this.adapterAddress, this.deviceAddress, this.deviceAttributes, this.serviceUUID, this.characteristicUUID, this.fieldName);
    }

    public URL copyWithAdapter(String adapterAddress) {
        return new URL(this.protocol, adapterAddress, this.deviceAddress, this.deviceAttributes, this.serviceUUID, this.characteristicUUID, this.fieldName);
    }

    public URL copyWithDevice(String deviceAddress) {
        return new URL(this.protocol, this.adapterAddress, deviceAddress, this.deviceAttributes, this.serviceUUID, this.characteristicUUID, this.fieldName);
    }

    public URL copyWithDevice(String deviceAddress, Map<String, String> attr) {
        return new URL(this.protocol, this.adapterAddress, deviceAddress, attr, this.serviceUUID, this.characteristicUUID, this.fieldName);
    }

    public URL copyWithDevice(String deviceAddress, String attrName, String attrValue) {
        return new URL(this.protocol, this.adapterAddress, deviceAddress, Collections.singletonMap(attrName, attrValue), this.serviceUUID, this.characteristicUUID, this.fieldName);
    }

    public URL copyWithService(String serviceUUID) {
        return new URL(this.protocol, this.adapterAddress, this.deviceAddress, this.deviceAttributes, serviceUUID, null, null);
    }

    public URL copyWithCharacteristic(String characteristicUUID) {
        return new URL(this.protocol, this.adapterAddress, this.deviceAddress, this.deviceAttributes, this.serviceUUID, characteristicUUID, null);
    }

    public URL copyWith(String serviceUUID, String characteristicUUID) {
        return new URL(this.protocol, this.adapterAddress, this.deviceAddress, this.deviceAttributes, serviceUUID, characteristicUUID, null);
    }

    public URL copyWith(String serviceUUID, String characteristicUUID, String fieldName) {
        return new URL(this.protocol, this.adapterAddress, this.deviceAddress, this.deviceAttributes, serviceUUID, characteristicUUID, fieldName);
    }

    public URL copyWithField(String fieldName) {
        return new URL(this.protocol, this.adapterAddress, this.deviceAddress, this.deviceAttributes, this.serviceUUID, this.characteristicUUID, fieldName);
    }

    public URL getDeviceURL() {
        return new URL(this.protocol, this.adapterAddress, this.deviceAddress, this.deviceAttributes, null, null, null);
    }

    public Map<String, String> getDeviceAttributes() {
        return Collections.unmodifiableMap(this.deviceAttributes);
    }

    public String getDeviceName() {
        return this.deviceAttributes.get("name");
    }

    public URL getServiceURL() {
        return new URL(this.protocol, this.adapterAddress, this.deviceAddress, this.deviceAttributes, this.serviceUUID, null, null);
    }

    public URL getCharacteristicURL() {
        return new URL(this.protocol, this.adapterAddress, this.deviceAddress, this.deviceAttributes, this.serviceUUID, this.characteristicUUID, null);
    }

    public URL getAdapterURL() {
        return new URL(this.protocol, this.adapterAddress, null);
    }

    public URL getProtocolURL() {
        return new URL(this.protocol, null, null);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getAdapterAddress() {
        return this.adapterAddress;
    }

    public String getDeviceAddress() {
        return this.deviceAddress;
    }

    public String getDeviceCompositeAddress() {
        String device = this.deviceAddress;
        if (!this.deviceAttributes.isEmpty()) {
            device = (device != null ? device : "") + this.deviceAttributes.entrySet().stream().map(Object::toString).collect(Collectors.joining(",", "[", "]"));
        }
        return device;
    }

    public String getServiceUUID() {
        return this.serviceUUID;
    }

    public String getCharacteristicUUID() {
        return this.characteristicUUID;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isProtocol() {
        return this.protocol != null && this.adapterAddress == null;
    }

    public boolean isRoot() {
        return this.adapterAddress == null;
    }

    public boolean isAdapter() {
        return this.adapterAddress != null && this.deviceAddress == null && this.deviceAttributes.isEmpty();
    }

    public boolean isDevice() {
        return (this.deviceAddress != null || !this.deviceAttributes.isEmpty()) && this.serviceUUID == null;
    }

    public boolean isService() {
        return this.serviceUUID != null && this.characteristicUUID == null;
    }

    public boolean isCharacteristic() {
        return this.characteristicUUID != null && this.fieldName == null;
    }

    public boolean isField() {
        return this.fieldName != null;
    }

    public URL getParent() {
        if (this.isField()) {
            return this.getCharacteristicURL();
        }
        if (this.isCharacteristic()) {
            return this.getServiceURL();
        }
        if (this.isService()) {
            return this.getDeviceURL();
        }
        if (this.isDevice()) {
            return this.getAdapterURL();
        }
        if (this.isAdapter()) {
            return this.getProtocolURL();
        }
        return null;
    }

    public boolean isDescendant(URL url) {
        if (url.protocol != null && this.protocol != null && !this.protocol.equals(url.protocol)) {
            return false;
        }
        if (this.adapterAddress != null && url.adapterAddress == null) {
            return true;
        }
        if (this.adapterAddress != null && !this.adapterAddress.equals(url.adapterAddress)) {
            return false;
        }
        if (this.deviceAddress != null && url.deviceAddress == null) {
            return true;
        }
        if (this.deviceAddress != null && !this.deviceAddress.equals(url.deviceAddress)) {
            return false;
        }
        if (this.serviceUUID != null && url.serviceUUID == null) {
            return true;
        }
        if (this.serviceUUID != null ? !this.serviceUUID.equals(url.serviceUUID) : url.serviceUUID != null) {
            return false;
        }
        if (this.characteristicUUID != null && url.characteristicUUID == null) {
            return true;
        }
        if (this.characteristicUUID != null ? !this.characteristicUUID.equals(url.characteristicUUID) : url.characteristicUUID != null) {
            return false;
        }
        return this.fieldName != null && url.fieldName == null;
    }

    public String toString() {
        LinkedList<String> fields = new LinkedList<String>();
        String deviceAddress = this.getDeviceCompositeAddress();
        if (this.adapterAddress == null && deviceAddress != null) {
            fields.add("");
        } else {
            fields.add(this.adapterAddress);
        }
        fields.add(deviceAddress);
        fields.add(this.serviceUUID);
        fields.add(this.characteristicUUID);
        fields.add(this.fieldName);
        while (!fields.isEmpty() && fields.getLast() == null) {
            fields.removeLast();
        }
        return (this.protocol != null ? this.protocol + ":" : "") + "/" + String.join((CharSequence)"/", fields);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        URL url = (URL)that;
        if (this.protocol != null ? !this.protocol.equals(url.protocol) : url.protocol != null) {
            return false;
        }
        if (this.adapterAddress != null ? !this.adapterAddress.equals(url.adapterAddress) : url.adapterAddress != null) {
            return false;
        }
        if (this.deviceAddress != null ? !this.deviceAddress.equals(url.deviceAddress) : url.deviceAddress != null) {
            return false;
        }
        if (!this.deviceAttributes.equals(url.deviceAttributes)) {
            return false;
        }
        if (this.serviceUUID != null ? !this.serviceUUID.equals(url.serviceUUID) : url.serviceUUID != null) {
            return false;
        }
        if (this.characteristicUUID != null ? !this.characteristicUUID.equals(url.characteristicUUID) : url.characteristicUUID != null) {
            return false;
        }
        return this.fieldName != null && url.fieldName != null ? this.fieldName.toLowerCase().equals(url.fieldName.toLowerCase()) : this.fieldName == url.fieldName;
    }

    public int hashCode() {
        int result = this.protocol != null ? this.protocol.hashCode() : 0;
        result = 31 * result + (this.adapterAddress != null ? this.adapterAddress.hashCode() : 0);
        result = 31 * result + (this.deviceAddress != null ? this.deviceAddress.hashCode() : 0);
        result = 31 * result + this.deviceAttributes.hashCode();
        result = 31 * result + (this.serviceUUID != null ? this.serviceUUID.hashCode() : 0);
        result = 31 * result + (this.characteristicUUID != null ? this.characteristicUUID.hashCode() : 0);
        result = 31 * result + (this.fieldName != null ? this.fieldName.toLowerCase().hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(URL that) {
        int result = this.compareFields(this.adapterAddress, that.adapterAddress);
        if (result != 0) {
            return result;
        }
        result = this.compareFields(this.deviceAddress, that.deviceAddress);
        if (result != 0) {
            return result;
        }
        result = this.compareFields(this.serviceUUID, that.serviceUUID);
        if (result != 0) {
            return result;
        }
        result = this.compareFields(this.characteristicUUID, that.characteristicUUID);
        if (result != 0) {
            return result;
        }
        return this.compareFields(this.fieldName, that.fieldName);
    }

    private void validate() {
        if (this.fieldName != null && this.characteristicUUID == null || this.characteristicUUID != null && this.serviceUUID == null || this.serviceUUID != null && this.deviceAddress == null && this.deviceAttributes.isEmpty()) {
            throw new IllegalArgumentException("Invalid url: " + this.toString());
        }
    }

    private int compareFields(String field1, String field2) {
        if (field1 == null && field2 == null) {
            return 0;
        }
        if (field2 == null) {
            return 1;
        }
        if (field1 == null) {
            return -1;
        }
        return field1.compareTo(field2);
    }

    private static String toUpperCase(String str) {
        return Optional.ofNullable(str).map(String::toUpperCase).orElse(null);
    }

    private static String toLowerCase(String str) {
        return Optional.ofNullable(str).map(String::toLowerCase).orElse(null);
    }
}

