/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.extensions.postgres.converters;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Map;
import org.postgresql.util.PGobject;
import org.sql2o.converters.Converter;
import org.sql2o.converters.ConverterException;
import org.sql2o.converters.ConvertersProvider;
import org.sql2o.converters.StringConverter;

public class JSONConverter
implements Converter<JsonElement>,
ConvertersProvider {
    public void fill(Map<Class<?>, Converter<?>> mapToFill) {
        mapToFill.put(JsonElement.class, this);
    }

    public JsonElement convert(Object val) throws ConverterException {
        if (val == null) {
            return null;
        }
        if (val instanceof JsonElement) {
            return (JsonElement)val;
        }
        String jsonString = val instanceof String ? (String)val : (val instanceof PGobject ? ((PGobject)val).getValue() : stringConverterHolder.converter.convert(val));
        return parserHolder.parser.parse(jsonString);
    }

    public Object toDatabaseParam(JsonElement val) {
        if (val == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        writerHolder.gson.toJson(val, (Appendable)stringBuilder);
        return stringBuilder.toString();
    }

    static class stringConverterHolder {
        static final StringConverter converter = new StringConverter();

        stringConverterHolder() {
        }
    }

    static class writerHolder {
        static final Gson gson = new Gson();

        writerHolder() {
        }
    }

    static class parserHolder {
        static final JsonParser parser = new JsonParser();

        parserHolder() {
        }
    }
}

