/*
 * Decompiled with CFR 0.152.
 */
package org.squeryl.internals;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.UUID;
import java.util.zip.Adler32;
import org.squeryl.Schema;
import org.squeryl.Session;
import org.squeryl.Session$;
import org.squeryl.Table;
import org.squeryl.dsl.ast.BinaryOperatorNode;
import org.squeryl.dsl.ast.BinaryOperatorNode$;
import org.squeryl.dsl.ast.ExpressionNode;
import org.squeryl.dsl.ast.FieldSelectElement;
import org.squeryl.dsl.ast.FunctionNode;
import org.squeryl.dsl.ast.LogicalBoolean;
import org.squeryl.dsl.ast.QueryExpressionElements;
import org.squeryl.dsl.ast.QueryableExpressionNode;
import org.squeryl.dsl.ast.SelectElement;
import org.squeryl.dsl.ast.TypedExpressionNode;
import org.squeryl.dsl.ast.UpdateStatement;
import org.squeryl.dsl.ast.ViewExpressionNode;
import org.squeryl.internals.DatabaseAdapter;
import org.squeryl.internals.DatabaseAdapter$;
import org.squeryl.internals.FieldMetaData;
import org.squeryl.internals.StatementWriter;
import org.squeryl.internals.Utils$;
import scala.Array$;
import scala.Either;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product1;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public abstract class DatabaseAdapter$class {
    public static DatabaseAdapter.ZipIterable zipIterable(DatabaseAdapter $this, Iterable i) {
        return new DatabaseAdapter.ZipIterable($this, i);
    }

    public static void writeQuery(DatabaseAdapter $this, QueryExpressionElements qen, StatementWriter sw) {
        $this.writeQuery(qen, sw, false, (Option<String>)None$.MODULE$);
    }

    public static void writeQuery(DatabaseAdapter $this, QueryExpressionElements qen$1, StatementWriter sw$9, boolean inverseOrderBy, Option topHint) {
        sw$9.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Select"}));
        topHint.foreach((Function1)new DatabaseAdapter$.anonfun.writeQuery.7($this, sw$9));
        if (qen$1.selectDistinct()) {
            sw$9.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" distinct"}));
        }
        sw$9.nextLine();
        sw$9.writeIndented((Function0<Object>)new DatabaseAdapter$.anonfun.writeQuery.1($this, qen$1, sw$9));
        sw$9.nextLine();
        sw$9.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"From"}));
        sw$9.nextLine();
        if (qen$1.isJoinForm()) {
            Iterable singleNonJoinTableExpression = (Iterable)qen$1.tableExpressions().filter((Function1)new DatabaseAdapter$.anonfun.1($this));
            Predef$.MODULE$.assert(singleNonJoinTableExpression.size() == 1, (Function0)new DatabaseAdapter$.anonfun.writeQuery.8($this, qen$1));
            QueryableExpressionNode firstJoinExpr = (QueryableExpressionNode)singleNonJoinTableExpression.head();
            Iterable restOfJoinExpr = (Iterable)qen$1.tableExpressions().filter((Function1)new DatabaseAdapter$.anonfun.2($this));
            firstJoinExpr.write(sw$9);
            sw$9.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" "}));
            sw$9.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sw$9.quoteName(firstJoinExpr.alias())}));
            sw$9.nextLine();
            $this.zipIterable(restOfJoinExpr).zipi().foreach(new DatabaseAdapter$.anonfun.writeQuery.9($this, sw$9));
        } else {
            sw$9.writeIndented((Function0<Object>)new DatabaseAdapter$.anonfun.writeQuery.2($this, qen$1, sw$9));
        }
        $this.writeEndOfFromHint(qen$1, sw$9);
        if (qen$1.hasUnInhibitedWhereClause()) {
            sw$9.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Where"}));
            sw$9.nextLine();
            sw$9.writeIndented((Function0<Object>)new DatabaseAdapter$.anonfun.writeQuery.3($this, qen$1, sw$9));
            sw$9.pushPendingNextLine();
        }
        if (!qen$1.groupByClause().isEmpty()) {
            sw$9.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group By"}));
            sw$9.nextLine();
            sw$9.writeIndented((Function0<Object>)new DatabaseAdapter$.anonfun.writeQuery.4($this, qen$1, sw$9));
            sw$9.pushPendingNextLine();
        }
        if (!qen$1.havingClause().isEmpty()) {
            sw$9.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Having"}));
            sw$9.nextLine();
            sw$9.writeIndented((Function0<Object>)new DatabaseAdapter$.anonfun.writeQuery.5($this, qen$1, sw$9));
            sw$9.pushPendingNextLine();
        }
        if (!qen$1.orderByClause().isEmpty()) {
            Option<ExpressionNode> option = qen$1.parent();
            None$ none$ = None$.MODULE$;
            if (!(option != null ? !option.equals((Object)none$) : none$ != null)) {
                sw$9.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Order By"}));
                sw$9.nextLine();
                Iterable ob0 = (Iterable)qen$1.orderByClause().filter((Function1)new DatabaseAdapter$.anonfun.3($this));
                Iterable ob$1 = inverseOrderBy ? (Iterable)ob0.map((Function1)new DatabaseAdapter$.anonfun.4($this), Iterable$.MODULE$.canBuildFrom()) : ob0;
                sw$9.writeIndented((Function0<Object>)new DatabaseAdapter$.anonfun.writeQuery.6($this, sw$9, ob$1));
                sw$9.pushPendingNextLine();
            }
        }
        $this.writeEndOfQueryHint(qen$1, sw$9);
        $this.writePaginatedQueryDeclaration(qen$1, sw$9);
    }

    public static void writeEndOfQueryHint(DatabaseAdapter $this, QueryExpressionElements qen, StatementWriter sw) {
        if (qen.isForUpdate()) {
            sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for update"}));
            sw.pushPendingNextLine();
        }
    }

    public static void writeEndOfFromHint(DatabaseAdapter $this, QueryExpressionElements qen, StatementWriter sw) {
    }

    public static void writePaginatedQueryDeclaration(DatabaseAdapter $this, QueryExpressionElements qen, StatementWriter sw$8) {
        qen.page().foreach((Function1)new DatabaseAdapter$.anonfun.writePaginatedQueryDeclaration.1($this, sw$8));
    }

    public static void writeJoin(DatabaseAdapter $this, QueryableExpressionNode queryableExpressionNode, StatementWriter sw) {
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)((Tuple2)queryableExpressionNode.joinKind().get())._1()}));
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" "}));
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)((Tuple2)queryableExpressionNode.joinKind().get())._2()}));
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" join "}));
        queryableExpressionNode.write(sw);
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" as "}));
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sw.quoteName(queryableExpressionNode.alias())}));
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" on "}));
        ((ExpressionNode)queryableExpressionNode.joinExpression().get()).write(sw);
    }

    public static String intTypeDeclaration(DatabaseAdapter $this) {
        return "int";
    }

    public static String stringTypeDeclaration(DatabaseAdapter $this) {
        return "varchar";
    }

    public static String stringTypeDeclaration(DatabaseAdapter $this, int length) {
        return new StringBuilder().append((Object)"varchar(").append((Object)BoxesRunTime.boxToInteger((int)length)).append((Object)")").toString();
    }

    public static String booleanTypeDeclaration(DatabaseAdapter $this) {
        return "boolean";
    }

    public static String doubleTypeDeclaration(DatabaseAdapter $this) {
        return "double";
    }

    public static String dateTypeDeclaration(DatabaseAdapter $this) {
        return "date";
    }

    public static String longTypeDeclaration(DatabaseAdapter $this) {
        return "bigint";
    }

    public static String floatTypeDeclaration(DatabaseAdapter $this) {
        return "real";
    }

    public static String bigDecimalTypeDeclaration(DatabaseAdapter $this) {
        return "decimal";
    }

    public static String bigDecimalTypeDeclaration(DatabaseAdapter $this, int precision, int scale) {
        return new StringBuilder().append((Object)"decimal(").append((Object)BoxesRunTime.boxToInteger((int)precision)).append((Object)",").append((Object)BoxesRunTime.boxToInteger((int)scale)).append((Object)")").toString();
    }

    public static String timestampTypeDeclaration(DatabaseAdapter $this) {
        return "timestamp";
    }

    public static String binaryTypeDeclaration(DatabaseAdapter $this) {
        return "binary";
    }

    public static String uuidTypeDeclaration(DatabaseAdapter $this) {
        return "char(36)";
    }

    public static String databaseTypeFor(DatabaseAdapter $this, FieldMetaData fmd$1) {
        return (String)fmd$1.explicitDbTypeDeclaration().getOrElse((Function0)new DatabaseAdapter$.anonfun.databaseTypeFor.1($this, fmd$1));
    }

    public static String writeColumnDeclaration(DatabaseAdapter $this, FieldMetaData fmd, boolean isPrimaryKey, Schema schema) {
        String dbTypeDeclaration = $this.databaseTypeFor(fmd);
        StringBuilder sb$2 = new StringBuilder(128);
        sb$2.append("  ");
        sb$2.append($this.quoteName(fmd.columnName()));
        sb$2.append(" ");
        sb$2.append(dbTypeDeclaration);
        fmd.defaultValue().foreach((Function1)new DatabaseAdapter$.anonfun.writeColumnDeclaration.1($this, sb$2));
        Object object = isPrimaryKey ? sb$2.append(" primary key") : BoxedUnit.UNIT;
        Object object2 = fmd.isOption() ? BoxedUnit.UNIT : sb$2.append(" not null");
        Object object3 = $this.supportsAutoIncrementInColumnDeclaration() && fmd.isAutoIncremented() ? sb$2.append(" auto_increment") : BoxedUnit.UNIT;
        return sb$2.toString();
    }

    public static boolean supportsAutoIncrementInColumnDeclaration(DatabaseAdapter $this) {
        return true;
    }

    public static void writeCreateTable(DatabaseAdapter $this, Table t$1, StatementWriter sw$1, Schema schema$1) {
        sw$1.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create table "}));
        sw$1.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.quoteName(t$1.prefixedName())}));
        sw$1.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (\n"}));
        sw$1.writeIndented((Function0<Object>)new DatabaseAdapter$.anonfun.writeCreateTable.1($this, t$1, sw$1, schema$1));
        sw$1.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{")"}));
    }

    public static Iterable convertParamsForJdbc(DatabaseAdapter $this, Iterable params) {
        return (Iterable)params.map((Function1)new DatabaseAdapter$.anonfun.convertParamsForJdbc.1($this), Iterable$.MODULE$.canBuildFrom());
    }

    public static void fillParamsInto(DatabaseAdapter $this, Iterable params, PreparedStatement s$2) {
        IntRef i$1 = new IntRef(1);
        params.foreach((Function1)new DatabaseAdapter$.anonfun.fillParamsInto.1($this, s$2, i$1));
    }

    private static Object _exec(DatabaseAdapter $this, Session s, StatementWriter sw, Function1 block, Iterable args) {
        Object exceptionResult1 = null;
        try {
            if (s.isLoggingEnabled()) {
                s.log(sw.toString());
            }
            exceptionResult1 = block.apply((Object)args);
            return exceptionResult1;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(new StringBuilder().append((Object)"Exception while executing statement : ").append((Object)sQLException.getMessage()).append((Object)"\nerrorCode: ").append((Object)BoxesRunTime.boxToInteger((int)sQLException.getErrorCode())).append((Object)", sqlState: ").append((Object)sQLException.getSQLState()).append((Object)"\n").append((Object)sw.statement()).append((Object)"\njdbcParams:").append((Object)args.mkString("[", ",", "]")).toString(), sQLException);
        }
    }

    public static boolean failureOfStatementRequiresRollback(DatabaseAdapter $this) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void execFailSafeExecute(DatabaseAdapter $this, StatementWriter sw, Function1 silenceException) {
        Session s = Session$.MODULE$.currentSession();
        Connection c$2 = s.connection();
        Statement stat = $this.createStatement(c$2);
        None$ sp2 = $this.failureOfStatementRequiresRollback() ? new Some((Object)c$2.setSavepoint()) : None$.MODULE$;
        try {
            if (s.isLoggingEnabled()) {
                s.log(sw.toString());
            }
            stat.execute(sw.statement());
            return;
        }
        catch (SQLException sQLException) {
            if (!BoxesRunTime.unboxToBoolean((Object)silenceException.apply((Object)sQLException))) throw new RuntimeException(new StringBuilder().append((Object)"Exception while executing statement,\nSQLState:").append((Object)sQLException.getSQLState()).append((Object)", ErrorCode:").append((Object)BoxesRunTime.boxToInteger((int)sQLException.getErrorCode())).append((Object)"\n :").append((Object)sw.statement()).toString(), sQLException);
            sp2.foreach((Function1)new DatabaseAdapter$.anonfun.execFailSafeExecute.1($this, c$2));
        }
        finally {
            sp2.foreach((Function1)new DatabaseAdapter$.anonfun.execFailSafeExecute.2($this, c$2));
            Utils$.MODULE$.close(stat);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static StatementWriter string2StatementWriter(DatabaseAdapter $this, String s) {
        void var2_2;
        StatementWriter sw = new StatementWriter($this);
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{s}));
        return var2_2;
    }

    public static Object exec(DatabaseAdapter $this, Session s, StatementWriter sw, Function1 block) {
        Iterable<Object> p = $this.convertParamsForJdbc(sw.paramsZ());
        return DatabaseAdapter$class._exec($this, s, sw, block, p);
    }

    public static PreparedStatement prepareStatement(DatabaseAdapter $this, Connection conn, String statement) {
        return conn.prepareStatement(statement);
    }

    public static Statement createStatement(DatabaseAdapter $this, Connection conn) {
        return conn.createStatement();
    }

    public static Tuple2 executeQuery(DatabaseAdapter $this, Session s$4, StatementWriter sw$10) {
        return (Tuple2)$this.exec(s$4, sw$10, new DatabaseAdapter$.anonfun.executeQuery.1($this, s$4, sw$10));
    }

    public static Tuple2 executeUpdate(DatabaseAdapter $this, Session s$5, StatementWriter sw$12) {
        return (Tuple2)$this.exec(s$5, sw$12, new DatabaseAdapter$.anonfun.executeUpdate.1($this, s$5, sw$12));
    }

    public static int executeUpdateAndCloseStatement(DatabaseAdapter $this, Session s$3, StatementWriter sw$6) {
        return BoxesRunTime.unboxToInt($this.exec(s$3, sw$6, new DatabaseAdapter$.anonfun.executeUpdateAndCloseStatement.1($this, s$3, sw$6)));
    }

    public static int executeUpdateForInsert(DatabaseAdapter $this, Session s$1, StatementWriter sw$3, PreparedStatement ps$1) {
        return BoxesRunTime.unboxToInt($this.exec(s$1, sw$3, new DatabaseAdapter$.anonfun.executeUpdateForInsert.1($this, s$1, sw$3, ps$1)));
    }

    public static Iterable getInsertableFields(DatabaseAdapter $this, Iterable fmd) {
        return (Iterable)fmd.filter((Function1)new DatabaseAdapter$.anonfun.getInsertableFields.1($this));
    }

    public static void writeInsert(DatabaseAdapter $this, Object o, Table t, StatementWriter sw$2) {
        Object o_$2 = o;
        Iterable<FieldMetaData> f = $this.getInsertableFields(t.posoMetaData().fieldsMetaData());
        sw$2.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into "}));
        sw$2.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.quoteName(t.prefixedName())}));
        sw$2.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ("}));
        sw$2.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((TraversableOnce)f.map((Function1)new DatabaseAdapter$.anonfun.writeInsert.1($this), Iterable$.MODULE$.canBuildFrom())).mkString(", ")}));
        sw$2.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{") values "}));
        sw$2.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((TraversableOnce)f.map((Function1)new DatabaseAdapter$.anonfun.writeInsert.2($this, sw$2, o_$2), Iterable$.MODULE$.canBuildFrom())).mkString("(", ",", ")")}));
    }

    /*
     * WARNING - void declaration
     */
    public static Object convertToJdbcValue(DatabaseAdapter $this, Object r) {
        void var2_2;
        Object v = r;
        if (v instanceof Product1) {
            v = ((Product1)v)._1();
        }
        if (v instanceof Date && !(v instanceof java.sql.Date) && !(v instanceof Timestamp)) {
            v = new java.sql.Date(((Date)v).getTime());
        } else if (v instanceof BigDecimal) {
            v = ((BigDecimal)v).bigDecimal();
        } else if (v instanceof Enumeration.Value) {
            v = BoxesRunTime.boxToInteger((int)((Enumeration.Value)v).id());
        } else if (v instanceof UUID) {
            v = $this.convertFromUuidForJdbc((UUID)v);
        }
        return var2_2;
    }

    public static String writeValue(DatabaseAdapter $this, Object o, FieldMetaData fmd, StatementWriter sw) {
        String string;
        if (sw.isForDisplay()) {
            Object v = fmd.get(o);
            string = v == null ? "null" : v.toString();
        } else {
            sw.addParam($this.convertToJdbcValue(fmd.get(o)));
            string = "?";
        }
        return string;
    }

    public static void postCreateTable(DatabaseAdapter $this, Table t, Option printSinkWhenWriteOnlyMode) {
    }

    public static void postDropTable(DatabaseAdapter $this, Table t) {
    }

    public static String createSequenceName(DatabaseAdapter $this, FieldMetaData fmd) {
        return new StringBuilder().append((Object)"s_").append((Object)fmd.parentMetaData().viewOrTable().name()).append((Object)"_").append((Object)fmd.columnName()).toString();
    }

    public static void writeConcatFunctionCall(DatabaseAdapter $this, FunctionNode fn, StatementWriter sw) {
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{fn.name()}));
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"("}));
        sw.writeNodesWithSeparator(fn.args(), ",", false);
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{")"}));
    }

    public static boolean isFullOuterJoinSupported(DatabaseAdapter $this) {
        return true;
    }

    public static void writeUpdate(DatabaseAdapter $this, Object o, Table t$2, StatementWriter sw$5, boolean checkOCC) {
        Object o_$1 = o;
        sw$5.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"update ", $this.quoteName(t$2.prefixedName()), " set "}));
        sw$5.nextLine();
        sw$5.indent();
        sw$5.writeLinesWithSeparator((Iterable<String>)((Iterable)((TraversableLike)t$2.posoMetaData().fieldsMetaData().filter((Function1)new DatabaseAdapter$.anonfun.writeUpdate.2($this))).map((Function1)new DatabaseAdapter$.anonfun.writeUpdate.3($this, sw$5, o_$1), Iterable$.MODULE$.canBuildFrom())), ",");
        sw$5.unindent();
        sw$5.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"where"}));
        sw$5.nextLine();
        sw$5.indent();
        ((Either)t$2.posoMetaData().primaryKey().getOrElse((Function0)new DatabaseAdapter$.anonfun.writeUpdate.4($this))).fold((Function1)new DatabaseAdapter$.anonfun.writeUpdate.5($this, sw$5, o_$1), (Function1)new DatabaseAdapter$.anonfun.writeUpdate.6($this, t$2, sw$5, o_$1));
        if (checkOCC) {
            t$2.posoMetaData().optimisticCounter().foreach((Function1)new DatabaseAdapter$.anonfun.writeUpdate.7($this, sw$5, o_$1));
        }
    }

    public static void writeDelete(DatabaseAdapter $this, Table t, Option whereClause$1, StatementWriter sw$7) {
        sw$7.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delete from "}));
        sw$7.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.quoteName(t.prefixedName())}));
        Option option = whereClause$1;
        None$ none$ = None$.MODULE$;
        if (option == null ? none$ != null : !option.equals(none$)) {
            sw$7.nextLine();
            sw$7.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"where"}));
            sw$7.nextLine();
            sw$7.writeIndented((Function0<Object>)new DatabaseAdapter$.anonfun.writeDelete.1($this, whereClause$1, sw$7));
        }
    }

    public static boolean convertFromBooleanForJdbc(DatabaseAdapter $this, boolean b) {
        return b;
    }

    public static boolean convertToBooleanForJdbc(DatabaseAdapter $this, ResultSet rs, int i) {
        return rs.getBoolean(i);
    }

    public static Object convertFromUuidForJdbc(DatabaseAdapter $this, UUID u) {
        return u.toString();
    }

    public static UUID convertToUuidForJdbc(DatabaseAdapter $this, ResultSet rs, int i) {
        return UUID.fromString(rs.getString(i));
    }

    public static void writeUpdate(DatabaseAdapter $this, Table t, UpdateStatement us$1, StatementWriter sw$4) {
        Iterator colsToUpdate$1 = us$1.columns().iterator();
        sw$4.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"update "}));
        sw$4.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.quoteName(t.prefixedName())}));
        sw$4.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" set"}));
        sw$4.indent();
        sw$4.nextLine();
        $this.zipIterable(us$1.values()).zipi().foreach(new DatabaseAdapter$.anonfun.writeUpdate.8($this, sw$4, colsToUpdate$1));
        if (t.posoMetaData().isOptimistic()) {
            sw$4.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{","}));
            sw$4.nextLine();
            FieldMetaData occ = (FieldMetaData)t.posoMetaData().optimisticCounter().get();
            sw$4.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.quoteName(occ.columnName())}));
            sw$4.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" = "}));
            sw$4.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)$this.quoteName(occ.columnName())).append((Object)" + 1").toString()}));
        }
        sw$4.unindent();
        Option<LogicalBoolean> option = us$1.whereClause();
        None$ none$ = None$.MODULE$;
        if (option == null ? none$ != null : !option.equals((Object)none$)) {
            sw$4.nextLine();
            sw$4.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Where"}));
            sw$4.nextLine();
            sw$4.writeIndented((Function0<Object>)new DatabaseAdapter$.anonfun.writeUpdate.1($this, us$1, sw$4));
        }
    }

    public static String nvlToken(DatabaseAdapter $this) {
        return "coalesce";
    }

    public static void writeNvlCall(DatabaseAdapter $this, ExpressionNode left, ExpressionNode right, StatementWriter sw) {
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.nvlToken()}));
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"("}));
        left.write(sw);
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{","}));
        right.write(sw);
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{")"}));
    }

    public static boolean isNotNullConstraintViolation(DatabaseAdapter $this, SQLException e) {
        return false;
    }

    public static String foreignKeyConstraintName(DatabaseAdapter $this, Table foreignKeyTable, int idWithinSchema) {
        return new StringBuilder().append((Object)foreignKeyTable.name()).append((Object)"FK").append((Object)BoxesRunTime.boxToInteger((int)idWithinSchema)).toString();
    }

    public static String viewAlias(DatabaseAdapter $this, ViewExpressionNode vn) {
        Option<String> option = vn.view().prefix();
        None$ none$ = None$.MODULE$;
        return !(option != null ? !option.equals((Object)none$) : none$ != null) ? new StringBuilder().append((Object)vn.view().name()).append(vn.uniqueId().get()).toString() : new StringBuilder().append((Object)((String)vn.view().prefix().get())).append((Object)"_").append((Object)vn.view().name()).append(vn.uniqueId().get()).toString();
    }

    public static String writeForeignKeyDeclaration(DatabaseAdapter $this, Table foreignKeyTable, String foreignKeyColumnName, Table primaryKeyTable, String primaryKeyColumnName, Option referentialAction1, Option referentialAction2, int fkId) {
        StringBuilder sb$1 = new StringBuilder(256);
        sb$1.append("alter table ");
        sb$1.append($this.quoteName(foreignKeyTable.prefixedName()));
        sb$1.append(" add constraint ");
        sb$1.append($this.quoteName($this.foreignKeyConstraintName(foreignKeyTable, fkId)));
        sb$1.append(" foreign key (");
        sb$1.append($this.quoteName(foreignKeyColumnName));
        sb$1.append(") references ");
        sb$1.append($this.quoteName(primaryKeyTable.prefixedName()));
        sb$1.append("(");
        sb$1.append($this.quoteName(primaryKeyColumnName));
        sb$1.append(")");
        DatabaseAdapter$.anonfun.6 f = new DatabaseAdapter$.anonfun.6($this, sb$1);
        referentialAction1.foreach((Function1)f);
        referentialAction2.foreach((Function1)f);
        return sb$1.toString();
    }

    public static Session currenSession(DatabaseAdapter $this) {
        return Session$.MODULE$.currentSession();
    }

    public static String writeDropForeignKeyStatement(DatabaseAdapter $this, Table foreignKeyTable, String fkName) {
        return new StringBuilder().append((Object)"alter table ").append((Object)$this.quoteName(foreignKeyTable.prefixedName())).append((Object)" drop constraint ").append((Object)$this.quoteName(fkName)).toString();
    }

    public static void dropForeignKeyStatement(DatabaseAdapter $this, Table foreignKeyTable, String fkName, Session session) {
        $this.execFailSafeExecute($this.string2StatementWriter($this.writeDropForeignKeyStatement(foreignKeyTable, fkName)), (Function1<SQLException, Boolean>)new DatabaseAdapter$.anonfun.dropForeignKeyStatement.1($this));
    }

    public static boolean supportsForeignKeyConstraints(DatabaseAdapter $this) {
        return true;
    }

    public static String writeDropTable(DatabaseAdapter $this, String tableName) {
        return new StringBuilder().append((Object)"drop table ").append((Object)$this.quoteName(tableName)).toString();
    }

    public static void dropTable(DatabaseAdapter $this, Table t) {
        $this.execFailSafeExecute($this.string2StatementWriter($this.writeDropTable(t.prefixedName())), (Function1<SQLException, Boolean>)new DatabaseAdapter$.anonfun.dropTable.1($this));
    }

    public static String writeCompositePrimaryKeyConstraint(DatabaseAdapter $this, Table t, Iterable cols) {
        return $this.writeUniquenessConstraint(t, (Iterable<FieldMetaData>)cols);
    }

    public static String writeUniquenessConstraint(DatabaseAdapter $this, Table t, Iterable cols) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("alter table ");
        sb.append($this.quoteName(t.prefixedName()));
        sb.append(" add constraint ");
        sb.append($this.quoteName(new StringBuilder().append((Object)t.prefixedName()).append((Object)"CPK").toString()));
        sb.append(" unique(");
        sb.append(((TraversableOnce)((TraversableLike)cols.map((Function1)new DatabaseAdapter$.anonfun.writeUniquenessConstraint.1($this), Iterable$.MODULE$.canBuildFrom())).map((Function1)new DatabaseAdapter$.anonfun.writeUniquenessConstraint.2($this), Iterable$.MODULE$.canBuildFrom())).mkString(","));
        sb.append(")");
        return sb.toString();
    }

    public static void writeRegexExpression(DatabaseAdapter $this, ExpressionNode left, String pattern, StatementWriter sw) {
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"("}));
        left.write(sw);
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ~ ?)"}));
        sw.addParam(pattern);
    }

    public static void writeConcatOperator(DatabaseAdapter $this, ExpressionNode left, ExpressionNode right, StatementWriter sw) {
        BinaryOperatorNode binaryOpNode = new BinaryOperatorNode(left, right, "||", BinaryOperatorNode$.MODULE$.init$default$4());
        binaryOpNode.doWrite(sw);
    }

    public static String writeIndexDeclaration(DatabaseAdapter $this, Seq columnDefs, Option name, Option nameOfCompositeKey, boolean isUnique) {
        StringBuilder stringBuilder;
        StringBuilder sb = new StringBuilder(256);
        sb.append("create ");
        Object object = isUnique ? sb.append("unique ") : BoxedUnit.UNIT;
        sb.append("index ");
        String tableName = ((FieldMetaData)columnDefs.head()).parentMetaData().viewOrTable().prefixedName();
        Option option = name;
        None$ none$ = None$.MODULE$;
        if (!(option != null ? !option.equals(none$) : none$ != null)) {
            Option option2 = nameOfCompositeKey;
            None$ none$2 = None$.MODULE$;
            stringBuilder = !(option2 != null ? !option2.equals(none$2) : none$2 != null) ? sb.append($this.quoteName(new StringBuilder().append((Object)"idx").append((Object)$this.generateAlmostUniqueSuffixWithHash(new StringBuilder().append((Object)tableName).append((Object)"-").append((Object)((TraversableOnce)columnDefs.map((Function1)new DatabaseAdapter$.anonfun.writeIndexDeclaration.1($this), Seq$.MODULE$.canBuildFrom())).mkString("-")).toString())).toString())) : sb.append($this.quoteName(new StringBuilder().append((Object)"idx").append(nameOfCompositeKey.get()).toString()));
        } else {
            stringBuilder = sb.append($this.quoteName((String)name.get()));
        }
        sb.append(" on ");
        sb.append($this.quoteName(tableName));
        sb.append(((TraversableOnce)((TraversableLike)columnDefs.map((Function1)new DatabaseAdapter$.anonfun.writeIndexDeclaration.2($this), Seq$.MODULE$.canBuildFrom())).map((Function1)new DatabaseAdapter$.anonfun.writeIndexDeclaration.3($this), Seq$.MODULE$.canBuildFrom())).mkString(" (", ",", ")"));
        return sb.toString();
    }

    public static String generateAlmostUniqueSuffixWithHash(DatabaseAdapter $this, String s) {
        Adler32 a32 = new Adler32();
        a32.update(s.getBytes());
        return Predef$.MODULE$.longWrapper(a32.getValue()).toHexString();
    }

    public static String quoteIdentifier(DatabaseAdapter $this, String s) {
        return s;
    }

    public static String quoteName(DatabaseAdapter $this, String s) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.augmentString(s).split('.')).map((Function1)new DatabaseAdapter$.anonfun.quoteName.1($this), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)))).mkString(".");
    }

    public static String fieldAlias(DatabaseAdapter $this, QueryableExpressionNode n, FieldSelectElement fse) {
        return new StringBuilder().append((Object)n.alias()).append((Object)"_").append((Object)fse.fieldMetaData().columnName()).toString();
    }

    public static String aliasExport(DatabaseAdapter $this, QueryableExpressionNode parentOfTarget, SelectElement target2) {
        return new StringBuilder().append((Object)parentOfTarget.alias()).append((Object)"_").append((Object)target2.aliasSegment()).toString();
    }

    public static void writeSelectElementAlias(DatabaseAdapter $this, SelectElement se, StatementWriter sw) {
        String a = se.aliasSegment();
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.quoteName(a)}));
    }

    public static String databaseTypeFor(DatabaseAdapter $this, Class c) {
        return (String)$this.org$squeryl$internals$DatabaseAdapter$$_declarationHandler().handleType(c, (Option<FieldMetaData>)None$.MODULE$);
    }

    public static void writeCastInvocation(DatabaseAdapter $this, TypedExpressionNode e, StatementWriter sw) {
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cast("}));
        e.write(sw);
        String dbSpecificType = $this.databaseTypeFor(e.mapper().jdbcClass());
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" as "}));
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{dbSpecificType}));
        sw.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{")"}));
    }

    public static void writeCaseStatement(DatabaseAdapter $this, Option toMatch, Iterable cases, TypedExpressionNode otherwise, StatementWriter sw$11) {
        sw$11.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(case "}));
        toMatch.foreach((Function1)new DatabaseAdapter$.anonfun.writeCaseStatement.1($this, sw$11));
        sw$11.indent();
        sw$11.nextLine();
        cases.foreach((Function1)new DatabaseAdapter$.anonfun.writeCaseStatement.2($this, sw$11));
        sw$11.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"else "}));
        $this.writeCastInvocation(otherwise, sw$11);
        sw$11.nextLine();
        sw$11.unindent();
        sw$11.write((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"end)"}));
    }

    public static void $init$(DatabaseAdapter $this) {
        $this.org$squeryl$internals$DatabaseAdapter$_setter_$org$squeryl$internals$DatabaseAdapter$$_declarationHandler_$eq(new DatabaseAdapter$.anon.1($this));
    }
}

