/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.component;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.squirrelframework.foundation.component.SquirrelSingletonProvider;

public class SquirrelConfiguration {
    public static ExecutorService getExecutor() {
        ExecutorService executorService = SquirrelSingletonProvider.getInstance().get(ExecutorService.class);
        if (executorService == null) {
            executorService = SquirrelConfiguration.registerNewExecutorService(1, 120L, TimeUnit.SECONDS);
        }
        return executorService;
    }

    public static ExecutorService registerNewExecutorService(int threadNum, long terminationTimeout, TimeUnit timeUnit) {
        ExecutorService executorService = Executors.newFixedThreadPool(threadNum);
        MoreExecutors.addDelayedShutdownHook((ExecutorService)executorService, (long)terminationTimeout, (TimeUnit)timeUnit);
        SquirrelSingletonProvider.getInstance().register(ExecutorService.class, executorService);
        return executorService;
    }

    public static ScheduledExecutorService getScheduler() {
        ScheduledExecutorService scheduler = SquirrelSingletonProvider.getInstance().get(ScheduledExecutorService.class);
        if (scheduler == null) {
            scheduler = SquirrelConfiguration.registerNewSchedulerService(1, 120L, TimeUnit.SECONDS);
        }
        return scheduler;
    }

    public static ScheduledExecutorService registerNewSchedulerService(int threadNum, long terminationTimeout, TimeUnit timeUnit) {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(threadNum);
        MoreExecutors.addDelayedShutdownHook((ExecutorService)scheduler, (long)terminationTimeout, (TimeUnit)timeUnit);
        SquirrelSingletonProvider.getInstance().register(ScheduledExecutorService.class, scheduler);
        return scheduler;
    }
}

