/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.squirrelframework.foundation.util.Base64Coder;

public abstract class ObjectSerializableSupport {
    public static String serialize(Object data) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(data);
            }
            return new String(Base64Coder.encode(bos.toByteArray()));
        }
        catch (IOException e) {
            throw new RuntimeException("Data serialization failed.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(String value) {
        try {
            byte[] data = Base64Coder.decode(value);
            try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));){
                Object object;
                Object object2 = object = ois.readObject();
                return (T)object2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Data serialization failed.", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

