/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squirrelframework.foundation.component.SquirrelConfiguration;
import org.squirrelframework.foundation.component.impl.AbstractSubject;
import org.squirrelframework.foundation.exception.ErrorCodes;
import org.squirrelframework.foundation.exception.SquirrelRuntimeException;
import org.squirrelframework.foundation.exception.TransitionException;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.ActionExecutionService;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.StateMachineContext;
import org.squirrelframework.foundation.fsm.impl.AbstractStateMachine;
import org.squirrelframework.foundation.fsm.impl.UncallableActionImpl;
import org.squirrelframework.foundation.util.Pair;

public abstract class AbstractExecutionService<T extends StateMachine<T, S, E, C>, S, E, C>
extends AbstractSubject
implements ActionExecutionService<T, S, E, C> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractExecutionService.class);
    protected final LinkedList<Pair<String, List<ActionContext<T, S, E, C>>>> actionBuckets = new LinkedList();
    protected boolean dummyExecution = false;
    private int actionTotalSize = 0;

    @Override
    public void begin(String bucketName) {
        ArrayList actionContext = new ArrayList();
        this.actionBuckets.add(new Pair(bucketName, actionContext));
    }

    @Override
    public void defer(Action<T, S, E, C> action, S from, S to, E event, C context, T stateMachine) {
        Preconditions.checkNotNull(action, (Object)"Action parameter cannot be null.");
        List<ActionContext<T, S, ActionContext<T, S, E, C>, C>> actions = this.actionBuckets.peekLast().second();
        Preconditions.checkNotNull(actions, (Object)"Action bucket currently is empty. Make sure execution service is began.");
        actions.add(ActionContext.get(action, from, to, event, context, stateMachine, ++this.actionTotalSize));
    }

    private void doExecute(String bucketName, List<ActionContext<T, S, E, C>> bucketActions) {
        Preconditions.checkNotNull(bucketActions, (Object)"Action bucket cannot be empty when executing.");
        HashMap futures = Maps.newHashMap();
        int actionSize = bucketActions.size();
        for (int i = 0; i < actionSize; ++i) {
            final ActionContext<T, S, E, C> actionContext = bucketActions.get(i);
            if (actionContext.action.weight() != Integer.MIN_VALUE) {
                try {
                    this.fireEvent(BeforeExecActionEventImpl.get(actionContext.position, this.actionTotalSize, actionContext));
                    if (this.dummyExecution) continue;
                    if (actionContext.action.isAsync()) {
                        final boolean isTestEvent = StateMachineContext.isTestEvent();
                        final StateMachine instance = (StateMachine)StateMachineContext.currentInstance();
                        Future<?> future = SquirrelConfiguration.getExecutor().submit(new Runnable(){

                            @Override
                            public void run() {
                                StateMachineContext.set(instance, isTestEvent);
                                try {
                                    actionContext.run();
                                }
                                finally {
                                    StateMachineContext.set(null);
                                }
                            }
                        });
                        futures.put(actionContext, future);
                        continue;
                    }
                    actionContext.run();
                    continue;
                }
                catch (Exception e) {
                    logger.error("Error during transition", (Throwable)e);
                    Exception t = e instanceof SquirrelRuntimeException ? ((SquirrelRuntimeException)e).getTargetException() : e;
                    TransitionException te = new TransitionException(t, ErrorCodes.FSM_TRANSITION_ERROR, new Object[]{actionContext.from, actionContext.to, actionContext.event, actionContext.context, actionContext.action.name(), e.getMessage()});
                    this.fireEvent(new ExecActionExceptionEventImpl<T, S, E, C>(te, i + 1, actionSize, actionContext));
                    throw te;
                }
                finally {
                    this.fireEvent(AfterExecActionEventImpl.get(i + 1, actionSize, actionContext));
                }
            }
            logger.info("Method call action \"" + actionContext.action.name() + "\" (" + (i + 1) + " of " + actionSize + ") was ignored.");
        }
        for (Map.Entry entry : futures.entrySet()) {
            Future future = (Future)entry.getValue();
            ActionContext actionContext = (ActionContext)entry.getKey();
            try {
                logger.debug("Waiting action '" + actionContext.action.toString() + "' to finish.");
                if (actionContext.action.timeout() >= 0L) {
                    future.get(actionContext.action.timeout(), TimeUnit.MILLISECONDS);
                } else {
                    future.get();
                }
                logger.debug("Action '" + actionContext.action.toString() + "' finished.");
            }
            catch (Exception e) {
                future.cancel(true);
                Throwable t = e;
                if (e instanceof ExecutionException) {
                    t = ((ExecutionException)e).getCause();
                }
                TransitionException te = new TransitionException(t, ErrorCodes.FSM_TRANSITION_ERROR, new Object[]{actionContext.from, actionContext.to, actionContext.event, actionContext.context, actionContext.action.name(), e.getMessage()});
                this.fireEvent(new ExecActionExceptionEventImpl(te, actionContext.position, this.actionTotalSize, actionContext));
                throw te;
            }
        }
    }

    private void executeActions() {
        Pair<String, List<ActionContext<T, S, E, C>>> actionBucket = this.actionBuckets.poll();
        String bucketName = actionBucket.first();
        List<ActionContext<T, S, E, C>> actionContexts = actionBucket.second();
        this.doExecute(bucketName, actionContexts);
        logger.debug("Actions within '" + bucketName + "' invoked.");
    }

    @Override
    public void execute() {
        try {
            while (this.actionBuckets.size() > 0) {
                this.executeActions();
            }
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.actionBuckets.clear();
        this.actionTotalSize = 0;
    }

    @Override
    public void addExecActionListener(ActionExecutionService.BeforeExecActionListener<T, S, E, C> listener) {
        this.addListener(ActionExecutionService.BeforeExecActionEvent.class, listener, ActionExecutionService.BeforeExecActionListener.METHOD);
    }

    @Override
    public void removeExecActionListener(ActionExecutionService.BeforeExecActionListener<T, S, E, C> listener) {
        this.removeListener(ActionExecutionService.BeforeExecActionEvent.class, listener);
    }

    @Override
    public void addExecActionListener(ActionExecutionService.AfterExecActionListener<T, S, E, C> listener) {
        this.addListener(ActionExecutionService.AfterExecActionListener.class, listener, ActionExecutionService.AfterExecActionListener.METHOD);
    }

    @Override
    public void removeExecActionListener(ActionExecutionService.AfterExecActionListener<T, S, E, C> listener) {
        this.removeListener(ActionExecutionService.AfterExecActionListener.class, listener);
    }

    @Override
    public void addExecActionExceptionListener(ActionExecutionService.ExecActionExceptionListener<T, S, E, C> listener) {
        this.addListener(ActionExecutionService.ExecActionExceptionEvent.class, listener, ActionExecutionService.ExecActionExceptionListener.METHOD);
    }

    @Override
    public void removeExecActionExceptionListener(ActionExecutionService.ExecActionExceptionListener<T, S, E, C> listener) {
        this.removeListener(ActionExecutionService.ExecActionExceptionEvent.class, listener);
    }

    @Override
    public void setDummyExecution(boolean dummyExecution) {
        this.dummyExecution = dummyExecution;
    }

    static class ActionContext<T extends StateMachine<T, S, E, C>, S, E, C> {
        final Action<T, S, E, C> action;
        final S from;
        final S to;
        final E event;
        final C context;
        final T fsm;
        final int position;

        private ActionContext(Action<T, S, E, C> action, S from, S to, E event, C context, T stateMachine, int position) {
            this.action = action;
            this.from = from;
            this.to = to;
            this.event = event;
            this.context = context;
            this.fsm = stateMachine;
            this.position = position;
        }

        static <T extends StateMachine<T, S, E, C>, S, E, C> ActionContext<T, S, E, C> get(Action<T, S, E, C> action, S from, S to, E event, C context, T stateMachine, int position) {
            return new ActionContext<T, S, E, C>(action, from, to, event, context, stateMachine, position);
        }

        void run() {
            AbstractStateMachine fsmImpl = (AbstractStateMachine)this.fsm;
            fsmImpl.beforeActionInvoked(this.from, this.to, this.event, this.context);
            this.action.execute(this.from, this.to, this.event, this.context, this.fsm);
            fsmImpl.afterActionInvoked(this.from, this.to, this.event, this.context);
        }
    }

    static abstract class AbstractExecActionEvent<T extends StateMachine<T, S, E, C>, S, E, C>
    implements ActionExecutionService.ActionEvent<T, S, E, C> {
        private ActionContext<T, S, E, C> executionContext;
        private int pos;
        private int size;

        AbstractExecActionEvent(int pos, int size, ActionContext<T, S, E, C> actionContext) {
            this.pos = pos;
            this.size = size;
            this.executionContext = actionContext;
        }

        @Override
        public Action<T, S, E, C> getExecutionTarget() {
            return new UncallableActionImpl(this.executionContext.action);
        }

        @Override
        public S getFrom() {
            return this.executionContext.from;
        }

        @Override
        public S getTo() {
            return this.executionContext.to;
        }

        @Override
        public E getEvent() {
            return this.executionContext.event;
        }

        @Override
        public C getContext() {
            return this.executionContext.context;
        }

        @Override
        public T getStateMachine() {
            return this.executionContext.fsm;
        }

        @Override
        public int[] getMOfN() {
            return new int[]{this.pos, this.size};
        }
    }

    static class AfterExecActionEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractExecActionEvent<T, S, E, C>
    implements ActionExecutionService.AfterExecActionEvent<T, S, E, C> {
        AfterExecActionEventImpl(int pos, int size, ActionContext<T, S, E, C> actionContext) {
            super(pos, size, actionContext);
        }

        static <T extends StateMachine<T, S, E, C>, S, E, C> ActionExecutionService.AfterExecActionEvent<T, S, E, C> get(int pos, int size, ActionContext<T, S, E, C> actionContext) {
            return new AfterExecActionEventImpl<T, S, E, C>(pos, size, actionContext);
        }
    }

    static class BeforeExecActionEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractExecActionEvent<T, S, E, C>
    implements ActionExecutionService.BeforeExecActionEvent<T, S, E, C> {
        BeforeExecActionEventImpl(int pos, int size, ActionContext<T, S, E, C> actionContext) {
            super(pos, size, actionContext);
        }

        static <T extends StateMachine<T, S, E, C>, S, E, C> ActionExecutionService.BeforeExecActionEvent<T, S, E, C> get(int pos, int size, ActionContext<T, S, E, C> actionContext) {
            return new BeforeExecActionEventImpl<T, S, E, C>(pos, size, actionContext);
        }
    }

    static class ExecActionExceptionEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractExecActionEvent<T, S, E, C>
    implements ActionExecutionService.ExecActionExceptionEvent<T, S, E, C> {
        private final TransitionException e;

        ExecActionExceptionEventImpl(TransitionException e, int pos, int size, ActionContext<T, S, E, C> actionContext) {
            super(pos, size, actionContext);
            this.e = e;
        }

        @Override
        public TransitionException getException() {
            return this.e;
        }
    }
}

