/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squirrelframework.foundation.fsm.Condition;
import org.squirrelframework.foundation.fsm.MvelScriptManager;

class MvelConditionImpl<C>
implements Condition<C> {
    private static final Logger logger = LoggerFactory.getLogger(MvelConditionImpl.class);
    private final String mvelExpression;
    private final String name;
    private final MvelScriptManager scriptManager;
    private final String script;

    MvelConditionImpl(String script, MvelScriptManager scriptManager) {
        String[] arrays = StringUtils.split((String)script, (String)":::");
        if (arrays.length == 2) {
            this.name = arrays[0].trim();
            this.mvelExpression = arrays[1].trim();
        } else {
            this.name = "_NoName_";
            this.mvelExpression = arrays[0].trim();
        }
        this.script = script;
        this.scriptManager = scriptManager;
        scriptManager.compile(this.mvelExpression);
    }

    @Override
    public boolean isSatisfied(C context) {
        try {
            HashMap<String, C> variables = new HashMap<String, C>();
            variables.put("context", context);
            return this.scriptManager.evalBoolean(this.mvelExpression, variables);
        }
        catch (Exception e) {
            logger.error("Evaluate \"" + this.mvelExpression + "\" failed with " + e.getMessage() + (e.getCause() != null ? ", which caused by " + e.getCause().getMessage() : ""));
            return false;
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    public final String toString() {
        return "mvel#" + this.script;
    }
}

