/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringEscapeUtils;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.HistoryType;
import org.squirrelframework.foundation.fsm.ImmutableState;
import org.squirrelframework.foundation.fsm.ImmutableTransition;
import org.squirrelframework.foundation.fsm.SCXMLVisitor;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.impl.AbstractVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

class SCXMLVisitorImpl
extends AbstractVisitor
implements SCXMLVisitor {
    SCXMLVisitorImpl() {
    }

    @Override
    public void visitOnEntry(StateMachine<?, ?, ?, ?> visitable) {
        this.writeLine("<scxml initial=" + this.quoteEnumName(visitable.getInitialState()) + " version=\"1.0\" xmlns=\"http://www.w3.org/2005/07/scxml\" xmlns:sqrl=\"http://squirrelframework.org/squirrel\">");
        this.writeLine("<sqrl:fsm " + visitable.getDescription() + " />");
    }

    @Override
    public void visitOnExit(StateMachine<?, ?, ?, ?> visitable) {
        this.writeLine("</scxml>");
    }

    @Override
    public void visitOnEntry(ImmutableState<?, ?, ?, ?> visitable) {
        if (visitable.isParallelState()) {
            this.writeLine("<parallel id= " + this.quoteEnumName(visitable) + ">");
        } else if (visitable.isFinalState()) {
            this.writeLine("<final id= " + this.quoteEnumName(visitable) + ">");
        } else {
            StringBuilder builder = new StringBuilder("<state id= ");
            builder.append(this.quoteEnumName(visitable));
            if (visitable.getInitialState() != null) {
                builder.append(" initial= ").append(this.quoteEnumName(visitable.getInitialState()));
            }
            builder.append(">");
            this.writeLine(builder.toString());
        }
        if (!visitable.getEntryActions().isEmpty()) {
            this.writeLine("<onentry>");
            for (Action<?, ?, ?, ?> entryAction : visitable.getEntryActions()) {
                this.writeAction(entryAction);
            }
            this.writeLine("</onentry>");
        }
        if (visitable.getHistoryType() != HistoryType.NONE) {
            this.writeLine("<history type= " + this.quoteName(visitable.getHistoryType().name().toLowerCase()) + "/>");
        }
    }

    @Override
    public void visitOnExit(ImmutableState<?, ?, ?, ?> visitable) {
        if (!visitable.getExitActions().isEmpty()) {
            this.writeLine("<onexit>");
            for (Action<?, ?, ?, ?> exitAction : visitable.getExitActions()) {
                this.writeAction(exitAction);
            }
            this.writeLine("</onexit>");
        }
        if (visitable.isParallelState()) {
            this.writeLine("</parallel>");
        } else if (visitable.isFinalState()) {
            this.writeLine("</final>");
        } else {
            this.writeLine("</state>");
        }
    }

    @Override
    public void visitOnEntry(ImmutableTransition<?, ?, ?, ?> visitable) {
        this.writeLine("<transition event=" + this.quoteEnumName(visitable.getEvent()) + " sqrl:priority=" + this.quoteName(Integer.toString(visitable.getPriority())) + " sqrl:type=" + this.quoteName(visitable.getType().toString()) + " target=" + this.quoteEnumName(visitable.getTargetState()) + " cond=" + this.quoteName(StringEscapeUtils.escapeXml((String)visitable.getCondition().toString())) + ">");
        for (Action<?, ?, ?, ?> action : visitable.getActions()) {
            this.writeAction(action);
        }
    }

    @Override
    public void visitOnExit(ImmutableTransition<?, ?, ?, ?> visitable) {
        this.writeLine("</transition>");
    }

    private void writeAction(Action<?, ?, ?, ?> action) {
        if (this.isExternalAction(action)) {
            this.writeLine("<sqrl:action content=" + this.quoteName(action.toString()) + "/>");
        }
    }

    private boolean isExternalAction(Action<?, ?, ?, ?> action) {
        return !action.name().startsWith("__");
    }

    @Override
    public String getScxml(boolean beautifyXml) {
        return beautifyXml ? this.beautify(this.buffer.toString()) : this.buffer.toString();
    }

    @Override
    public void convertSCXMLFile(String filename, boolean beautifyXml) {
        this.saveFile(filename + ".scxml", this.getScxml(beautifyXml));
    }

    private String beautify(String unformattedXml) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(unformattedXml));
            Document doc = db.parse(is);
            DOMImplementationRegistry domReg = DOMImplementationRegistry.newInstance();
            DOMImplementationLS lsImpl = (DOMImplementationLS)((Object)domReg.getDOMImplementation("LS"));
            LSSerializer lsSerializer = lsImpl.createLSSerializer();
            lsSerializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            LSOutput output = lsImpl.createLSOutput();
            output.setEncoding("UTF-8");
            StringWriter destination = new StringWriter();
            output.setCharacterStream(destination);
            lsSerializer.write(doc, output);
            return destination.toString();
        }
        catch (Exception e) {
            return unformattedXml;
        }
    }
}

