/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squirrelframework.foundation.fsm.ImmutableState;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.StateMachineData;

public class StateMachineDataImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements StateMachineData<T, S, E, C>,
StateMachineData.Reader<T, S, E, C>,
StateMachineData.Writer<T, S, E, C> {
    private static final long serialVersionUID = 4102325896046410596L;
    private static final Logger logger = LoggerFactory.getLogger(StateMachineDataImpl.class);
    private S currentState;
    private S lastState;
    private S initialState;
    private final Map<S, S> lastActiveChildStateStore = Maps.newHashMap();
    private final ListMultimap<S, S> parallelStatesStore = ArrayListMultimap.create();
    private Class<? extends T> stateMachineType;
    private Class<S> stateType;
    private Class<E> eventType;
    private Class<C> contextType;
    private String identifier;
    private Object startContext;
    private final transient Map<S, ImmutableState<T, S, E, C>> states;
    private Map<S, StateMachineData.Reader<? extends StateMachine<?, S, E, C>, S, E, C>> linkStateDataStore;

    public StateMachineDataImpl(Map<S, ImmutableState<T, S, E, C>> states) {
        this.states = Collections.unmodifiableMap(states);
    }

    public StateMachineDataImpl() {
        this.states = null;
    }

    @Override
    public Map<S, ImmutableState<T, S, E, C>> originalStates() {
        if (this.states == null) {
            return Collections.emptyMap();
        }
        return this.states;
    }

    private void clear() {
        this.currentState = null;
        this.lastState = null;
        this.initialState = null;
        this.stateMachineType = null;
        this.stateType = null;
        this.eventType = null;
        this.contextType = null;
        this.identifier = null;
        this.startContext = null;
        if (this.lastActiveChildStateStore != null) {
            this.lastActiveChildStateStore.clear();
        }
        if (this.parallelStatesStore != null) {
            this.parallelStatesStore.clear();
        }
        if (this.linkStateDataStore != null) {
            this.linkStateDataStore.clear();
        }
    }

    @Override
    public void dump(StateMachineData.Reader<T, S, E, C> src) {
        this.clear();
        this.write().typeOfStateMachine(src.typeOfStateMachine());
        this.write().typeOfState(src.typeOfState());
        this.write().typeOfEvent(src.typeOfEvent());
        this.write().typeOfContext(src.typeOfContext());
        this.write().identifier(src.identifier());
        this.write().currentState(src.currentState());
        this.write().lastState(src.lastState());
        this.write().initialState(src.initialState());
        this.write().startContext(src.startContext());
        for (S state : src.activeParentStates()) {
            S lastActiveChildState = src.lastActiveChildStateOf(state);
            if (lastActiveChildState == null) continue;
            this.write().lastActiveChildStateFor(state, lastActiveChildState);
        }
        for (S state : src.parallelStates()) {
            List<S> subStates = src.subStatesOn(state);
            if (subStates == null || subStates.isEmpty()) continue;
            for (S subState : subStates) {
                this.parallelStatesStore.put(state, subState);
            }
        }
    }

    private Map<S, StateMachineData.Reader<? extends StateMachine<?, S, E, C>, S, E, C>> getLinkedStateData() {
        if (this.linkStateDataStore == null) {
            this.linkStateDataStore = Maps.newHashMap();
        }
        return this.linkStateDataStore;
    }

    @Override
    public StateMachineData.Reader<T, S, E, C> read() {
        return this;
    }

    @Override
    public StateMachineData.Writer<T, S, E, C> write() {
        return this;
    }

    @Override
    public void currentState(S currentStateId) {
        this.currentState = currentStateId;
    }

    @Override
    public void lastState(S lastStateId) {
        this.lastState = lastStateId;
    }

    @Override
    public void initialState(S initialStateId) {
        this.initialState = initialStateId;
    }

    @Override
    public void startContext(C context) {
        if (context != null && context instanceof Serializable) {
            this.startContext = context;
        }
    }

    @Override
    public void lastActiveChildStateFor(S parentStateId, S childStateId) {
        this.lastActiveChildStateStore.put(parentStateId, childStateId);
    }

    @Override
    public void subStateFor(S parentStateId, S subStateId) {
        if (this.rawStateFrom(parentStateId) != null && this.rawStateFrom(parentStateId).isParallelState()) {
            this.parallelStatesStore.put(parentStateId, subStateId);
        } else {
            logger.warn("Cannot set sub states on none parallel state {}.", parentStateId);
        }
    }

    @Override
    public void removeSubState(S parentStateId, S subStateId) {
        if (this.rawStateFrom(parentStateId) != null && this.rawStateFrom(parentStateId).isParallelState()) {
            this.parallelStatesStore.remove(parentStateId, subStateId);
        } else {
            logger.warn("Cannot remove sub states on none parallel state {}.", parentStateId);
        }
    }

    @Override
    public void removeSubStatesOn(S parentStateId) {
        if (this.rawStateFrom(parentStateId).isParallelState()) {
            this.parallelStatesStore.removeAll(parentStateId);
        }
    }

    @Override
    public void identifier(String id) {
        this.identifier = id;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public S currentState() {
        return this.currentState;
    }

    @Override
    public S lastState() {
        return this.lastState;
    }

    @Override
    public S initialState() {
        return this.initialState;
    }

    @Override
    public S lastActiveChildStateOf(S parentStateId) {
        return this.lastActiveChildStateStore.get(parentStateId);
    }

    @Override
    public C startContext() {
        return (C)this.startContext;
    }

    @Override
    public Collection<S> activeParentStates() {
        return Collections.unmodifiableCollection(this.lastActiveChildStateStore.keySet());
    }

    @Override
    public List<S> subStatesOn(S parentStateId) {
        List subStates = this.parallelStatesStore.get(parentStateId);
        return subStates != null ? Collections.unmodifiableList(subStates) : Collections.emptyList();
    }

    @Override
    public ImmutableState<T, S, E, C> currentRawState() {
        return this.currentState != null ? this.rawStateFrom(this.currentState) : null;
    }

    @Override
    public ImmutableState<T, S, E, C> lastRawState() {
        return this.rawStateFrom(this.lastState);
    }

    @Override
    public ImmutableState<T, S, E, C> rawStateFrom(S stateId) {
        if (stateId == null) {
            return null;
        }
        ImmutableState<T, S, E, C> rawState = this.originalStates().get(stateId);
        return rawState != null ? rawState.getThis() : null;
    }

    @Override
    public ImmutableState<T, S, E, C> initialRawState() {
        return this.rawStateFrom(this.initialState());
    }

    @Override
    public Class<? extends T> typeOfStateMachine() {
        return this.stateMachineType;
    }

    @Override
    public Class<S> typeOfState() {
        return this.stateType;
    }

    @Override
    public Class<E> typeOfEvent() {
        return this.eventType;
    }

    @Override
    public Class<C> typeOfContext() {
        return this.contextType;
    }

    @Override
    public void typeOfStateMachine(Class<? extends T> stateMachineType) {
        Preconditions.checkState((this.stateMachineType == null ? 1 : 0) != 0);
        this.stateMachineType = stateMachineType;
    }

    @Override
    public void typeOfState(Class<S> stateClass) {
        Preconditions.checkState((this.stateType == null ? 1 : 0) != 0);
        this.stateType = stateClass;
    }

    @Override
    public void typeOfEvent(Class<E> eventClass) {
        Preconditions.checkState((this.eventType == null ? 1 : 0) != 0);
        this.eventType = eventClass;
    }

    @Override
    public void typeOfContext(Class<C> contextClass) {
        Preconditions.checkState((this.contextType == null ? 1 : 0) != 0);
        this.contextType = contextClass;
    }

    @Override
    public Collection<ImmutableState<T, S, E, C>> rawStates() {
        return Collections.unmodifiableCollection(this.originalStates().values());
    }

    @Override
    public Collection<S> states() {
        return Collections.unmodifiableCollection(this.originalStates().keySet());
    }

    @Override
    public Collection<S> parallelStates() {
        return Collections.unmodifiableCollection(this.parallelStatesStore.keySet());
    }

    @Override
    public Collection<S> linkedStates() {
        if (this.linkStateDataStore == null || this.linkStateDataStore.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(this.linkStateDataStore.keySet());
    }

    @Override
    public StateMachineData.Reader<? extends StateMachine<?, S, E, C>, S, E, C> linkedStateDataOf(S linkedState) {
        if (this.linkStateDataStore != null && !this.linkStateDataStore.isEmpty()) {
            return this.linkStateDataStore.get(linkedState);
        }
        return null;
    }

    @Override
    public void linkedStateDataOn(S linkedState, StateMachineData.Reader<? extends StateMachine<?, S, E, C>, S, E, C> linkStateData) {
        this.getLinkedStateData().put(linkedState, linkStateData);
    }
}

