/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.contract;

import org.srplib.contract.Utils;

public class Assert {
    public static void checkTrue(boolean expression, String messageFormat, Object ... arguments) {
        if (!expression) {
            throw new IllegalStateException(Utils.format(messageFormat, arguments));
        }
    }

    public static void checkFalse(boolean expression, String messageFormat, Object ... arguments) {
        Assert.checkTrue(!expression, messageFormat, arguments);
    }

    public static void checkNull(Object object, String messageFormat, Object ... arguments) {
        Assert.checkTrue(object == null, messageFormat, arguments);
    }

    public static void checkNotNull(Object object, String messageFormat, Object ... arguments) {
        Assert.checkTrue(object != null, messageFormat, arguments);
    }

    public static void checkBlank(String string, String messageFormat, Object ... arguments) {
        Assert.checkTrue(Utils.isBlank(string), messageFormat, arguments);
    }

    public static void checkNotBlank(String string, String messageFormat, Object ... arguments) {
        Assert.checkTrue(!Utils.isBlank(string), messageFormat, arguments);
    }

    public static void checkEqual(Object object1, Object object2, String messageFormat, Object ... arguments) {
        Assert.checkTrue(Utils.equals(object1, object2), messageFormat, arguments);
    }

    public static void checkNotEqual(Object object1, Object object2, String messageFormat, Object ... arguments) {
        Assert.checkTrue(!Utils.equals(object1, object2), messageFormat, arguments);
    }

    public static void fail(String messageFormat, Object ... arguments) {
        Assert.checkTrue(false, messageFormat, arguments);
    }
}

