/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.redis;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.ssssssss.magicapi.core.annotation.MagicModule;
import org.ssssssss.script.functions.DynamicMethod;

@MagicModule(value="redis")
public class RedisModule
implements DynamicMethod {
    private final StringRedisTemplate redisTemplate;

    public RedisModule(RedisConnectionFactory connectionFactory) {
        this.redisTemplate = new StringRedisTemplate(connectionFactory);
    }

    private byte[] serializer(Object value) {
        if (value == null || value instanceof String) {
            return this.redisTemplate.getStringSerializer().serialize((Object)((String)value));
        }
        return this.serializer(value.toString());
    }

    private Object deserialize(Object value) {
        if (value != null) {
            if (value instanceof byte[]) {
                return this.redisTemplate.getStringSerializer().deserialize((byte[])value);
            }
            if (value instanceof List) {
                List valueList = (List)value;
                ArrayList<Object> resultList = new ArrayList<Object>(valueList.size());
                for (Object val2 : valueList) {
                    resultList.add(this.deserialize(val2));
                }
                return resultList;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                LinkedHashMap newMap = new LinkedHashMap(map.size());
                map.forEach((key, val) -> newMap.put(this.deserialize(key), this.deserialize(val)));
                return newMap;
            }
        }
        return value;
    }

    public Object execute(String methodName, List<Object> parameters) {
        return this.redisTemplate.execute(connection -> {
            byte[][] params = new byte[parameters.size()][];
            for (int i = 0; i < params.length; ++i) {
                params[i] = this.serializer(parameters.get(i));
            }
            return this.deserialize(connection.execute(methodName, (byte[][])params));
        });
    }
}

