/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.swagger.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.core.config.MagicConfiguration;
import org.ssssssss.magicapi.core.model.ApiInfo;
import org.ssssssss.magicapi.core.model.BaseDefinition;
import org.ssssssss.magicapi.core.model.DataType;
import org.ssssssss.magicapi.core.service.MagicResourceService;
import org.ssssssss.magicapi.core.service.impl.RequestMagicDynamicRegistry;
import org.ssssssss.magicapi.swagger.entity.SwaggerEntity;
import org.ssssssss.magicapi.utils.JsonUtils;
import org.ssssssss.magicapi.utils.PathUtils;
import org.ssssssss.script.parsing.ast.literal.BooleanLiteral;

public class SwaggerProvider {
    private static final String DEFINITION = "#/definitions/";
    private static final String BODY_EMPTY = "{}";
    private final Map<String, Object> DEFINITION_MAP = new ConcurrentHashMap<String, Object>();
    private final RequestMagicDynamicRegistry requestMagicDynamicRegistry;
    private final MagicResourceService magicResourceService;
    private final String basePath;
    private final SwaggerEntity.Info info;
    private final boolean persistenceResponseBody;
    private final String prefix;
    private final Map<String, Object> securityDefinitionMap;
    private final Map<String, Object> securityMap;

    public SwaggerProvider(RequestMagicDynamicRegistry requestMagicDynamicRegistry, MagicResourceService magicResourceService, String basePath, SwaggerEntity.Info info, boolean persistenceResponseBody, String prefix, Map<String, Object> securityDefinitionMap, Map<String, Object> securityMap) {
        this.requestMagicDynamicRegistry = requestMagicDynamicRegistry;
        this.magicResourceService = magicResourceService;
        this.basePath = basePath;
        this.info = info;
        this.persistenceResponseBody = persistenceResponseBody;
        this.prefix = (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + "/";
        this.securityDefinitionMap = securityDefinitionMap;
        this.securityMap = securityMap;
    }

    @ResponseBody
    public SwaggerEntity swaggerJson() {
        this.DEFINITION_MAP.clear();
        List infos = this.requestMagicDynamicRegistry.mappings();
        SwaggerEntity swaggerEntity = new SwaggerEntity();
        swaggerEntity.setInfo(this.info);
        swaggerEntity.setBasePath(this.basePath);
        swaggerEntity.addSecurityDefinitions(this.securityDefinitionMap);
        swaggerEntity.addSecurity(this.securityMap);
        for (ApiInfo info : infos) {
            String groupName = this.magicResourceService.getGroupName(info.getGroupId()).replace("/", "-");
            String requestPath = PathUtils.replaceSlash((String)(this.prefix + this.magicResourceService.getGroupPath(info.getGroupId()) + "/" + info.getPath()));
            SwaggerEntity.Path path = new SwaggerEntity.Path(info.getId());
            path.addTag(groupName);
            boolean hasBody = false;
            try {
                List<Map<String, Object>> parameters = this.parseParameters(info);
                hasBody = parameters.stream().anyMatch(it -> "body".equals(it.get("in")));
                BaseDefinition baseDefinition = info.getRequestBodyDefinition();
                if (hasBody && baseDefinition != null) {
                    this.doProcessDefinition(baseDefinition, info, groupName, "root_", "request", 0);
                }
                parameters.forEach(path::addParameter);
                if (this.persistenceResponseBody) {
                    baseDefinition = info.getResponseBodyDefinition();
                    if (baseDefinition != null) {
                        Map<String, Object> responseMap = this.parseResponse(info);
                        if (!responseMap.isEmpty()) {
                            path.setResponses(responseMap);
                            this.doProcessDefinition(baseDefinition, info, groupName, "root_" + baseDefinition.getName(), "response", 0);
                        }
                    } else {
                        path.addResponse("200", JsonUtils.readValue((String)Objects.toString(info.getResponseBody(), BODY_EMPTY), Object.class));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (hasBody) {
                path.addConsume("application/json");
            } else {
                path.addConsume("*/*");
            }
            path.addProduce("application/json");
            path.setSummary(info.getName());
            path.setDescription((String)StringUtils.defaultIfBlank((CharSequence)info.getDescription(), (CharSequence)info.getName()));
            swaggerEntity.addPath(requestPath, info.getMethod(), path);
        }
        if (this.DEFINITION_MAP.size() > 0) {
            Set<Map.Entry<String, Object>> entries = this.DEFINITION_MAP.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                swaggerEntity.addDefinitions(entry.getKey(), entry.getValue());
            }
        }
        return swaggerEntity;
    }

    private List<Map<String, Object>> parseParameters(ApiInfo info) {
        ArrayList<Map<String, Object>> parameters = new ArrayList<Map<String, Object>>();
        info.getParameters().forEach(it -> parameters.add(SwaggerEntity.createParameter(it.isRequired(), it.getName(), "query", it.getDataType().getJavascriptType(), it.getDescription(), it.getValue())));
        info.getHeaders().forEach(it -> parameters.add(SwaggerEntity.createParameter(it.isRequired(), it.getName(), "header", it.getDataType().getJavascriptType(), it.getDescription(), it.getValue())));
        ArrayList paths = new ArrayList(info.getPaths());
        MagicConfiguration.getMagicResourceService().getGroupsByFileId(info.getId()).stream().flatMap(it -> it.getPaths().stream()).filter(it -> !paths.contains(it)).forEach(paths::add);
        paths.forEach(it -> parameters.add(SwaggerEntity.createParameter(it.isRequired(), it.getName(), "path", it.getDataType().getJavascriptType(), it.getDescription(), it.getValue())));
        try {
            BaseDefinition baseDefinition = info.getRequestBodyDefinition();
            if (baseDefinition != null && !CollectionUtils.isEmpty((Collection)baseDefinition.getChildren())) {
                Map<String, Object> parameter = SwaggerEntity.createParameter(baseDefinition.isRequired(), StringUtils.isNotBlank((CharSequence)baseDefinition.getName()) ? baseDefinition.getName() : "body", "body", baseDefinition.getDataType().getJavascriptType(), baseDefinition.getDescription(), baseDefinition);
                HashMap<String, Object> schema = new HashMap<String, Object>(2);
                String groupName = this.magicResourceService.getGroupName(info.getGroupId()).replace("/", "-");
                String voName = groupName + "\u00ab" + info.getPath().replaceFirst("/", "").replaceAll("/", "_") + "\u00abrequest\u00ab";
                if (DataType.Array == baseDefinition.getDataType()) {
                    voName = voName + "root_" + (StringUtils.isNotBlank((CharSequence)baseDefinition.getName()) ? baseDefinition.getName() + "_" : "_") + "\u00bb\u00bb\u00bb";
                    HashMap<String, String> items = new HashMap<String, String>(2);
                    items.put("originalRef", voName);
                    items.put("$ref", DEFINITION + voName);
                    schema.put("items", items);
                    schema.put("type", "array");
                } else {
                    voName = voName + "root_" + baseDefinition.getName() + "\u00bb\u00bb\u00bb";
                    schema.put("originalRef", voName);
                    schema.put("$ref", DEFINITION + voName);
                }
                parameter.put("schema", schema);
                parameters.add(parameter);
            } else if (StringUtils.isNotBlank((CharSequence)info.getRequestBody())) {
                boolean isListOrMap;
                Object object = JsonUtils.readValue((String)info.getResponseBody(), Object.class);
                boolean bl = isListOrMap = object instanceof List || object instanceof Map;
                if (isListOrMap && BooleanLiteral.isTrue((Object)object)) {
                    parameters.add(SwaggerEntity.createParameter(false, "body", "body", object instanceof List ? "array" : "object", null, object));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parameters;
    }

    private Map<String, Object> parseResponse(ApiInfo info) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        BaseDefinition baseDefinition = info.getResponseBodyDefinition();
        if (!CollectionUtils.isEmpty((Collection)baseDefinition.getChildren())) {
            String groupName = this.magicResourceService.getGroupName(info.getGroupId()).replace("/", "-");
            String voName = groupName + "\u00ab" + info.getPath().replaceFirst("/", "").replaceAll("/", "_") + "\u00abresponse\u00ab";
            voName = voName + "root_" + baseDefinition.getName() + "\u00bb\u00bb\u00bb";
            HashMap<String, String> schema = new HashMap<String, String>(2);
            schema.put("originalRef", voName);
            schema.put("$ref", DEFINITION + voName);
            HashMap<String, Object> response = new HashMap<String, Object>(2);
            response.put("description", "OK");
            response.put("schema", schema);
            result.put("200", response);
        }
        return result;
    }

    private Map<String, Object> doProcessDefinition(BaseDefinition target, ApiInfo info, String groupName, String parentName, String definitionType, int level) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("description", target.getDescription());
        if (DataType.Array == target.getDataType()) {
            if (!CollectionUtils.isEmpty((Collection)target.getChildren())) {
                result.put("items", this.doProcessDefinition((BaseDefinition)target.getChildren().get(0), info, groupName, parentName + target.getName() + "_", definitionType, level + 1));
            } else {
                result.put("items", Collections.emptyList());
            }
            result.put("type", target.getDataType().getJavascriptType());
        } else if (DataType.Object == target.getDataType() || DataType.Any == target.getDataType()) {
            String voName = groupName + "\u00ab" + info.getPath().replaceFirst("/", "").replaceAll("/", "_") + (StringUtils.equals((CharSequence)"response", (CharSequence)definitionType) ? "\u00abresponse\u00ab" : "\u00abrequest\u00ab") + parentName + target.getName() + "\u00bb\u00bb\u00bb";
            HashMap<String, Object> definition = new HashMap<String, Object>(4);
            HashMap<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>(target.getChildren().size());
            HashSet<String> requiredSet = new HashSet<String>(target.getChildren().size());
            for (BaseDefinition obj : target.getChildren()) {
                properties.put(obj.getName(), this.doProcessDefinition(obj, info, groupName, parentName + target.getName() + "_", definitionType, level + 1));
                if (!obj.isRequired()) continue;
                requiredSet.add(obj.getName());
            }
            definition.put("properties", properties);
            definition.put("description", target.getDescription());
            definition.put("type", target.getDataType().getJavascriptType());
            definition.put("required", requiredSet);
            if (this.DEFINITION_MAP.containsKey(voName)) {
                voName = voName.replace("\u00bb\u00bb\u00bb", "_" + level + "\u00bb\u00bb\u00bb");
            }
            this.DEFINITION_MAP.put(voName, definition);
            result.put("originalRef", voName);
            result.put("$ref", DEFINITION + voName);
        } else {
            result.put("example", target.getValue());
            result.put("type", target.getDataType().getJavascriptType());
        }
        return result;
    }
}

