/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.spring.boot.starter;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.ssssssss.magicapi.core.config.MagicAPIProperties;
import org.ssssssss.magicapi.utils.PathUtils;

@Component
@ConditionalOnProperty(name={"magic-api.show-url"}, havingValue="true", matchIfMissing=true)
@Order
public class ApplicationUriPrinter
implements CommandLineRunner {
    @Value(value="${server.port:8080}")
    private int port;
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;
    @Autowired
    private MagicAPIProperties properties;

    public void run(String ... args) throws Exception {
        System.out.println("********************************************\u5f53\u524d\u670d\u52a1\u76f8\u5173\u5730\u5740********************************************");
        String ip = "IP";
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            System.out.println("\u5f53\u524d\u670d\u52a1\u5730\u5740\u83b7\u53d6\u5931\u8d25");
        }
        String magicWebPath = this.properties.getWeb();
        String schema = "http://";
        String localUrl = schema + PathUtils.replaceSlash((String)String.format("localhost:%s/%s/%s/", this.port, this.contextPath, Objects.toString(this.properties.getPrefix(), "")));
        String externUrl = schema + PathUtils.replaceSlash((String)String.format("%s:%s/%s/%s/", ip, this.port, this.contextPath, Objects.toString(this.properties.getPrefix(), "")));
        System.out.printf("\u670d\u52a1\u542f\u52a8\u6210\u529f\uff0cmagic-api\u5df2\u5185\u7f6e\u542f\u52a8! Access URLs:\n\t\u63a5\u53e3\u672c\u5730\u5730\u5740: \t\t%s\n\t\u63a5\u53e3\u5916\u90e8\u5730\u5740: \t\t%s\n", localUrl, externUrl);
        if (!StringUtils.isEmpty((CharSequence)magicWebPath)) {
            String webPath = schema + PathUtils.replaceSlash((String)String.format("%s:%s/%s/%s/index.html", ip, this.port, this.contextPath, magicWebPath));
            System.out.println("\t\u63a5\u53e3\u914d\u7f6e\u5e73\u53f0: \t\t" + webPath);
        }
        System.out.println("\t\u53ef\u901a\u8fc7\u914d\u7f6e\u5173\u95ed\u8f93\u51fa: \tmagic-api.show-url=false");
        System.out.println("********************************************\u5f53\u524d\u670d\u52a1\u76f8\u5173\u5730\u5740********************************************");
    }
}

