/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.spring.boot.starter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.ssssssss.magicapi.core.config.MagicAPIProperties;
import org.ssssssss.magicapi.core.service.MagicResourceStorage;
import org.ssssssss.magicapi.core.service.impl.ApiInfoMagicResourceStorage;
import org.ssssssss.magicapi.core.service.impl.RequestMagicDynamicRegistry;
import org.ssssssss.magicapi.datasource.model.MagicDynamicDataSource;
import org.ssssssss.magicapi.datasource.service.DataSourceInfoMagicResourceStorage;
import org.ssssssss.magicapi.datasource.service.DataSourceMagicDynamicRegistry;
import org.ssssssss.magicapi.function.service.FunctionInfoMagicResourceStorage;
import org.ssssssss.magicapi.function.service.FunctionMagicDynamicRegistry;
import org.ssssssss.magicapi.spring.boot.starter.MagicModuleConfiguration;
import org.ssssssss.magicapi.utils.Mapping;

@Configuration
@AutoConfigureAfter(value={MagicModuleConfiguration.class})
public class MagicDynamicRegistryConfiguration {
    private final MagicAPIProperties properties;
    @Autowired
    @Lazy
    private RequestMappingHandlerMapping requestMappingHandlerMapping;

    public MagicDynamicRegistryConfiguration(MagicAPIProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiInfoMagicResourceStorage apiInfoMagicResourceStorage() {
        return new ApiInfoMagicResourceStorage(this.properties.getPrefix());
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestMagicDynamicRegistry magicRequestMagicDynamicRegistry(ApiInfoMagicResourceStorage apiInfoMagicResourceStorage) throws NoSuchMethodException {
        return new RequestMagicDynamicRegistry((MagicResourceStorage)apiInfoMagicResourceStorage, Mapping.create((RequestMappingHandlerMapping)this.requestMappingHandlerMapping, (String)this.properties.getWeb()), this.properties.isAllowOverride(), this.properties.getPrefix());
    }

    @Bean
    @ConditionalOnMissingBean
    public FunctionInfoMagicResourceStorage functionInfoMagicResourceStorage() {
        return new FunctionInfoMagicResourceStorage();
    }

    @Bean
    @ConditionalOnMissingBean
    public FunctionMagicDynamicRegistry functionMagicDynamicRegistry(FunctionInfoMagicResourceStorage functionInfoMagicResourceStorage) {
        return new FunctionMagicDynamicRegistry((MagicResourceStorage)functionInfoMagicResourceStorage);
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSourceInfoMagicResourceStorage dataSourceInfoMagicResourceStorage() {
        return new DataSourceInfoMagicResourceStorage();
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSourceMagicDynamicRegistry dataSourceMagicDynamicRegistry(DataSourceInfoMagicResourceStorage dataSourceInfoMagicResourceStorage, MagicDynamicDataSource magicDynamicDataSource) {
        return new DataSourceMagicDynamicRegistry((MagicResourceStorage)dataSourceInfoMagicResourceStorage, magicDynamicDataSource);
    }
}

