/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.interceptor;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ssssssss.magicapi.core.config.Constants;
import org.ssssssss.magicapi.core.context.RequestEntity;
import org.ssssssss.magicapi.modules.db.model.Page;
import org.ssssssss.magicapi.modules.db.model.PageResult;
import org.ssssssss.script.exception.MagicScriptAssertException;
import org.ssssssss.script.exception.MagicScriptException;
import org.ssssssss.script.functions.ObjectConvertExtension;
import org.ssssssss.script.runtime.ExitValue;

public interface ResultProvider {
    public static final Logger logger = LoggerFactory.getLogger(ResultProvider.class);

    default public Object buildResult(RequestEntity requestEntity, Throwable root) {
        MagicScriptException se = null;
        Throwable parent = root;
        do {
            if (parent instanceof MagicScriptAssertException) {
                MagicScriptAssertException sae = (MagicScriptAssertException)parent;
                return this.buildResult(requestEntity, sae.getCode(), sae.getMessage());
            }
            if (!(parent instanceof MagicScriptException)) continue;
            se = (MagicScriptException)parent;
        } while ((parent = parent.getCause()) != null);
        logger.error("\u8c03\u7528\u63a5\u53e3\u51fa\u9519", root);
        if (se != null) {
            return this.buildException(requestEntity, (Throwable)se);
        }
        return this.buildException(requestEntity, root);
    }

    default public Object buildResult(RequestEntity requestEntity, Object data) {
        if (data instanceof ExitValue) {
            ExitValue exitValue = (ExitValue)data;
            Object[] values = exitValue.getValues();
            int code = values.length > 0 ? ObjectConvertExtension.asInt((Object)values[0], (int)Constants.RESPONSE_CODE_SUCCESS) : Constants.RESPONSE_CODE_SUCCESS;
            String message = values.length > 1 ? Objects.toString(values[1], "success") : "success";
            return this.buildResult(requestEntity, code, message, values.length > 2 ? values[2] : null);
        }
        return this.buildResult(requestEntity, Constants.RESPONSE_CODE_SUCCESS, "success", data);
    }

    default public Object buildResult(RequestEntity requestEntity, int code, String message) {
        return this.buildResult(requestEntity, code, message, null);
    }

    default public Object buildException(RequestEntity requestEntity, Throwable throwable) {
        return this.buildResult(requestEntity, Constants.RESPONSE_CODE_EXCEPTION, "\u7cfb\u7edf\u5185\u90e8\u51fa\u73b0\u9519\u8bef");
    }

    public Object buildResult(RequestEntity var1, int var2, String var3, Object var4);

    default public Object buildPageResult(RequestEntity requestEntity, Page page, long total, List<Map<String, Object>> data) {
        return new PageResult<Map<String, Object>>(total, data);
    }
}

