/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules.db;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.jdbc.core.RowMapper;
import org.ssssssss.magicapi.modules.db.provider.CamelColumnMapperProvider;
import org.ssssssss.magicapi.modules.db.provider.ColumnMapperProvider;
import org.ssssssss.magicapi.modules.db.provider.DefaultColumnMapperProvider;
import org.ssssssss.magicapi.modules.db.provider.LowerColumnMapperProvider;
import org.ssssssss.magicapi.modules.db.provider.PascalColumnMapperProvider;
import org.ssssssss.magicapi.modules.db.provider.UpperColumnMapperProvider;

public class ColumnMapperAdapter {
    private final Map<String, RowMapper<Map<String, Object>>> columnMapRowMappers = new HashMap<String, RowMapper<Map<String, Object>>>();
    private final Map<String, Function<String, String>> rowMapColumnMappers = new HashMap<String, Function<String, String>>();
    private RowMapper<Map<String, Object>> mapRowColumnMapper;
    private Function<String, String> rowMapColumnMapper;

    public ColumnMapperAdapter() {
        this.setDefault(new DefaultColumnMapperProvider());
        this.add(new CamelColumnMapperProvider());
        this.add(new PascalColumnMapperProvider());
        this.add(new LowerColumnMapperProvider());
        this.add(new UpperColumnMapperProvider());
    }

    public void add(ColumnMapperProvider columnMapperProvider) {
        this.columnMapRowMappers.put(columnMapperProvider.name(), (RowMapper<Map<String, Object>>)columnMapperProvider.getColumnMapRowMapper());
        this.rowMapColumnMappers.put(columnMapperProvider.name(), columnMapperProvider.getRowMapColumnMapper());
    }

    public void setDefault(ColumnMapperProvider columnMapperProvider) {
        this.mapRowColumnMapper = columnMapperProvider.getColumnMapRowMapper();
        this.rowMapColumnMapper = columnMapperProvider.getRowMapColumnMapper();
        this.add(columnMapperProvider);
    }

    public void setDefault(String name) {
        this.mapRowColumnMapper = this.getColumnMapRowMapper(name);
        this.rowMapColumnMapper = this.getRowMapColumnMapper(name);
    }

    public RowMapper<Map<String, Object>> getDefaultColumnMapRowMapper() {
        return this.mapRowColumnMapper;
    }

    public Function<String, String> getDefaultRowMapColumnMapper() {
        return this.rowMapColumnMapper;
    }

    public RowMapper<Map<String, Object>> getColumnMapRowMapper(String name) {
        return this.columnMapRowMappers.getOrDefault(name, this.mapRowColumnMapper);
    }

    public Function<String, String> getRowMapColumnMapper(String name) {
        return this.rowMapColumnMappers.getOrDefault(name, this.rowMapColumnMapper);
    }
}

