/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules.db.table;

import java.beans.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.ssssssss.magicapi.modules.db.table.NamedTable;
import org.ssssssss.script.annotation.Comment;
import org.ssssssss.script.functions.StreamExtension;
import org.ssssssss.script.runtime.RuntimeContext;

public class Where {
    private final List<String> tokens = new ArrayList<String>();
    private final List<Object> params = new ArrayList<Object>();
    private final NamedTable namedTable;
    private final boolean needWhere;
    private boolean notNull = false;
    private boolean notBlank = false;

    public Where(NamedTable namedTable) {
        this(namedTable, true);
    }

    public Where(NamedTable namedTable, boolean needWhere) {
        this.namedTable = namedTable;
        this.needWhere = needWhere;
    }

    @Comment(value="\u514b\u9686")
    public Where clone() {
        Where where = new Where(this.namedTable, this.needWhere);
        where.tokens.addAll(this.tokens);
        where.params.addAll(this.params);
        where.notNull = this.notNull;
        where.notBlank = this.notBlank;
        return where;
    }

    @Comment(value="\u8fc7\u6ee4`null`\u7684\u53c2\u6570")
    public Where notNull() {
        return this.notNull(true);
    }

    @Comment(value="\u8fc7\u6ee4`blank`\u7684\u53c2\u6570")
    public Where notBlank() {
        return this.notBlank(true);
    }

    @Comment(value="\u662f\u5426\u8fc7\u6ee4`null`\u7684\u53c2\u6570")
    public Where notNull(boolean flag) {
        this.notNull = flag;
        return this;
    }

    @Comment(value="\u662f\u5426\u8fc7\u6ee4`blank`\u7684\u53c2\u6570")
    public Where notBlank(boolean flag) {
        this.notBlank = flag;
        return this;
    }

    @Comment(value="\u7b49\u4e8e`=`,\u5982\uff1a`eq('name', '\u8001\u738b') ---> name = '\u8001\u738b'`")
    public Where eq(@Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        return this.eq(true, column, value);
    }

    @Comment(value="\u7b49\u4e8e`=`,\u5982\uff1a`eq('name', '\u8001\u738b') ---> name = '\u8001\u738b'`")
    public Where eq(@Comment(name="condition", value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        if (condition && this.filterNullAndBlank(value)) {
            this.tokens.add(this.namedTable.rowMapColumnMapper.apply(column));
            if (value == null) {
                this.append(" is null");
            } else {
                this.params.add(value);
                this.append(" = ?");
            }
            this.appendAnd();
        }
        return this;
    }

    @Comment(value="\u4e0d\u7b49\u4e8e`<>`,\u5982\uff1a`ne('name', '\u8001\u738b') ---> name <> '\u8001\u738b'`")
    public Where ne(@Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        return this.ne(true, column, value);
    }

    @Comment(value="\u4e0d\u7b49\u4e8e`<>`,\u5982\uff1a`ne('name', '\u8001\u738b') ---> name <> '\u8001\u738b'`")
    public Where ne(@Comment(name="condition", value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        if (condition && this.filterNullAndBlank(value)) {
            this.append(this.namedTable.rowMapColumnMapper.apply(column));
            if (value == null) {
                this.append("is not null");
            } else {
                this.params.add(value);
                this.append("<> ?");
            }
            this.appendAnd();
        }
        return this;
    }

    @Comment(value="\u5c0f\u4e8e`<`,\u5982\uff1a`lt('age', 18) ---> age < 18")
    public Where lt(@Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        return this.lt(true, column, value);
    }

    @Comment(value="\u5c0f\u4e8e`<`,\u5982\uff1a`lt('age', 18) ---> age < 18")
    public Where lt(@Comment(name="condition", value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        return this.append(condition, column, " < ?", value);
    }

    @Comment(value="\u5c0f\u4e8e\u7b49\u4e8e`<=`,\u5982\uff1a`lte('age', 18) ---> age <= 18")
    public Where lte(@Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        return this.lte(true, column, value);
    }

    @Comment(value="\u5c0f\u4e8e\u7b49\u4e8e`<=`,\u5982\uff1a`lte('age', 18) ---> age <= 18")
    public Where lte(@Comment(name="condition", value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        return this.append(condition, column, " <= ?", value);
    }

    @Comment(value="\u5927\u4e8e`>`,\u5982\uff1a`get('age', 18) ---> age > 18")
    public Where gt(@Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        return this.gt(true, column, value);
    }

    @Comment(value="\u5927\u4e8e`>`,\u5982\uff1a`get('age', 18) ---> age > 18")
    public Where gt(@Comment(name="condition", value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        return this.append(condition, column, " > ?", value);
    }

    @Comment(value="\u5927\u4e8e\u7b49\u4e8e`>=`,\u5982\uff1a`get('age', 18) ---> age >= 18")
    public Where gte(@Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        return this.gte(true, column, value);
    }

    @Comment(value="\u5927\u4e8e\u7b49\u4e8e`>=`,\u5982\uff1a`get('age', 18) ---> age >= 18")
    public Where gte(@Comment(name="condition", value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        return this.append(condition, column, " >= ?", value);
    }

    @Comment(value="`in`,\u5982\uff1a`in('age', [1,2,3]) ---> age in (1,2,3)")
    public Where in(@Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        return this.in(true, column, value);
    }

    @Comment(value="`in`,\u5982\uff1a`in('age', [1,2,3]) ---> age in (1,2,3)")
    public Where in(@Comment(name="condition", value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        List objects;
        if (condition && value != null && (objects = StreamExtension.arrayLikeToList((Object)value)).size() > 0) {
            this.append(this.namedTable.rowMapColumnMapper.apply(column));
            this.append(" in (");
            this.append(String.join((CharSequence)",", Collections.nCopies(objects.size(), "?")));
            this.append(")");
            this.appendAnd();
            this.params.addAll(objects);
        }
        return this;
    }

    @Comment(value="`not in`,\u5982\uff1a`notIn('age', [1,2,3]) ---> age not in (1,2,3)")
    public Where notIn(@Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        return this.notIn(true, column, value);
    }

    @Comment(value="`not in`,\u5982\uff1a`notIn('age', [1,2,3]) ---> age not in (1,2,3)")
    public Where notIn(@Comment(name="condition", value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        List objects;
        if (condition && value != null && (objects = StreamExtension.arrayLikeToList((Object)value)).size() > 0) {
            this.append(this.namedTable.rowMapColumnMapper.apply(column));
            this.append("not in (");
            this.append(String.join((CharSequence)",", Collections.nCopies(objects.size(), "?")));
            this.append(")");
            this.appendAnd();
            this.params.addAll(objects);
        }
        return this;
    }

    @Comment(value="`like`,\u5982\uff1a`like('name', '%\u738b%') ---> name like '%\u738b%'")
    public Where like(@Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        return this.like(true, column, value);
    }

    @Comment(value="`like`,\u5982\uff1a`like('name', '%\u738b%') ---> name like '%\u738b%'")
    public Where like(@Comment(name="condition", value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        return this.append(condition, column, "like ?", value);
    }

    @Comment(value="`not like`,\u5982\uff1a`notLike('name', '%\u738b%') ---> name not like '%\u738b%'")
    public Where notLike(@Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        return this.notLike(true, column, value);
    }

    @Comment(value="`not like` ,\u5982\uff1a`notLike('name', '%\u738b%') ---> name not like '%\u738b%'")
    public Where notLike(@Comment(name="condition", value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(name="value", value="\u503c") Object value) {
        return this.append(condition, column, "not like ?", value);
    }

    @Comment(value="`is null`,\u5982\uff1a`isNull('name') ---> name is null")
    public Where isNull(@Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column) {
        return this.isNull(true, column);
    }

    @Comment(value="`is null`,\u5982\uff1a`isNull('name') ---> name is null")
    public Where isNull(@Comment(name="condition", value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column) {
        if (condition) {
            this.append(this.namedTable.rowMapColumnMapper.apply(column));
            this.append("is null");
            this.appendAnd();
        }
        return this;
    }

    @Comment(value="`is not null`,\u5982\uff1a`isNotNull('name') ---> name is not null")
    public Where isNotNull(@Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column) {
        return this.isNotNull(true, column);
    }

    @Comment(value="`is not null`,\u5982\uff1a`isNotNull('name') ---> name is not null")
    public Where isNotNull(@Comment(name="condition", value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(name="column", value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column) {
        if (condition) {
            this.append(this.namedTable.rowMapColumnMapper.apply(column));
            this.append("is not null");
            this.appendAnd();
        }
        return this;
    }

    @Comment(value="\u62fc\u63a5`or`")
    public Where or() {
        this.appendOr();
        return this;
    }

    @Comment(value="\u62fc\u63a5`and`")
    public Where and() {
        this.appendAnd();
        return this;
    }

    @Comment(value="`and`\u5d4c\u5957\uff0c\u5982and(it => it.eq('name','\u674e\u767d').ne('status','\u6b63\u5e38') --> and (name = '\u674e\u767d' and status <> '\u6b63\u5e38')")
    public Where and(@Comment(name="function", value="\u56de\u8c03\u51fd\u6570") Function<Object[], Where> function) {
        return this.and(true, function);
    }

    @Comment(value="`and`\u5d4c\u5957\uff0c\u5982and(it => it.eq('name','\u674e\u767d').ne('status','\u6b63\u5e38') --> and (name = '\u674e\u767d' and status <> '\u6b63\u5e38')")
    public Where and(@Comment(name="condition", value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(name="function", value="\u56de\u8c03\u51fd\u6570") Function<Object[], Where> function) {
        if (condition) {
            Where expr = function.apply(new Object[]{new Where(this.namedTable, false)});
            this.params.addAll(expr.params);
            this.append("(");
            this.append(expr.getSql());
            this.append(")");
            this.appendAnd();
        }
        return this;
    }

    @Comment(value="\u62fc\u63a5`order by xxx asc/desc`")
    public Where orderBy(@Comment(name="column", value="\u8981\u6392\u5e8f\u7684\u5217") String column, @Comment(name="sort", value="`asc`\u6216`desc`") String sort) {
        this.namedTable.orderBy(column, sort);
        return this;
    }

    @Comment(value="\u62fc\u63a5`order by xxx asc`")
    public Where orderBy(@Comment(name="column", value="\u8981\u6392\u5e8f\u7684\u5217") String column) {
        return this.orderBy(column, "asc");
    }

    @Comment(value="\u62fc\u63a5`order by xxx desc`")
    public Where orderByDesc(@Comment(name="column", value="\u8981\u6392\u5e8f\u7684\u5217") String column) {
        return this.orderBy(column, "desc");
    }

    @Comment(value="\u62fc\u63a5`group by`")
    public Where groupBy(String ... columns) {
        this.namedTable.groupBy(columns);
        return this;
    }

    @Comment(value="\u4fdd\u5b58\u5230\u8868\u4e2d\uff0c\u5f53\u4e3b\u952e\u6709\u503c\u65f6\u5219\u4fee\u6539\uff0c\u5426\u5219\u63d2\u5165")
    public Object save(RuntimeContext runtimeContext) {
        return this.namedTable.save(runtimeContext);
    }

    @Comment(value="\u4fdd\u5b58\u5230\u8868\u4e2d\uff0c\u5f53\u4e3b\u952e\u6709\u503c\u65f6\u5219\u4fee\u6539\uff0c\u5426\u5219\u63d2\u5165")
    public Object save(RuntimeContext runtimeContext, @Comment(name="beforeQuery", value="\u662f\u5426\u6839\u636eid\u67e5\u8be2\u6709\u6ca1\u6709\u6570\u636e") boolean beforeQuery) {
        return this.namedTable.save(runtimeContext, beforeQuery);
    }

    @Comment(value="\u4fdd\u5b58\u5230\u8868\u4e2d\uff0c\u5f53\u4e3b\u952e\u6709\u503c\u65f6\u5219\u4fee\u6539\uff0c\u5426\u5219\u63d2\u5165")
    public Object save(RuntimeContext runtimeContext, @Comment(name="data", value="\u5404\u9879\u5217\u548c\u503c") Map<String, Object> data) {
        return this.namedTable.save(runtimeContext, data);
    }

    @Comment(value="\u4fdd\u5b58\u5230\u8868\u4e2d\uff0c\u5f53\u4e3b\u952e\u6709\u503c\u65f6\u5219\u4fee\u6539\uff0c\u5426\u5219\u63d2\u5165")
    public Object save(RuntimeContext runtimeContext, @Comment(name="data", value="\u5404\u9879\u5217\u548c\u503c") Map<String, Object> data, @Comment(name="beforeQuery", value="\u662f\u5426\u6839\u636eid\u67e5\u8be2\u6709\u6ca1\u6709\u6570\u636e") boolean beforeQuery) {
        return this.namedTable.save(runtimeContext, data, beforeQuery);
    }

    @Comment(value="\u6267\u884c\u63d2\u5165\u8bed\u53e5\uff0c\u8fd4\u56de\u4e3b\u952e")
    public Object insert(RuntimeContext runtimeContext) {
        return this.namedTable.insert(runtimeContext);
    }

    @Comment(value="\u6267\u884c\u63d2\u5165\u8bed\u53e5\uff0c\u8fd4\u56de\u4e3b\u952e")
    public Object insert(RuntimeContext runtimeContext, @Comment(name="data", value="\u5404\u9879\u5217\u548c\u503c") Map<String, Object> data) {
        return this.namedTable.insert(runtimeContext, data);
    }

    @Comment(value="\u6267\u884cupdate\u8bed\u53e5")
    public int update(RuntimeContext runtimeContext) {
        return this.namedTable.update(runtimeContext);
    }

    @Comment(value="\u6267\u884cdelete\u8bed\u53e5")
    public int delete(RuntimeContext runtimeContext) {
        return this.namedTable.delete(runtimeContext);
    }

    @Comment(value="\u6267\u884cupdate\u8bed\u53e5")
    public int update(RuntimeContext runtimeContext, @Comment(name="data", value="\u5404\u9879\u5217\u548c\u503c") Map<String, Object> data) {
        return this.namedTable.update(runtimeContext, data);
    }

    @Comment(value="\u6267\u884cupdate\u8bed\u53e5")
    public int update(RuntimeContext runtimeContext, @Comment(name="data", value="\u5404\u9879\u5217\u548c\u503c") Map<String, Object> data, @Comment(name="isUpdateBlank", value="\u662f\u5426\u66f4\u65b0\u7a7a\u503c\u5b57\u6bb5") boolean isUpdateBlank) {
        return this.namedTable.update(runtimeContext, data, isUpdateBlank);
    }

    @Comment(value="\u6267\u884c\u5206\u9875\u67e5\u8be2")
    public Object page(RuntimeContext runtimeContext) {
        return this.namedTable.page(runtimeContext);
    }

    @Comment(value="\u6267\u884c\u5206\u9875\u67e5\u8be2\uff0c\u5206\u9875\u6761\u4ef6\u624b\u52a8\u4f20\u5165")
    public Object page(RuntimeContext runtimeContext, @Comment(name="limit", value="\u9650\u5236\u6761\u6570") long limit, @Comment(name="offset", value="\u8df3\u8fc7\u6761\u6570") long offset) {
        return this.namedTable.page(runtimeContext, limit, offset);
    }

    @Comment(value="\u6267\u884cselect\u67e5\u8be2")
    public List<Map<String, Object>> select(RuntimeContext runtimeContext) {
        return this.namedTable.select(runtimeContext);
    }

    @Comment(value="\u6267\u884cselectOne\u67e5\u8be2")
    public Map<String, Object> selectOne(RuntimeContext runtimeContext) {
        return this.namedTable.selectOne(runtimeContext);
    }

    @Comment(value="\u67e5\u8be2\u6761\u6570")
    public int count(RuntimeContext runtimeContext) {
        return this.namedTable.count(runtimeContext);
    }

    @Comment(value="\u67e5\u8be2\u662f\u5426\u5b58\u5728")
    public boolean exists(RuntimeContext runtimeContext) {
        return this.namedTable.exists(runtimeContext);
    }

    @Transient
    public void appendAnd() {
        this.remove();
        this.tokens.add("and");
    }

    @Transient
    public void appendOr() {
        this.remove();
        this.tokens.add("or");
    }

    List<Object> getParams() {
        return this.params;
    }

    void remove() {
        String token;
        int size;
        for (size = this.tokens.size(); size > 0 && ("and".equalsIgnoreCase(token = this.tokens.get(size - 1)) || "or".equalsIgnoreCase(token)); --size) {
            this.tokens.remove(size - 1);
        }
        while (size > 0 && ("and".equalsIgnoreCase(token = this.tokens.get(0)) || "or".equalsIgnoreCase(token))) {
            this.tokens.remove(0);
            --size;
        }
    }

    boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    @Transient
    public void append(String value) {
        this.tokens.add(value);
    }

    @Transient
    public void append(String sql, Object value) {
        this.tokens.add(sql);
        this.params.add(value);
    }

    String getSql() {
        this.remove();
        if (this.isEmpty()) {
            return "";
        }
        return (this.needWhere ? " where " : "") + String.join((CharSequence)" ", this.tokens);
    }

    boolean filterNullAndBlank(Object value) {
        if (this.notNull && value == null) {
            return false;
        }
        return !this.notBlank || !StringUtils.isEmpty((CharSequence)Objects.toString(value, ""));
    }

    private Where append(boolean append, String column, String condition, Object value) {
        if (append && this.filterNullAndBlank(value)) {
            this.append(this.namedTable.rowMapColumnMapper.apply(column));
            this.append(condition);
            this.appendAnd();
            this.params.add(value);
        }
        return this;
    }
}

