/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.runtime.linq;

import java.util.List;
import java.util.Map;
import org.ssssssss.script.parsing.ast.BinaryOperation;
import org.ssssssss.script.runtime.linq.OrderValue;

public class SelectValue
implements Comparable<SelectValue> {
    private final Map<String, Object> value;
    private final List<OrderValue> orderValues;
    private final boolean hasOrder;

    public SelectValue(Map<String, Object> value, List<OrderValue> orderValues) {
        this.value = value;
        this.orderValues = orderValues;
        this.hasOrder = !orderValues.isEmpty();
    }

    public Map<String, Object> getValue() {
        return this.value;
    }

    @Override
    public int compareTo(SelectValue o2) {
        if (!this.hasOrder) {
            return 0;
        }
        int size = this.orderValues.size();
        for (int i = 0; i < size; ++i) {
            OrderValue ov1 = this.orderValues.get(i);
            OrderValue ov2 = o2.orderValues.get(i);
            int compareValue = BinaryOperation.compare(ov1.getValue(), ov2.getValue());
            if (compareValue == 0) continue;
            return compareValue * ov1.getOrder();
        }
        return 0;
    }
}

