/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import org.ssssssss.script.MagicResourceLoader;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.asm.Label;
import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.functions.DynamicModuleImport;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.VarIndex;
import org.ssssssss.script.parsing.ast.Node;

public class Import
extends Node {
    private final VarIndex varIndex;
    private final boolean module;
    private String packageName;
    private boolean function;

    public Import(Span span, String packageName, VarIndex varIndex, boolean module) {
        super(span);
        this.packageName = packageName;
        this.varIndex = varIndex;
        this.module = module;
        if (!module && packageName.startsWith("@")) {
            this.function = true;
            this.packageName = packageName.substring(1);
        }
    }

    public boolean isImportPackage() {
        return this.packageName.endsWith(".*");
    }

    @Override
    public void compile(MagicScriptCompiler compiler) {
        if (this.isImportPackage()) {
            compiler.loadContext().ldc(this.packageName.substring(0, this.packageName.length() - 1)).invoke(182, MagicScriptContext.class, "addImport", Void.TYPE, String.class);
        } else {
            String methodName = "loadClass";
            if (this.module) {
                methodName = "loadModule";
            } else if (this.function) {
                methodName = "loadFunction";
            }
            compiler.pre_store(this.varIndex).loadContext().ldc(this.packageName).invoke(184, MagicResourceLoader.class, methodName, Object.class, MagicScriptContext.class, String.class);
            if (this.module) {
                Label end = new Label();
                compiler.insn(89).typeInsn(193, DynamicModuleImport.class).jump(153, end).typeInsn(192, DynamicModuleImport.class).loadContext().invoke(182, DynamicModuleImport.class, "getDynamicModule", Object.class, MagicScriptContext.class).label(end);
            }
            compiler.store(this.varIndex);
        }
    }
}

