/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.javascript;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.stjs.javascript.Error;
import org.stjs.javascript.JSAbstractOperations;
import org.stjs.javascript.JSGlobal;
import org.stjs.javascript.JSObjectAdapter;
import org.stjs.javascript.Math;
import org.stjs.javascript.SortFunction;
import org.stjs.javascript.annotation.BrowserCompatibility;
import org.stjs.javascript.annotation.ServerSide;
import org.stjs.javascript.annotation.Template;
import org.stjs.javascript.functions.Callback1;
import org.stjs.javascript.functions.Callback3;
import org.stjs.javascript.functions.Function3;
import org.stjs.javascript.functions.Function4;

public class Array<V>
implements Iterable<String> {
    private static final Object UNSET = new Object();
    private ArrayStore<V> array = new PackedArrayStore<V>();
    private long length = 0L;
    private long setElements = 0L;
    private Map<String, V> nonArrayElements = new LinkedHashMap<String, V>();

    public Array() {
    }

    public Array(Number len) {
        double signedLen = len.doubleValue();
        double unsignedLen = JSAbstractOperations.ToUInt32(signedLen);
        if (signedLen != unsignedLen) {
            throw new Error("RangeError", len + " is out of range for Array length");
        }
        this.$length((int)unsignedLen);
    }

    @ServerSide
    public Array(List<V> values) {
        this.length = values.size();
        this.setElements = values.size();
        this.array = new PackedArrayStore<V>(values);
    }

    @SafeVarargs
    public Array(V ... values) {
        if (values.length == 1 && values[0] instanceof Number) {
            double unsignedLen;
            double signedLen = ((Number)values[0]).doubleValue();
            if (signedLen != (unsignedLen = JSAbstractOperations.ToUInt32(signedLen).doubleValue())) {
                throw new Error("RangeError", signedLen + " is out of range for Array length");
            }
            this.$length((int)unsignedLen);
        } else {
            this.push(values);
        }
    }

    @ServerSide
    public List<V> toList() {
        if (this.length > Integer.MAX_VALUE) {
            throw new IllegalStateException("Array is too long: " + this.length + " > " + Integer.MAX_VALUE);
        }
        if (this.nonArrayElements.size() > 0) {
            throw new IllegalStateException("Array contains non-array elements: " + this.nonArrayElements.keySet());
        }
        if (this.length != this.setElements) {
            throw new IllegalStateException("Array is sparse");
        }
        ArrayList<V> result = new ArrayList<V>((int)this.length);
        for (int i = 0; i < this.$length(); ++i) {
            result.add(this.$get(i));
        }
        return result;
    }

    @Override
    @ServerSide
    @BrowserCompatibility(value="none")
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private Iterator<Entry<V>> arrayIter;
            private Iterator<String> nonArrayIter;
            {
                this.arrayIter = Array.this.entryIterator(0L, Array.this.$length(), true);
                this.nonArrayIter = Array.this.nonArrayElements.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.arrayIter.hasNext() || this.nonArrayIter.hasNext();
            }

            @Override
            public String next() {
                if (this.arrayIter.hasNext()) {
                    Entry nextEntry = this.arrayIter.next();
                    return Long.toString(nextEntry.key);
                }
                return this.nonArrayIter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Iterator<Entry<V>> entryIterator(final long actualStart, final long actualEndExcluded, final boolean isForward) {
        return new Iterator<Entry<V>>(){
            private ArrayStore<V> prevStore;
            private Long prevKey;
            private Iterator<Entry<V>> iter;
            {
                this.prevStore = Array.this.array;
                this.prevKey = 0L;
                this.iter = Array.this.array.entryIterator(actualStart, actualEndExcluded, isForward);
            }

            @Override
            public boolean hasNext() {
                this.updateEntryIterator();
                return this.iter.hasNext();
            }

            @Override
            public Entry<V> next() {
                this.updateEntryIterator();
                Entry entry = this.iter.next();
                this.prevKey = entry.key;
                return entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void updateEntryIterator() {
                if (this.prevStore != Array.this.array) {
                    this.prevStore = Array.this.array;
                    this.iter = Array.this.array.entryIterator(this.prevKey + (long)(isForward ? 1 : -1), actualEndExcluded, isForward);
                }
            }
        };
    }

    @Template(value="get")
    public V $get(int index) {
        return this.$get((long)index);
    }

    @Template(value="get")
    public V $get(long index) {
        if (index < 0L) {
            return this.nonArrayElements.get(Long.toString(index));
        }
        return this.array.get(index);
    }

    @Template(value="get")
    public V $get(String index) {
        Long i = this.toArrayIndex(index);
        if (i == null) {
            return this.nonArrayElements.get(index);
        }
        return this.array.get(i);
    }

    private Long toArrayIndex(String index) {
        if (index == null) {
            return null;
        }
        Double asNum = JSAbstractOperations.ToNumber(index);
        Double asInt = JSAbstractOperations.ToInteger(asNum);
        if (Double.isNaN(asNum) || asInt < 0.0 || asInt >= JSAbstractOperations.UINT_MAX_VALUE_D - 1.0 || !asInt.equals(asNum)) {
            return null;
        }
        return asInt.longValue();
    }

    @Template(value="set")
    public void $set(int index, V value) {
        this.$set((long)index, value);
    }

    @Template(value="set")
    public void $set(long index, V value) {
        if (index < 0L) {
            this.nonArrayElements.put(JSAbstractOperations.ToString(index), value);
        } else {
            this.doSet(index, value);
        }
    }

    @Template(value="set")
    public void $set(String index, V value) {
        Long i = this.toArrayIndex(index);
        if (i == null) {
            this.nonArrayElements.put(JSAbstractOperations.ToString(index), value);
        } else {
            this.$set(i, value);
        }
    }

    @Template(value="delete")
    public boolean $delete(String index) {
        Long i = this.toArrayIndex(index);
        if (i == null) {
            this.nonArrayElements.remove(index);
        } else {
            this.doDelete(i);
        }
        return true;
    }

    @Template(value="delete")
    public boolean $delete(int index) {
        return this.$delete((long)index);
    }

    @Template(value="delete")
    public boolean $delete(long index) {
        if (index < 0L) {
            this.nonArrayElements.remove(JSAbstractOperations.ToString(index));
        } else {
            this.doDelete(index);
        }
        return true;
    }

    private void doDelete(long index) {
        if (index >= (long)this.$length()) {
            return;
        }
        boolean isSet = this.array.isSet(index);
        long newSetElements = this.setElements;
        if (isSet) {
            this.switchStoreIfNeeded(this.length, --newSetElements);
            this.array.delete(index);
            this.setElements = newSetElements;
        }
    }

    private void doSet(long index, V value) {
        boolean isSet = this.array.isSet(index);
        long newLength = (long)Math.max(this.length, index + 1L);
        long newSetElements = this.setElements;
        if (!isSet) {
            this.switchStoreIfNeeded(newLength, ++newSetElements);
        }
        if (newLength > this.length) {
            this.array.padTo(newLength);
        }
        this.array.set(index, value);
        this.length = newLength;
        this.setElements = newSetElements;
    }

    @Template(value="toProperty")
    public int $length() {
        return (int)this.length;
    }

    @Template(value="toProperty")
    public void $length(int newLength) {
        if ((long)newLength == this.length) {
            return;
        }
        if ((long)newLength > this.length) {
            this.switchStoreIfNeeded(newLength, this.setElements);
            this.array.padTo(newLength);
            this.length = newLength;
        } else {
            long newSetElements = 0L;
            if (newLength > 0) {
                newSetElements = this.setElements - this.array.getSetElements(newLength - 1, this.length);
            }
            this.switchStoreIfNeeded(newLength, newSetElements);
            this.array.truncateFrom(newLength);
            this.length = newLength;
            this.setElements = newSetElements;
        }
    }

    private void switchStoreIfNeeded(long newLength, long newSetElements) {
        if (!this.array.isEfficientStoreFor(newLength, newSetElements)) {
            this.array = this.array.switchStoreType(newLength);
        }
    }

    @SafeVarargs
    public final Array<V> concat(Array<? extends V> ... arrays) {
        Array result = new Array();
        long i = 0L;
        Iterator<Entry<V>> thisIter = this.entryIterator(0L, this.$length(), true);
        while (thisIter.hasNext()) {
            Entry<V> entry = thisIter.next();
            result.$set(i + entry.key, entry.value);
        }
        i = this.$length();
        if (arrays != null) {
            for (Array<V> array : arrays) {
                Iterator<Entry<V>> arrIter = array.array.entryIterator(0L, array.$length(), true);
                while (arrIter.hasNext()) {
                    Entry<V> entry = arrIter.next();
                    result.$set(i + entry.key, entry.value);
                }
                i += (long)array.$length();
            }
        }
        result.$length((int)i);
        return result;
    }

    @SafeVarargs
    public final Array<V> concat(V ... values) {
        Array<Object> result = new Array<Object>();
        long i = 0L;
        Iterator<Entry<V>> iter = this.entryIterator(0L, this.$length(), true);
        while (iter.hasNext()) {
            Entry<V> entry = iter.next();
            result.$set(i + entry.key, entry.value);
        }
        i = this.$length();
        result.$length(this.$length());
        if (values != null) {
            for (int j = 0; j < values.length; ++j) {
                result.$set(i + (long)j, values[j]);
            }
        }
        return result;
    }

    @BrowserCompatibility(value="IE:9+")
    public int indexOf(V element) {
        return this.indexOf(element, 0);
    }

    @BrowserCompatibility(value="IE:9+")
    public int indexOf(V element, int start) {
        long actualStart = start < 0 ? (long)Math.max(0.0, this.$length() + start) : (long)Math.min(this.$length(), start);
        Iterator<Entry<V>> iter = this.entryIterator(actualStart, this.$length(), true);
        return this.indexOf(element, iter);
    }

    private int indexOf(V element, Iterator<Entry<V>> iter) {
        while (iter.hasNext()) {
            Entry<V> entry = iter.next();
            boolean isNan = entry.value instanceof Double && Double.isNaN((Double)entry.value);
            if (isNan || (entry.value == null || !entry.value.equals(element)) && (entry.value != null || element != null)) continue;
            return (int)entry.key;
        }
        return -1;
    }

    public String join() {
        return this.join(",");
    }

    public String join(String separator) {
        StringBuilder builder = new StringBuilder();
        String realSeparator = "";
        int i = 0;
        while ((long)i < this.length) {
            builder.append(realSeparator);
            realSeparator = separator;
            V item = this.array.get(i);
            if (item != null) {
                builder.append(JSAbstractOperations.ToString(item));
            }
            ++i;
        }
        return builder.toString();
    }

    public V pop() {
        if (this.length == 0L) {
            return null;
        }
        Array<V> removed = this.splice((int)(this.length - 1L), 1);
        return removed.$get(0);
    }

    @SafeVarargs
    public final int push(V ... values) {
        this.splice(this.$length(), 0, values);
        return (int)this.length;
    }

    public Array<V> reverse() {
        this.array.reverse();
        return this;
    }

    public V shift() {
        Array<V> removed = this.splice(0, 1);
        if (removed.$length() == 1) {
            return removed.$get(0);
        }
        return null;
    }

    public Array<V> slice(int start) {
        return this.slice(start, this.$length());
    }

    public Array<V> slice(int start, int end) {
        long actualStart = start < 0 ? (long)Math.max(this.$length() + start, 0.0) : (long)Math.min(start, this.$length());
        long actualEnd = end < 0 ? (long)Math.max(this.$length() + end, 0.0) : (long)Math.min(end, this.$length());
        return this.array.slice(actualStart, actualEnd);
    }

    public Array<V> splice(int start, int deleteCount) {
        return this.splice(start, deleteCount, null);
    }

    @SafeVarargs
    public final Array<V> splice(int start, int deleteCount, V ... values) {
        long actualStart = start < 0 ? (long)Math.max(this.length + (long)start, 0.0) : (long)Math.min(this.length, start);
        long actualDeleteCount = (long)Math.min(Math.max(deleteCount, 0.0), this.length - actualStart);
        if (values == null) {
            Object[] tmp = new Object[]{};
            values = tmp;
        }
        if (actualDeleteCount == 0L && values.length == 0) {
            return new Array<V>();
        }
        long newLength = this.length - actualDeleteCount + (long)values.length;
        long newSetElements = this.setElements + (long)values.length - this.array.getSetElements(actualStart, actualStart + (long)deleteCount);
        this.switchStoreIfNeeded(newLength, newSetElements);
        Array<V> deleted = this.slice((int)actualStart, (int)(actualStart + actualDeleteCount));
        this.array.splice(actualStart, actualDeleteCount, values);
        this.length = newLength;
        this.setElements = newSetElements;
        return deleted;
    }

    public Array<V> sort() {
        return this.sort(null);
    }

    public Array<V> sort(SortFunction<? super V> comparefn) {
        if (comparefn == null) {
            this.array.sort(this.defaultSortComparator());
        } else {
            this.array.sort(comparefn);
        }
        return this;
    }

    private SortFunction<V> defaultSortComparator() {
        return new SortFunction<V>(){

            @Override
            public int $invoke(V a, V b) {
                String aString = JSGlobal.String(a);
                String bString = JSGlobal.String(b);
                return aString.compareTo(bString);
            }
        };
    }

    @SafeVarargs
    public final int unshift(V ... values) {
        this.splice(0, 0, values);
        return this.$length();
    }

    @Override
    @BrowserCompatibility(value="IE:9+")
    public void forEach(final Callback1<? super V> callbackfn) {
        this.forEach(new Callback3<V, Long, Array<V>>(){

            @Override
            public void $invoke(V v, Long aLong, Array<V> strings) {
                callbackfn.$invoke(v);
            }
        });
    }

    @BrowserCompatibility(value="IE:9+")
    public void forEach(Callback3<? super V, Long, ? super Array<V>> callbackfn) {
        if (callbackfn == null) {
            throw new Error("TypeError", "callbackfn is null");
        }
        Iterator<Entry<V>> iter = this.entryIterator(0L, this.$length(), true);
        while (iter.hasNext()) {
            Entry<V> val = iter.next();
            callbackfn.$invoke(val.value, val.key, this);
        }
    }

    @Template(value="prefix")
    @BrowserCompatibility(value="IE:9+")
    public void $forEach(Callback1<? super V> callbackfn) {
        this.forEach(callbackfn);
    }

    @Template(value="prefix")
    @BrowserCompatibility(value="IE:9+")
    public void $forEach(Callback3<? super V, Long, ? super Array<V>> callbackfn) {
        this.forEach(callbackfn);
    }

    public String toString() {
        return this.join();
    }

    public String toLocaleString() {
        StringBuilder builder = new StringBuilder();
        String sep = "";
        int i = 0;
        while ((long)i < this.length) {
            builder.append(sep);
            sep = ",";
            V item = this.array.get(i);
            if (item != null) {
                builder.append(JSObjectAdapter.toLocaleString(item));
            }
            ++i;
        }
        return builder.toString();
    }

    @BrowserCompatibility(value="IE:9+")
    public int lastIndexOf(V searchElement) {
        return this.lastIndexOf(searchElement, this.$length() - 1);
    }

    @BrowserCompatibility(value="IE:9+")
    public int lastIndexOf(V searchElement, int fromIndex) {
        long actualStart = fromIndex < 0 ? (long)Math.max(-1.0, this.$length() + fromIndex) : (long)Math.min(this.$length() - 1, fromIndex);
        Iterator<Entry<V>> iter = this.entryIterator(actualStart, -1L, false);
        return this.indexOf(searchElement, iter);
    }

    @BrowserCompatibility(value="IE:9+")
    public boolean every(Function3<? super V, Long, ? super Array<V>, Boolean> callbackfn) {
        if (callbackfn == null) {
            throw new Error("TypeError", "callbackfn is null");
        }
        Iterator<Entry<V>> iter = this.entryIterator(0L, this.$length(), true);
        while (iter.hasNext()) {
            Entry<V> entry = iter.next();
            Boolean result = callbackfn.$invoke(entry.value, entry.key, this);
            if (Boolean.TRUE.equals(result)) continue;
            return false;
        }
        return true;
    }

    @BrowserCompatibility(value="IE:9+")
    public boolean some(Function3<? super V, Long, ? super Array<V>, Boolean> callbackfn) {
        if (callbackfn == null) {
            throw new Error("TypeError", "callbackfn is null");
        }
        Iterator<Entry<V>> iter = this.entryIterator(0L, this.$length(), true);
        while (iter.hasNext()) {
            Entry<V> entry = iter.next();
            Boolean result = callbackfn.$invoke(entry.value, entry.key, this);
            if (!Boolean.TRUE.equals(result)) continue;
            return true;
        }
        return false;
    }

    @BrowserCompatibility(value="IE:9+")
    public <T> Array<T> map(Function3<? super V, Long, ? super Array<V>, T> callbackfn) {
        if (callbackfn == null) {
            throw new Error("TypeError", "callbackfn is null");
        }
        int lengthBefore = this.$length();
        Iterator<Entry<V>> iter = this.entryIterator(0L, this.$length(), true);
        Array<T> result = new Array<T>();
        while (iter.hasNext()) {
            Entry<V> entry = iter.next();
            T mapped = callbackfn.$invoke(entry.value, entry.key, this);
            result.$set(entry.key, mapped);
        }
        result.$length(lengthBefore);
        return result;
    }

    @BrowserCompatibility(value="IE:9+")
    public Array<V> filter(Function3<? super V, Long, ? super Array<V>, Boolean> callbackfn) {
        if (callbackfn == null) {
            throw new Error("TypeError", "callbackfn is null");
        }
        Iterator<Entry<V>> iter = this.entryIterator(0L, this.$length(), true);
        Array<Object> result = new Array<Object>();
        while (iter.hasNext()) {
            Entry<V> entry = iter.next();
            boolean selected = callbackfn.$invoke(entry.value, entry.key, this);
            if (!selected) continue;
            result.push(entry.value);
        }
        return result;
    }

    @BrowserCompatibility(value="IE:9+, Safari:4+, Opera:10.50+")
    public V reduce(Function4<V, V, Long, Array<V>, V> callbackfn) {
        return this.doReduce(callbackfn, UNSET, true);
    }

    @BrowserCompatibility(value="IE:9+, Safari:4+, Opera:10.50+")
    public <T> T reduce(Function4<T, ? super V, Long, ? super Array<V>, T> callbackfn, T initialValue) {
        return this.doReduce(callbackfn, initialValue, true);
    }

    @BrowserCompatibility(value="IE:9+, Safari:4+, Opera:10.50+")
    public V reduceRight(Function4<V, V, Long, Array<V>, V> callbackfn) {
        return this.doReduce(callbackfn, UNSET, false);
    }

    @BrowserCompatibility(value="IE:9+, Safari:4+, Opera:10.50+")
    public <T> T reduceRight(Function4<T, ? super V, Long, ? super Array<V>, T> callbackfn, T initialValue) {
        return this.doReduce(callbackfn, initialValue, false);
    }

    private <T> T doReduce(Function4<T, ? super V, Long, ? super Array<V>, T> callbackfn, Object initialValue, boolean isForward) {
        Object accumulator;
        Object temp;
        if (callbackfn == null) {
            throw new Error("TypeError", "callbackfn is null");
        }
        Iterator<Entry<V>> iter = isForward ? this.entryIterator(0L, this.$length(), true) : this.entryIterator(this.$length(), -1L, false);
        if (initialValue == UNSET) {
            if (!iter.hasNext()) {
                throw new Error("TypeError", "Array is empty and initialValue was not provided");
            }
            accumulator = temp = iter.next().value;
        } else {
            accumulator = temp = initialValue;
        }
        while (iter.hasNext()) {
            Entry<V> entry = iter.next();
            accumulator = callbackfn.$invoke(accumulator, entry.value, entry.key, this);
        }
        return (T)accumulator;
    }

    public static boolean isArray(Object o) {
        return o instanceof Array;
    }

    private static class Entry<E> {
        long key;
        E value;

        private Entry() {
        }
    }

    private final class SparseArrayStore<E>
    extends ArrayStore<E> {
        TreeMap<Long, E> elements;

        private SparseArrayStore() {
            this.elements = new TreeMap();
        }

        @Override
        boolean isEfficientStoreFor(long newLength, long newElementCount) {
            if (newLength > Integer.MAX_VALUE) {
                return true;
            }
            if (newLength < 80L) {
                return false;
            }
            return newLength / newElementCount >= 3L;
        }

        @Override
        void set(long index, E value) {
            this.elements.put(index, value);
        }

        @Override
        E get(long index) {
            return this.elements.get(index);
        }

        @Override
        Array<E> slice(long fromIncluded, long toExcluded) {
            Array result = new Array();
            Long firstKey = this.elements.ceilingKey(fromIncluded);
            Long lastKey = this.elements.lowerKey(toExcluded);
            if (firstKey != null && lastKey != null) {
                SortedMap<Long, E> selected = this.elements.subMap(firstKey, lastKey);
                for (Map.Entry entry : selected.entrySet()) {
                    result.$set((Long)entry.getKey(), entry.getValue());
                }
            }
            result.$length((int)(toExcluded - fromIncluded));
            return result;
        }

        @Override
        void reverse() {
            long lenght = Array.this.$length();
            HashSet<Long> indices = new HashSet<Long>(this.elements.keySet());
            HashSet<Long> alreadySwitched = new HashSet<Long>();
            for (Long index : indices) {
                if (alreadySwitched.contains(index)) continue;
                E value = this.elements.get(index);
                long newIndex = Array.this.length - 1L - index;
                if (this.elements.containsKey(newIndex)) {
                    E temp = this.elements.get(newIndex);
                    this.elements.put(newIndex, value);
                    this.elements.put(index, temp);
                    alreadySwitched.add(newIndex);
                    continue;
                }
                this.elements.remove(index);
                this.elements.put(newIndex, value);
            }
        }

        @Override
        public void sort(final SortFunction<? super E> comparefn) {
            ArrayList<E> values = new ArrayList<E>(this.elements.values());
            Comparator comparator = new Comparator<E>(){

                @Override
                public int compare(E x, E y) {
                    return comparefn.$invoke(x, y);
                }
            };
            Collections.sort(values, comparator);
            this.elements.clear();
            for (int i = 0; i < values.size(); ++i) {
                this.elements.put(Long.valueOf(i), values.get(i));
            }
        }

        @Override
        boolean isSet(long index) {
            return this.elements.containsKey(index);
        }

        @Override
        Iterator<Entry<E>> entryIterator(final long actualStart, final long actualEndExcluded, final boolean isForward) {
            return new Iterator<Entry<E>>(){
                private long lastProduced;
                {
                    this.lastProduced = isForward ? actualStart - 1L : actualStart + 1L;
                }

                @Override
                public boolean hasNext() {
                    if (isForward) {
                        Long nextKey = SparseArrayStore.this.elements.higherKey(this.lastProduced);
                        return nextKey != null && nextKey < actualEndExcluded;
                    }
                    Long nextKey = SparseArrayStore.this.elements.lowerKey(this.lastProduced);
                    return nextKey != null && nextKey > actualEndExcluded;
                }

                @Override
                public Entry<E> next() {
                    Long nextKey = isForward ? SparseArrayStore.this.elements.higherKey(this.lastProduced) : SparseArrayStore.this.elements.lowerKey(this.lastProduced);
                    Object value = SparseArrayStore.this.elements.get(nextKey);
                    Entry entry = new Entry();
                    entry.key = nextKey;
                    entry.value = value;
                    this.lastProduced = nextKey;
                    return entry;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        long getSetElements(long firstIncluded, long lastExcluded) {
            Long actualFirstIncluded = this.elements.ceilingKey(firstIncluded);
            Long actualLastExcluded = this.elements.lowerKey(lastExcluded);
            if (actualFirstIncluded == null || actualLastExcluded == null) {
                return 0L;
            }
            return this.elements.subMap(actualFirstIncluded, actualLastExcluded).size();
        }

        @Override
        void splice(long actualStart, long actualDeleteCount, E[] values) {
            long overlap = (long)Math.min(values.length, actualDeleteCount);
            int i = 0;
            while ((long)i < overlap) {
                this.elements.put(actualStart + (long)i, values[i]);
                ++i;
            }
            i = (int)actualDeleteCount - 1;
            while ((long)i >= overlap) {
                this.elements.remove((long)((int)actualStart) + overlap + (long)i);
                --i;
            }
            for (i = (int)overlap; i < values.length; ++i) {
                this.elements.put(actualStart + (long)i, values[i]);
            }
        }

        @Override
        void truncateFrom(long newLength) {
            Long ceil = this.elements.ceilingKey(newLength);
            if (ceil != null) {
                NavigableMap<Long, E> toRemove = this.elements.subMap(ceil, true, this.elements.lastKey(), true);
                toRemove.clear();
            }
        }

        @Override
        void padTo(long newLength) {
        }

        @Override
        void delete(long index) {
            this.elements.remove(index);
        }
    }

    private final class PackedArrayStore<E>
    extends ArrayStore<E> {
        private ArrayList<Object> elements;

        private PackedArrayStore() {
            this.elements = new ArrayList();
        }

        private PackedArrayStore(List<E> elements) {
            this.elements = new ArrayList<E>(elements);
        }

        @Override
        boolean isEfficientStoreFor(long newLength, long newElementCount) {
            if (newLength > Integer.MAX_VALUE) {
                return false;
            }
            if (newLength < 120L) {
                return true;
            }
            return newElementCount != 0L && newLength / newElementCount < 6L;
        }

        @Override
        void set(long index, E value) {
            this.elements.set((int)index, value);
        }

        @Override
        public void padTo(long newLength) {
            while ((long)this.elements.size() < newLength) {
                this.elements.add(UNSET);
            }
        }

        @Override
        E get(long index) {
            if (index > Integer.MAX_VALUE || index >= (long)this.elements.size()) {
                return null;
            }
            Object value = this.elements.get((int)index);
            if (value == UNSET) {
                return null;
            }
            return (E)value;
        }

        @Override
        Array<E> slice(long fromIncluded, long toExcluded) {
            Array<Object> result = new Array<Object>();
            int i = (int)fromIncluded;
            int n = 0;
            while ((long)i < toExcluded && i < this.elements.size()) {
                Object value = this.elements.get(i);
                if (value != UNSET) {
                    result.$set(n, this.elements.get(i));
                }
                ++i;
                ++n;
            }
            return result;
        }

        @Override
        void reverse() {
            Collections.reverse(this.elements);
        }

        @Override
        public void sort(final SortFunction<? super E> comparefn) {
            Comparator<Object> comparator = new Comparator<Object>(){

                @Override
                public int compare(Object x, Object y) {
                    if (x == UNSET && y == UNSET) {
                        return 0;
                    }
                    if (x == UNSET) {
                        return 1;
                    }
                    if (y == UNSET) {
                        return -1;
                    }
                    return comparefn.$invoke(x, y);
                }
            };
            Collections.sort(this.elements, comparator);
        }

        @Override
        boolean isSet(long index) {
            return index < (long)this.elements.size() && this.elements.get((int)index) != UNSET;
        }

        @Override
        Iterator<Entry<E>> entryIterator(final long actualStart, final long actualEndExcluded, final boolean isForward) {
            return new Iterator<Entry<E>>(){
                private int nextIndex;
                {
                    this.nextIndex = (int)actualStart;
                }

                @Override
                public boolean hasNext() {
                    this.skipToNext();
                    if (isForward) {
                        return (long)this.nextIndex < actualEndExcluded;
                    }
                    return (long)this.nextIndex > actualEndExcluded;
                }

                @Override
                public Entry<E> next() {
                    this.skipToNext();
                    Entry entry = new Entry();
                    entry.key = this.nextIndex;
                    entry.value = PackedArrayStore.this.get(this.nextIndex);
                    this.nextIndex = isForward ? ++this.nextIndex : --this.nextIndex;
                    return entry;
                }

                private void skipToNext() {
                    if (isForward) {
                        while ((long)this.nextIndex < actualEndExcluded && !PackedArrayStore.this.isSet(this.nextIndex)) {
                            ++this.nextIndex;
                        }
                    } else {
                        while ((long)this.nextIndex > actualEndExcluded && !PackedArrayStore.this.isSet(this.nextIndex)) {
                            --this.nextIndex;
                        }
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        long getSetElements(long firstIncluded, long lastExcluded) {
            int setElements = 0;
            for (int i = (int)firstIncluded; i < this.elements.size() && (long)i < lastExcluded; ++i) {
                if (this.elements.get(i) == UNSET) continue;
                ++setElements;
            }
            return setElements;
        }

        @Override
        void splice(long actualStart, long actualDeleteCount, E[] values) {
            long rebuildCost;
            long trailingElements = (long)this.elements.size() - actualStart - actualDeleteCount;
            long inplaceCost = (long)Math.abs(actualDeleteCount - (long)values.length) * trailingElements;
            if (inplaceCost > 2L * (rebuildCost = (long)(this.elements.size() + values.length) - actualDeleteCount)) {
                ArrayList<Object> newElements = new ArrayList<Object>((int)rebuildCost);
                newElements.addAll(this.elements.subList(0, (int)actualStart));
                newElements.addAll(Arrays.asList(values));
                newElements.addAll(this.elements.subList((int)(actualStart + actualDeleteCount), this.elements.size()));
                this.elements = newElements;
            } else {
                int i;
                int overlap = (int)Math.min(values.length, actualDeleteCount);
                for (i = 0; i < overlap; ++i) {
                    this.elements.set((int)actualStart + i, values[i]);
                }
                i = (int)(actualStart + actualDeleteCount - 1L);
                while ((long)i >= actualStart + (long)overlap) {
                    this.elements.remove(i);
                    --i;
                }
                for (i = overlap; i < values.length; ++i) {
                    this.elements.add((int)actualStart + i, values[i]);
                }
            }
        }

        @Override
        void truncateFrom(long newLength) {
            if (newLength < (long)(this.elements.size() / 4)) {
                this.elements = new ArrayList<Object>(this.elements.subList(0, (int)newLength));
            } else {
                int i = this.elements.size() - 1;
                while ((long)i >= newLength) {
                    this.elements.remove(i);
                    --i;
                }
            }
        }

        @Override
        void delete(long index) {
            this.elements.set((int)index, UNSET);
        }
    }

    private abstract class ArrayStore<E> {
        private ArrayStore() {
        }

        ArrayStore<E> switchStoreType(long newLength) {
            ArrayStore that = this instanceof PackedArrayStore ? new SparseArrayStore() : new PackedArrayStore();
            that.padTo(newLength);
            Iterator<Entry<E>> entries = this.entryIterator(0L, newLength, true);
            while (entries.hasNext()) {
                Entry<E> entry = entries.next();
                that.set(entry.key, entry.value);
            }
            return that;
        }

        abstract void truncateFrom(long var1);

        abstract void padTo(long var1);

        abstract void splice(long var1, long var3, E[] var5);

        abstract long getSetElements(long var1, long var3);

        abstract Iterator<Entry<E>> entryIterator(long var1, long var3, boolean var5);

        abstract boolean isEfficientStoreFor(long var1, long var3);

        abstract void set(long var1, E var3);

        abstract boolean isSet(long var1);

        abstract void delete(long var1);

        abstract E get(long var1);

        abstract Array<E> slice(long var1, long var3);

        abstract void reverse();

        public abstract void sort(SortFunction<? super E> var1);
    }
}

