/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.javascript;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.stjs.javascript.annotation.BrowserCompatibility;

public class Date {
    private Calendar calendar;
    private Calendar utc;
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public Date() {
        this.calendar = Calendar.getInstance();
    }

    public Date(double milliseconds) {
        if (!Double.isNaN(milliseconds) && !Double.isInfinite(milliseconds) && milliseconds <= 8.64E15 && milliseconds >= -8.64E15) {
            this.getUTC(true).setTimeInMillis((long)milliseconds);
        }
    }

    public Date(String dateString) {
        java.util.Date d = null;
        try {
            d = new SimpleDateFormat(DEFAULT_DATE_PATTERN).parse(dateString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (d != null) {
            this.calendar = Calendar.getInstance();
            this.calendar.setTime(d);
        } else {
            this.calendar = null;
        }
    }

    public Date(int year, int month) {
        this(year, month, 1);
    }

    public Date(int year, int month, int day) {
        this(year, month, day, 0);
    }

    public Date(int year, int month, int day, int hours) {
        this(year, month, day, hours, 0);
    }

    public Date(int year, int month, int day, int hours, int minutes) {
        this(year, month, day, hours, minutes, 0);
    }

    public Date(int year, int month, int day, int hours, int minutes, int seconds) {
        this(year, month, day, hours, minutes, seconds, 0);
    }

    public Date(int year, int month, int day, int hours, int minutes, int seconds, int ms) {
        this.calendar = new GregorianCalendar(year, month, day, hours, minutes, seconds);
        this.calendar.set(14, ms);
    }

    private Calendar getUTC(boolean forceCreate) {
        if (this.utc == null) {
            if (this.calendar != null) {
                this.utc = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                this.utc.setTimeInMillis(this.calendar.getTimeInMillis());
            } else if (forceCreate) {
                this.utc = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            }
        }
        return this.utc;
    }

    private Calendar getCalendar(boolean forceCreate) {
        if (this.calendar == null) {
            if (this.utc != null) {
                this.calendar = Calendar.getInstance();
                this.calendar.setTimeInMillis(this.utc.getTimeInMillis());
            } else if (forceCreate) {
                this.calendar = Calendar.getInstance();
            }
        }
        return this.calendar;
    }

    private double getField(Calendar c, int field) {
        if (c == null) {
            return Double.NaN;
        }
        return c.get(field);
    }

    private void setField(Calendar c, int field, int n) {
        if (c == null) {
            throw new IllegalStateException("The calendar shold not be null");
        }
        c.set(field, n);
        if (c == this.calendar) {
            this.utc = null;
        } else {
            this.calendar = null;
        }
    }

    public double getDate() {
        return this.getField(this.getCalendar(false), 5);
    }

    public double getDay() {
        return this.getField(this.getCalendar(false), 7);
    }

    public double getFullYear() {
        return this.getField(this.getCalendar(false), 1);
    }

    public double getHours() {
        return this.getField(this.getCalendar(false), 11);
    }

    public double getMilliseconds() {
        return this.getField(this.getCalendar(false), 14);
    }

    public double getMinutes() {
        return this.getField(this.getCalendar(false), 12);
    }

    public double getMonth() {
        return this.getField(this.getCalendar(false), 2);
    }

    public double getSeconds() {
        return this.getField(this.getCalendar(false), 13);
    }

    public double getTime() {
        if (this.getCalendar(false) != null) {
            return this.calendar.getTimeInMillis();
        }
        return Double.NaN;
    }

    public double getTimezoneOffset() {
        if (this.getCalendar(false) != null) {
            return -this.calendar.getTimeZone().getRawOffset() / 1000 / 60;
        }
        return Double.NaN;
    }

    public double getUTCDate() {
        return this.getField(this.getUTC(false), 5);
    }

    public double getUTCDay() {
        return this.getField(this.getUTC(false), 7);
    }

    public double getUTCFullYear() {
        return this.getField(this.getUTC(false), 1);
    }

    public double getUTCHours() {
        return this.getUTC(false).get(11);
    }

    public double getUTCMilliseconds() {
        return this.getField(this.getUTC(false), 14);
    }

    public double getUTCMinutes() {
        return this.getField(this.getUTC(false), 12);
    }

    public double getUTCMonth() {
        return this.getField(this.getUTC(false), 2);
    }

    public double getUTCSeconds() {
        return this.getField(this.getUTC(false), 13);
    }

    @Deprecated
    public double getYear() {
        return this.getFullYear() - 1900.0;
    }

    @BrowserCompatibility(value="IE:7+")
    public static double parse(String date) {
        return new Date(date).getTime();
    }

    public void setDate(int day) {
        this.setField(this.getCalendar(true), 7, day);
    }

    public void setMonth(int month) {
        this.setMonth(month, (int)this.getDay());
    }

    public void setMonth(int month, int day) {
        this.setField(this.getCalendar(true), 2, month);
        this.setDate(day);
    }

    public void setFullYear(int year) {
        this.setFullYear(year, (int)this.getMonth());
    }

    public void setFullYear(int year, int month) {
        this.setFullYear(year, month, (int)this.getDate());
    }

    public void setFullYear(int year, int month, int day) {
        this.setField(this.getCalendar(true), 1, year);
        this.setMonth(month, day);
    }

    public void setMilliseconds(int ms) {
        this.setField(this.getCalendar(true), 14, ms);
    }

    public void setSeconds(int sec) {
        this.setSeconds(sec, (int)this.getMilliseconds());
    }

    public void setSeconds(int sec, int ms) {
        this.setField(this.getCalendar(true), 13, sec);
        this.setMilliseconds(ms);
    }

    public void setMinutes(int min) {
        this.setMinutes(min, (int)this.getSeconds());
    }

    public void setMinutes(int min, int sec) {
        this.setMinutes(min, sec, (int)this.getMilliseconds());
    }

    public void setMinutes(int min, int sec, int ms) {
        this.setField(this.getCalendar(true), 12, min);
        this.setSeconds(sec, ms);
    }

    public void setHours(int hour) {
        this.setHours(hour, (int)this.getMinutes());
    }

    public void setHours(int hour, int min) {
        this.setHours(hour, min, (int)this.getSeconds());
    }

    public void setHours(int hour, int min, int sec) {
        this.setHours(hour, min, sec, (int)this.getMilliseconds());
    }

    public void setHours(int hour, int min, int sec, int ms) {
        this.setField(this.getCalendar(true), 11, hour);
        this.setMinutes(min, sec, ms);
    }

    public void setTime(long time) {
        this.getCalendar(true).setTimeInMillis(time);
    }

    public void setUTCMilliseconds(int ms) {
        this.setField(this.getUTC(true), 14, ms);
    }

    public void setUTCSeconds(int sec) {
        this.setUTCSeconds(sec, (int)this.getUTCMilliseconds());
    }

    public void setUTCSeconds(int sec, int ms) {
        this.setField(this.getUTC(true), 13, sec);
        this.setUTCMilliseconds(ms);
    }

    public void setUTCMinutes(int min) {
        this.setUTCMinutes(min, (int)this.getUTCSeconds());
    }

    public void setUTCMinutes(int min, int sec) {
        this.setUTCMinutes(min, sec, (int)this.getUTCMilliseconds());
    }

    public void setUTCMinutes(int min, int sec, int ms) {
        this.setField(this.getUTC(true), 12, min);
        this.setUTCSeconds(sec, ms);
    }

    public void setUTCHours(int hour) {
        this.setUTCHours(hour, (int)this.getUTCMinutes());
    }

    public void setUTCHours(int hour, int min) {
        this.setUTCHours(hour, min, (int)this.getUTCSeconds());
    }

    public void setUTCHours(int hour, int min, int sec) {
        this.setUTCHours(hour, min, sec, (int)this.getUTCMilliseconds());
    }

    public void setUTCHours(int hour, int min, int sec, int ms) {
        this.setField(this.getUTC(true), 11, hour);
        this.setUTCMinutes(min, sec, ms);
    }

    public void setUTCDate(int n) {
        this.setField(this.getUTC(true), 5, n);
    }

    public void setUTCMonth(int month) {
        this.setUTCMonth(month, (int)this.getUTCDay());
    }

    public void setUTCMonth(int month, int day) {
        this.setField(this.getUTC(true), 2, month);
        this.setUTCDate(day);
    }

    public void setUTCFullYear(int year) {
        this.setUTCFullYear(year, (int)this.getUTCMonth());
    }

    public void setUTCFullYear(int year, int month) {
        this.setUTCFullYear(year, month, (int)this.getUTCDate());
    }

    public void setUTCFullYear(int year, int month, int day) {
        this.setField(this.getUTC(true), 1, year);
        this.setUTCMonth(month, day);
    }

    @Deprecated
    public void setYear(int year) {
        if (year >= 0 && year <= 99) {
            year += 1900;
        }
        this.setField(this.getUTC(true), 1, year);
    }

    @Deprecated
    public String toGMTString() {
        return this.toUTCString();
    }

    public String toLocaleDateString() {
        if (this.getCalendar(false) != null) {
            return DateFormat.getDateInstance(0, Locale.getDefault()).format(this.calendar.getTime());
        }
        return null;
    }

    public String toLocaleTimeString() {
        if (this.getCalendar(false) != null) {
            return DateFormat.getTimeInstance(0, Locale.getDefault()).format(this.calendar.getTime());
        }
        return null;
    }

    public String toLocaleString() {
        if (this.getCalendar(false) != null) {
            return DateFormat.getDateTimeInstance(0, 0, Locale.getDefault()).format(this.calendar.getTime());
        }
        return null;
    }

    public String toString() {
        if (this.getCalendar(false) != null) {
            return DateFormat.getDateTimeInstance(0, 0, Locale.US).format(this.calendar.getTime());
        }
        return null;
    }

    public String toDateString() {
        if (this.getCalendar(false) != null) {
            return DateFormat.getDateInstance(0, Locale.US).format(this.calendar.getTime());
        }
        return null;
    }

    public String toTimeString() {
        if (this.getCalendar(false) != null) {
            return DateFormat.getTimeInstance(0, Locale.US).format(this.calendar.getTime());
        }
        return null;
    }

    public String toUTCString() {
        if (this.getUTC(false) != null) {
            return DateFormat.getDateTimeInstance(0, 0, Locale.US).format(this.utc.getTime());
        }
        return null;
    }

    @BrowserCompatibility(value="IE:9+")
    public String toISOString() {
        return null;
    }

    public String toJSON(String key) {
        return this.toISOString();
    }

    public static double UTC(int year, int month) {
        return Date.UTC(year, month, 1);
    }

    public static double UTC(int year, int month, int day) {
        return Date.UTC(year, month, day, 0);
    }

    public static double UTC(int year, int month, int day, int hours) {
        return Date.UTC(year, month, day, hours, 0);
    }

    public static double UTC(int year, int month, int day, int hours, int minutes) {
        return Date.UTC(year, month, day, hours, minutes, 0);
    }

    public static double UTC(int year, int month, int day, int hours, int minutes, int seconds) {
        return Date.UTC(year, month, day, hours, minutes, seconds, 0);
    }

    public static double UTC(int year, int month, int day, int hours, int minutes, int seconds, int ms) {
        return new Date(year, month, day, hours, minutes, seconds, ms).getTime();
    }

    @BrowserCompatibility(value="IE:9+")
    public static double now() {
        return new Date().getTime();
    }

    public double valueOf() {
        return this.getTime();
    }
}

