/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Unsigned;
import java.util.Objects;
import java.util.Optional;
import org.starcoin.types.AccountAddress;
import org.starcoin.types.AuthenticationKey;
import org.starcoin.types.ChainId;
import org.starcoin.types.HashValue;
import org.starcoin.types.TraitHelpers;

public final class BlockMetadata {
    public final HashValue parent_hash;
    public final @Unsigned Long timestamp;
    public final AccountAddress author;
    public final Optional<AuthenticationKey> author_auth_key;
    public final @Unsigned Long uncles;
    public final @Unsigned Long number;
    public final ChainId chain_id;
    public final @Unsigned Long parent_gas_used;

    public BlockMetadata(HashValue parent_hash, @Unsigned Long timestamp, AccountAddress author, Optional<AuthenticationKey> author_auth_key, @Unsigned Long uncles, @Unsigned Long number, ChainId chain_id, @Unsigned Long parent_gas_used) {
        Objects.requireNonNull(parent_hash, "parent_hash must not be null");
        Objects.requireNonNull(timestamp, "timestamp must not be null");
        Objects.requireNonNull(author, "author must not be null");
        Objects.requireNonNull(author_auth_key, "author_auth_key must not be null");
        Objects.requireNonNull(uncles, "uncles must not be null");
        Objects.requireNonNull(number, "number must not be null");
        Objects.requireNonNull(chain_id, "chain_id must not be null");
        Objects.requireNonNull(parent_gas_used, "parent_gas_used must not be null");
        this.parent_hash = parent_hash;
        this.timestamp = timestamp;
        this.author = author;
        this.author_auth_key = author_auth_key;
        this.uncles = uncles;
        this.number = number;
        this.chain_id = chain_id;
        this.parent_gas_used = parent_gas_used;
    }

    public static BlockMetadata deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.parent_hash = HashValue.deserialize(deserializer);
        builder.timestamp = deserializer.deserialize_u64();
        builder.author = AccountAddress.deserialize(deserializer);
        builder.author_auth_key = TraitHelpers.deserialize_option_AuthenticationKey(deserializer);
        builder.uncles = deserializer.deserialize_u64();
        builder.number = deserializer.deserialize_u64();
        builder.chain_id = ChainId.deserialize(deserializer);
        builder.parent_gas_used = deserializer.deserialize_u64();
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static BlockMetadata bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        BlockMetadata value = BlockMetadata.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        this.parent_hash.serialize(serializer);
        serializer.serialize_u64(this.timestamp);
        this.author.serialize(serializer);
        TraitHelpers.serialize_option_AuthenticationKey(this.author_auth_key, serializer);
        serializer.serialize_u64(this.uncles);
        serializer.serialize_u64(this.number);
        this.chain_id.serialize(serializer);
        serializer.serialize_u64(this.parent_gas_used);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockMetadata other = (BlockMetadata)obj;
        if (!Objects.equals(this.parent_hash, other.parent_hash)) {
            return false;
        }
        if (!Objects.equals(this.timestamp, other.timestamp)) {
            return false;
        }
        if (!Objects.equals(this.author, other.author)) {
            return false;
        }
        if (!Objects.equals(this.author_auth_key, other.author_auth_key)) {
            return false;
        }
        if (!Objects.equals(this.uncles, other.uncles)) {
            return false;
        }
        if (!Objects.equals(this.number, other.number)) {
            return false;
        }
        if (!Objects.equals(this.chain_id, other.chain_id)) {
            return false;
        }
        return Objects.equals(this.parent_gas_used, other.parent_gas_used);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.parent_hash != null ? this.parent_hash.hashCode() : 0);
        value = 31 * value + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        value = 31 * value + (this.author != null ? this.author.hashCode() : 0);
        value = 31 * value + (this.author_auth_key != null ? this.author_auth_key.hashCode() : 0);
        value = 31 * value + (this.uncles != null ? this.uncles.hashCode() : 0);
        value = 31 * value + (this.number != null ? this.number.hashCode() : 0);
        value = 31 * value + (this.chain_id != null ? this.chain_id.hashCode() : 0);
        value = 31 * value + (this.parent_gas_used != null ? this.parent_gas_used.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public HashValue parent_hash;
        public @Unsigned Long timestamp;
        public AccountAddress author;
        public Optional<AuthenticationKey> author_auth_key;
        public @Unsigned Long uncles;
        public @Unsigned Long number;
        public ChainId chain_id;
        public @Unsigned Long parent_gas_used;

        public BlockMetadata build() {
            return new BlockMetadata(this.parent_hash, this.timestamp, this.author, this.author_auth_key, this.uncles, this.number, this.chain_id, this.parent_gas_used);
        }
    }
}

