/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.starcoin.types.AccountAddress;
import org.starcoin.types.Module;
import org.starcoin.types.ScriptFunction;
import org.starcoin.types.TraitHelpers;

public final class Package {
    public final AccountAddress package_address;
    public final List<Module> modules;
    public final Optional<ScriptFunction> init_script;

    public Package(AccountAddress package_address, List<Module> modules, Optional<ScriptFunction> init_script) {
        Objects.requireNonNull(package_address, "package_address must not be null");
        Objects.requireNonNull(modules, "modules must not be null");
        Objects.requireNonNull(init_script, "init_script must not be null");
        this.package_address = package_address;
        this.modules = modules;
        this.init_script = init_script;
    }

    public static Package deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.package_address = AccountAddress.deserialize(deserializer);
        builder.modules = TraitHelpers.deserialize_vector_Module(deserializer);
        builder.init_script = TraitHelpers.deserialize_option_ScriptFunction(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static Package bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        Package value = Package.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        this.package_address.serialize(serializer);
        TraitHelpers.serialize_vector_Module(this.modules, serializer);
        TraitHelpers.serialize_option_ScriptFunction(this.init_script, serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Package other = (Package)obj;
        if (!Objects.equals(this.package_address, other.package_address)) {
            return false;
        }
        if (!Objects.equals(this.modules, other.modules)) {
            return false;
        }
        return Objects.equals(this.init_script, other.init_script);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.package_address != null ? this.package_address.hashCode() : 0);
        value = 31 * value + (this.modules != null ? this.modules.hashCode() : 0);
        value = 31 * value + (this.init_script != null ? this.init_script.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public AccountAddress package_address;
        public List<Module> modules;
        public Optional<ScriptFunction> init_script;

        public Package build() {
            return new Package(this.package_address, this.modules, this.init_script);
        }
    }
}

