/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.Objects;
import org.starcoin.types.ScriptFunctionABI;
import org.starcoin.types.TransactionScriptABI;

public abstract class ScriptABI {
    public static ScriptABI deserialize(Deserializer deserializer) throws DeserializationError {
        int index = deserializer.deserialize_variant_index();
        switch (index) {
            case 0: {
                return TransactionScript.load(deserializer);
            }
            case 1: {
                return ScriptFunction.load(deserializer);
            }
        }
        throw new DeserializationError("Unknown variant index for ScriptABI: " + index);
    }

    public static ScriptABI bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        ScriptABI value = ScriptABI.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public abstract void serialize(Serializer var1) throws SerializationError;

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static final class ScriptFunction
    extends ScriptABI {
        public final ScriptFunctionABI value;

        public ScriptFunction(ScriptFunctionABI value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        static ScriptFunction load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = ScriptFunctionABI.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(1);
            this.value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScriptFunction other = (ScriptFunction)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public ScriptFunctionABI value;

            public ScriptFunction build() {
                return new ScriptFunction(this.value);
            }
        }
    }

    public static final class TransactionScript
    extends ScriptABI {
        public final TransactionScriptABI value;

        public TransactionScript(TransactionScriptABI value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        static TransactionScript load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = TransactionScriptABI.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(0);
            this.value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TransactionScript other = (TransactionScript)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TransactionScriptABI value;

            public TransactionScript build() {
                return new TransactionScript(this.value);
            }
        }
    }
}

