/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types.event;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Unsigned;
import java.util.Objects;
import org.starcoin.types.AccountAddress;

public final class NewBlockEvent {
    public final @Unsigned Long number;
    public final AccountAddress author;
    public final @Unsigned Long timestamp;
    public final @Unsigned Long uncles;

    public NewBlockEvent(@Unsigned Long number, AccountAddress author, @Unsigned Long timestamp, @Unsigned Long uncles) {
        Objects.requireNonNull(number, "number must not be null");
        Objects.requireNonNull(author, "author must not be null");
        Objects.requireNonNull(timestamp, "timestamp must not be null");
        Objects.requireNonNull(uncles, "uncles must not be null");
        this.number = number;
        this.author = author;
        this.timestamp = timestamp;
        this.uncles = uncles;
    }

    public static NewBlockEvent deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.number = deserializer.deserialize_u64();
        builder.author = AccountAddress.deserialize(deserializer);
        builder.timestamp = deserializer.deserialize_u64();
        builder.uncles = deserializer.deserialize_u64();
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static NewBlockEvent bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        NewBlockEvent value = NewBlockEvent.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        serializer.serialize_u64(this.number);
        this.author.serialize(serializer);
        serializer.serialize_u64(this.timestamp);
        serializer.serialize_u64(this.uncles);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NewBlockEvent other = (NewBlockEvent)obj;
        if (!Objects.equals(this.number, other.number)) {
            return false;
        }
        if (!Objects.equals(this.author, other.author)) {
            return false;
        }
        if (!Objects.equals(this.timestamp, other.timestamp)) {
            return false;
        }
        return Objects.equals(this.uncles, other.uncles);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.number != null ? this.number.hashCode() : 0);
        value = 31 * value + (this.author != null ? this.author.hashCode() : 0);
        value = 31 * value + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        value = 31 * value + (this.uncles != null ? this.uncles.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public @Unsigned Long number;
        public AccountAddress author;
        public @Unsigned Long timestamp;
        public @Unsigned Long uncles;

        public NewBlockEvent build() {
            return new NewBlockEvent(this.number, this.author, this.timestamp, this.uncles);
        }
    }
}

