/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.utils;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.starcoin.types.AccountAddress;
import org.starcoin.utils.Hex;

public class AccountAddressUtils {
    public static int ACCOUNT_ADDRESS_LENGTH = 16;

    public static AccountAddress create(byte[] bytes) {
        if (bytes.length != ACCOUNT_ADDRESS_LENGTH) {
            throw new IllegalArgumentException(String.format("account address bytes length must be {}", ACCOUNT_ADDRESS_LENGTH));
        }
        ArrayList<Byte> address = new ArrayList<Byte>();
        for (int i = 0; i < ACCOUNT_ADDRESS_LENGTH; ++i) {
            address.add(bytes[i]);
        }
        return new AccountAddress(address);
    }

    public static AccountAddress create(String address) {
        if (address.startsWith("0x")) {
            return AccountAddressUtils.create(Hex.decode(address.substring("0x".length())));
        }
        return AccountAddressUtils.create(Hex.decode(address));
    }

    public static AccountAddress from_hex_literal(String hexLiteral) {
        if (StringUtils.startsWithIgnoreCase((CharSequence)hexLiteral, (CharSequence)"0x")) {
            hexLiteral = hexLiteral.substring(2);
        }
        String hexStr = hexLiteral;
        int hexLen = hexLiteral.length();
        if (hexLen < 32) {
            StringBuilder builder = new StringBuilder();
            int missing = 32 - hexLen;
            for (int i = 0; i < missing; ++i) {
                builder.append('0');
            }
            builder.append(hexLiteral);
            hexStr = builder.toString();
        }
        return AccountAddress.valueOf(Hex.decode(hexStr));
    }

    public static String hex(AccountAddress address) {
        return Hex.encode(address.value);
    }

    public static byte[] bytes(AccountAddress address) {
        byte[] ret = new byte[ACCOUNT_ADDRESS_LENGTH];
        for (int i = 0; i < ACCOUNT_ADDRESS_LENGTH; ++i) {
            ret[i] = address.value.get(i);
        }
        return ret;
    }
}

