/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import com.thetransactioncompany.jsonrpc2.client.JSONRPC2Session;
import com.thetransactioncompany.jsonrpc2.client.JSONRPC2SessionException;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonRPCClient<T> {
    private static final Logger logger = LoggerFactory.getLogger(JsonRPCClient.class);

    JsonRPCClient() {
    }

    protected T getObject(JSONRPC2Session session, String method, List<Object> params, int requestId, Class<T> clazz) throws JSONRPC2SessionException {
        JSONRPC2Request request = new JSONRPC2Request(method, params, (Object)requestId);
        JSONRPC2Response response = session.send(request);
        if (response.indicatesSuccess()) {
            Object result = response.getResult();
            if (result != null) {
                return (T)JSON.parseObject((String)result.toString(), clazz);
            }
            logger.warn("get object result is null, method:" + method);
        } else {
            logger.error("get object array error:" + response.getError());
        }
        return null;
    }

    protected T getObjectParseJackson(JSONRPC2Session session, String method, List<Object> params, int requestId, Class<T> clazz) throws JSONRPC2SessionException, IOException {
        JSONRPC2Request request = new JSONRPC2Request(method, params, (Object)requestId);
        JSONRPC2Response response = session.send(request);
        if (response.indicatesSuccess()) {
            Object result = response.getResult();
            if (result != null) {
                ObjectMapper objectMapper = new ObjectMapper();
                return (T)objectMapper.readValue(result.toString(), clazz);
            }
            logger.warn("get object parse jackson result is null, method:" + method);
        } else {
            logger.error("get object parse jackson array error:" + response.getError());
        }
        return null;
    }

    protected T getSubObject(JSONRPC2Session session, String method, List<Object> params, int requestId, String subKey, Class<T> clazz) throws JSONRPC2SessionException {
        JSONRPC2Request request = new JSONRPC2Request(method, params, (Object)requestId);
        JSONRPC2Response response = session.send(request);
        if (response.indicatesSuccess()) {
            Object result = response.getResult();
            if (result != null) {
                JSONObject jb = JSON.parseObject((String)result.toString());
                return (T)jb.getObject(subKey, clazz);
            }
            logger.warn("get sub object result is null, method:" + method);
        } else {
            logger.error("get sub object array error:" + response.getError());
        }
        return null;
    }

    protected List<T> getObjectArray(JSONRPC2Session session, String method, List<Object> params, int requestId, Class<T> clazz) throws JSONRPC2SessionException {
        JSONRPC2Request request = new JSONRPC2Request(method, params, (Object)requestId);
        JSONRPC2Response response = session.send(request);
        if (response.indicatesSuccess()) {
            Object result = response.getResult();
            if (result != null) {
                return JSON.parseArray((String)result.toString(), clazz);
            }
            logger.warn("get object result is null, method:" + method);
        } else {
            logger.error("get object array error:" + response.getError());
        }
        return null;
    }
}

