/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.serde.format.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.starcoin.serde.format.ContainerFormat;
import org.starcoin.serde.format.Format;
import org.starcoin.serde.format.NamedFormat;
import org.starcoin.serde.format.NamedVariantFormat;

public class ContainerFormatDeserializer
extends JsonDeserializer<ContainerFormat> {
    @NotNull
    static List<NamedFormat> arrayNodeToNamedFormatList(ObjectCodec oc, ArrayNode namedFormatsNode) throws JsonProcessingException {
        ArrayList<NamedFormat> namedFormats = new ArrayList<NamedFormat>();
        for (JsonNode childNode : namedFormatsNode) {
            ObjectNode namedFormatNode = (ObjectNode)childNode;
            NamedFormat namedFormat = (NamedFormat)oc.treeToValue((TreeNode)namedFormatNode, NamedFormat.class);
            namedFormats.add(namedFormat);
        }
        return namedFormats;
    }

    public ContainerFormat deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectCodec oc = p.getCodec();
        JsonNode node = (JsonNode)oc.readTree(p);
        if (node instanceof TextNode) {
            if ("UNITSTRUCT".equals(node.asText())) {
                return new ContainerFormat.UnitStruct();
            }
        } else if (node instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)node;
            String firstFieldName = (String)objectNode.fieldNames().next();
            if ("NEWTYPESTRUCT".equals(firstFieldName)) {
                JsonNode formatNode = objectNode.get(firstFieldName);
                return new ContainerFormat.NewTypeStruct((Format)oc.treeToValue((TreeNode)formatNode, Format.class));
            }
            if ("TUPLESTRUCT".equals(firstFieldName)) {
                ArrayNode formatsNode = (ArrayNode)objectNode.get(firstFieldName);
                ArrayList<Format> formats = new ArrayList<Format>();
                for (JsonNode formatNode : formatsNode) {
                    formats.add((Format)oc.treeToValue((TreeNode)formatNode, Format.class));
                }
                return new ContainerFormat.TupleStruct(formats);
            }
            if ("STRUCT".equals(firstFieldName)) {
                ArrayNode namedFormatsNode = (ArrayNode)objectNode.get(firstFieldName);
                List<NamedFormat> namedFormats = ContainerFormatDeserializer.arrayNodeToNamedFormatList(oc, namedFormatsNode);
                return new ContainerFormat.Struct(namedFormats);
            }
            if ("ENUM".equals(firstFieldName)) {
                ObjectNode indexedNamedVariantFormatsNode = (ObjectNode)objectNode.get(firstFieldName);
                HashMap<Integer, NamedVariantFormat> indexedNamedVariantFormats = new HashMap<Integer, NamedVariantFormat>();
                Iterator iterator = indexedNamedVariantFormatsNode.fields();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    Integer index = Integer.valueOf((String)entry.getKey());
                    NamedVariantFormat namedVariantFormat = (NamedVariantFormat)oc.treeToValue((TreeNode)entry.getValue(), NamedVariantFormat.class);
                    indexedNamedVariantFormats.put(index, namedVariantFormat);
                }
                return new ContainerFormat.Enum(indexedNamedVariantFormats);
            }
        }
        throw new JsonParseException(p, "Unknown node type.");
    }
}

