/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.stdlib;

import com.novi.serde.Bytes;
import com.novi.serde.Int128;
import com.novi.serde.Unsigned;
import java.math.BigInteger;
import java.util.Objects;
import org.starcoin.types.AccountAddress;
import org.starcoin.types.TypeTag;

public abstract class ScriptFunctionCall {

    public static final class WithdrawTokenWithLinearWithdrawCapability
    extends ScriptFunctionCall {
        public final TypeTag token_t;

        public WithdrawTokenWithLinearWithdrawCapability(TypeTag token_t) {
            Objects.requireNonNull(token_t, "token_t must not be null");
            this.token_t = token_t;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WithdrawTokenWithLinearWithdrawCapability other = (WithdrawTokenWithLinearWithdrawCapability)obj;
            return Objects.equals(this.token_t, other.token_t);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token_t != null ? this.token_t.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token_t;

            public WithdrawTokenWithLinearWithdrawCapability build() {
                return new WithdrawTokenWithLinearWithdrawCapability(this.token_t);
            }
        }
    }

    public static final class WithdrawAndSplitLtWithdrawCap
    extends ScriptFunctionCall {
        public final TypeTag token_t;
        public final AccountAddress for_address;
        public final @Unsigned @Int128 BigInteger amount;
        public final @Unsigned Long lock_period;

        public WithdrawAndSplitLtWithdrawCap(TypeTag token_t, AccountAddress for_address, @Unsigned @Int128 BigInteger amount, @Unsigned Long lock_period) {
            Objects.requireNonNull(token_t, "token_t must not be null");
            Objects.requireNonNull(for_address, "for_address must not be null");
            Objects.requireNonNull(amount, "amount must not be null");
            Objects.requireNonNull(lock_period, "lock_period must not be null");
            this.token_t = token_t;
            this.for_address = for_address;
            this.amount = amount;
            this.lock_period = lock_period;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WithdrawAndSplitLtWithdrawCap other = (WithdrawAndSplitLtWithdrawCap)obj;
            if (!Objects.equals(this.token_t, other.token_t)) {
                return false;
            }
            if (!Objects.equals(this.for_address, other.for_address)) {
                return false;
            }
            if (!Objects.equals(this.amount, other.amount)) {
                return false;
            }
            return Objects.equals(this.lock_period, other.lock_period);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token_t != null ? this.token_t.hashCode() : 0);
            value = 31 * value + (this.for_address != null ? this.for_address.hashCode() : 0);
            value = 31 * value + (this.amount != null ? this.amount.hashCode() : 0);
            value = 31 * value + (this.lock_period != null ? this.lock_period.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token_t;
            public AccountAddress for_address;
            public @Unsigned @Int128 BigInteger amount;
            public @Unsigned Long lock_period;

            public WithdrawAndSplitLtWithdrawCap build() {
                return new WithdrawAndSplitLtWithdrawCap(this.token_t, this.for_address, this.amount, this.lock_period);
            }
        }
    }

    public static final class UpgradeFromV2ToV3
    extends ScriptFunctionCall {
        public final @Unsigned @Int128 BigInteger total_stc_amount;

        public UpgradeFromV2ToV3(@Unsigned @Int128 BigInteger total_stc_amount) {
            Objects.requireNonNull(total_stc_amount, "total_stc_amount must not be null");
            this.total_stc_amount = total_stc_amount;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UpgradeFromV2ToV3 other = (UpgradeFromV2ToV3)obj;
            return Objects.equals(this.total_stc_amount, other.total_stc_amount);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.total_stc_amount != null ? this.total_stc_amount.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned @Int128 BigInteger total_stc_amount;

            public UpgradeFromV2ToV3 build() {
                return new UpgradeFromV2ToV3(this.total_stc_amount);
            }
        }
    }

    public static final class UpdateModuleUpgradeStrategy
    extends ScriptFunctionCall {
        public final @Unsigned Byte strategy;

        public UpdateModuleUpgradeStrategy(@Unsigned Byte strategy) {
            Objects.requireNonNull(strategy, "strategy must not be null");
            this.strategy = strategy;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UpdateModuleUpgradeStrategy other = (UpdateModuleUpgradeStrategy)obj;
            return Objects.equals(this.strategy, other.strategy);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.strategy != null ? this.strategy.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Byte strategy;

            public UpdateModuleUpgradeStrategy build() {
                return new UpdateModuleUpgradeStrategy(this.strategy);
            }
        }
    }

    public static final class UnstakeVote
    extends ScriptFunctionCall {
        public final TypeTag token;
        public final TypeTag action;
        public final AccountAddress proposer_address;
        public final @Unsigned Long proposal_id;

        public UnstakeVote(TypeTag token, TypeTag action, AccountAddress proposer_address, @Unsigned Long proposal_id) {
            Objects.requireNonNull(token, "token must not be null");
            Objects.requireNonNull(action, "action must not be null");
            Objects.requireNonNull(proposer_address, "proposer_address must not be null");
            Objects.requireNonNull(proposal_id, "proposal_id must not be null");
            this.token = token;
            this.action = action;
            this.proposer_address = proposer_address;
            this.proposal_id = proposal_id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnstakeVote other = (UnstakeVote)obj;
            if (!Objects.equals(this.token, other.token)) {
                return false;
            }
            if (!Objects.equals(this.action, other.action)) {
                return false;
            }
            if (!Objects.equals(this.proposer_address, other.proposer_address)) {
                return false;
            }
            return Objects.equals(this.proposal_id, other.proposal_id);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token != null ? this.token.hashCode() : 0);
            value = 31 * value + (this.action != null ? this.action.hashCode() : 0);
            value = 31 * value + (this.proposer_address != null ? this.proposer_address.hashCode() : 0);
            value = 31 * value + (this.proposal_id != null ? this.proposal_id.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token;
            public TypeTag action;
            public AccountAddress proposer_address;
            public @Unsigned Long proposal_id;

            public UnstakeVote build() {
                return new UnstakeVote(this.token, this.action, this.proposer_address, this.proposal_id);
            }
        }
    }

    public static final class TakeOffer
    extends ScriptFunctionCall {
        public final TypeTag offered;
        public final AccountAddress offer_address;

        public TakeOffer(TypeTag offered, AccountAddress offer_address) {
            Objects.requireNonNull(offered, "offered must not be null");
            Objects.requireNonNull(offer_address, "offer_address must not be null");
            this.offered = offered;
            this.offer_address = offer_address;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TakeOffer other = (TakeOffer)obj;
            if (!Objects.equals(this.offered, other.offered)) {
                return false;
            }
            return Objects.equals(this.offer_address, other.offer_address);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.offered != null ? this.offered.hashCode() : 0);
            value = 31 * value + (this.offer_address != null ? this.offer_address.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag offered;
            public AccountAddress offer_address;

            public TakeOffer build() {
                return new TakeOffer(this.offered, this.offer_address);
            }
        }
    }

    public static final class TakeLinearWithdrawCapability
    extends ScriptFunctionCall {
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TakeLinearWithdrawCapability other = (TakeLinearWithdrawCapability)obj;
            return true;
        }

        public int hashCode() {
            int value = 7;
            return value;
        }

        public static final class Builder {
            public TakeLinearWithdrawCapability build() {
                return new TakeLinearWithdrawCapability();
            }
        }
    }

    public static final class SubmitModuleUpgradePlan
    extends ScriptFunctionCall {
        public final TypeTag token;
        public final AccountAddress proposer_address;
        public final @Unsigned Long proposal_id;

        public SubmitModuleUpgradePlan(TypeTag token, AccountAddress proposer_address, @Unsigned Long proposal_id) {
            Objects.requireNonNull(token, "token must not be null");
            Objects.requireNonNull(proposer_address, "proposer_address must not be null");
            Objects.requireNonNull(proposal_id, "proposal_id must not be null");
            this.token = token;
            this.proposer_address = proposer_address;
            this.proposal_id = proposal_id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SubmitModuleUpgradePlan other = (SubmitModuleUpgradePlan)obj;
            if (!Objects.equals(this.token, other.token)) {
                return false;
            }
            if (!Objects.equals(this.proposer_address, other.proposer_address)) {
                return false;
            }
            return Objects.equals(this.proposal_id, other.proposal_id);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token != null ? this.token.hashCode() : 0);
            value = 31 * value + (this.proposer_address != null ? this.proposer_address.hashCode() : 0);
            value = 31 * value + (this.proposal_id != null ? this.proposal_id.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token;
            public AccountAddress proposer_address;
            public @Unsigned Long proposal_id;

            public SubmitModuleUpgradePlan build() {
                return new SubmitModuleUpgradePlan(this.token, this.proposer_address, this.proposal_id);
            }
        }
    }

    public static final class RotateAuthenticationKey
    extends ScriptFunctionCall {
        public final Bytes new_key;

        public RotateAuthenticationKey(Bytes new_key) {
            Objects.requireNonNull(new_key, "new_key must not be null");
            this.new_key = new_key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RotateAuthenticationKey other = (RotateAuthenticationKey)obj;
            return Objects.equals(this.new_key, other.new_key);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.new_key != null ? this.new_key.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public Bytes new_key;

            public RotateAuthenticationKey build() {
                return new RotateAuthenticationKey(this.new_key);
            }
        }
    }

    public static final class RevokeVote
    extends ScriptFunctionCall {
        public final TypeTag token;
        public final TypeTag action;
        public final AccountAddress proposer_address;
        public final @Unsigned Long proposal_id;

        public RevokeVote(TypeTag token, TypeTag action, AccountAddress proposer_address, @Unsigned Long proposal_id) {
            Objects.requireNonNull(token, "token must not be null");
            Objects.requireNonNull(action, "action must not be null");
            Objects.requireNonNull(proposer_address, "proposer_address must not be null");
            Objects.requireNonNull(proposal_id, "proposal_id must not be null");
            this.token = token;
            this.action = action;
            this.proposer_address = proposer_address;
            this.proposal_id = proposal_id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RevokeVote other = (RevokeVote)obj;
            if (!Objects.equals(this.token, other.token)) {
                return false;
            }
            if (!Objects.equals(this.action, other.action)) {
                return false;
            }
            if (!Objects.equals(this.proposer_address, other.proposer_address)) {
                return false;
            }
            return Objects.equals(this.proposal_id, other.proposal_id);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token != null ? this.token.hashCode() : 0);
            value = 31 * value + (this.action != null ? this.action.hashCode() : 0);
            value = 31 * value + (this.proposer_address != null ? this.proposer_address.hashCode() : 0);
            value = 31 * value + (this.proposal_id != null ? this.proposal_id.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token;
            public TypeTag action;
            public AccountAddress proposer_address;
            public @Unsigned Long proposal_id;

            public RevokeVote build() {
                return new RevokeVote(this.token, this.action, this.proposer_address, this.proposal_id);
            }
        }
    }

    public static final class QueueProposalAction
    extends ScriptFunctionCall {
        public final TypeTag token_t;
        public final TypeTag action_t;
        public final AccountAddress proposer_address;
        public final @Unsigned Long proposal_id;

        public QueueProposalAction(TypeTag token_t, TypeTag action_t, AccountAddress proposer_address, @Unsigned Long proposal_id) {
            Objects.requireNonNull(token_t, "token_t must not be null");
            Objects.requireNonNull(action_t, "action_t must not be null");
            Objects.requireNonNull(proposer_address, "proposer_address must not be null");
            Objects.requireNonNull(proposal_id, "proposal_id must not be null");
            this.token_t = token_t;
            this.action_t = action_t;
            this.proposer_address = proposer_address;
            this.proposal_id = proposal_id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueueProposalAction other = (QueueProposalAction)obj;
            if (!Objects.equals(this.token_t, other.token_t)) {
                return false;
            }
            if (!Objects.equals(this.action_t, other.action_t)) {
                return false;
            }
            if (!Objects.equals(this.proposer_address, other.proposer_address)) {
                return false;
            }
            return Objects.equals(this.proposal_id, other.proposal_id);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token_t != null ? this.token_t.hashCode() : 0);
            value = 31 * value + (this.action_t != null ? this.action_t.hashCode() : 0);
            value = 31 * value + (this.proposer_address != null ? this.proposer_address.hashCode() : 0);
            value = 31 * value + (this.proposal_id != null ? this.proposal_id.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token_t;
            public TypeTag action_t;
            public AccountAddress proposer_address;
            public @Unsigned Long proposal_id;

            public QueueProposalAction build() {
                return new QueueProposalAction(this.token_t, this.action_t, this.proposer_address, this.proposal_id);
            }
        }
    }

    public static final class ProposeWithdraw
    extends ScriptFunctionCall {
        public final TypeTag token_t;
        public final AccountAddress receiver;
        public final @Unsigned @Int128 BigInteger amount;
        public final @Unsigned Long period;
        public final @Unsigned Long exec_delay;

        public ProposeWithdraw(TypeTag token_t, AccountAddress receiver, @Unsigned @Int128 BigInteger amount, @Unsigned Long period, @Unsigned Long exec_delay) {
            Objects.requireNonNull(token_t, "token_t must not be null");
            Objects.requireNonNull(receiver, "receiver must not be null");
            Objects.requireNonNull(amount, "amount must not be null");
            Objects.requireNonNull(period, "period must not be null");
            Objects.requireNonNull(exec_delay, "exec_delay must not be null");
            this.token_t = token_t;
            this.receiver = receiver;
            this.amount = amount;
            this.period = period;
            this.exec_delay = exec_delay;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProposeWithdraw other = (ProposeWithdraw)obj;
            if (!Objects.equals(this.token_t, other.token_t)) {
                return false;
            }
            if (!Objects.equals(this.receiver, other.receiver)) {
                return false;
            }
            if (!Objects.equals(this.amount, other.amount)) {
                return false;
            }
            if (!Objects.equals(this.period, other.period)) {
                return false;
            }
            return Objects.equals(this.exec_delay, other.exec_delay);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token_t != null ? this.token_t.hashCode() : 0);
            value = 31 * value + (this.receiver != null ? this.receiver.hashCode() : 0);
            value = 31 * value + (this.amount != null ? this.amount.hashCode() : 0);
            value = 31 * value + (this.period != null ? this.period.hashCode() : 0);
            value = 31 * value + (this.exec_delay != null ? this.exec_delay.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token_t;
            public AccountAddress receiver;
            public @Unsigned @Int128 BigInteger amount;
            public @Unsigned Long period;
            public @Unsigned Long exec_delay;

            public ProposeWithdraw build() {
                return new ProposeWithdraw(this.token_t, this.receiver, this.amount, this.period, this.exec_delay);
            }
        }
    }

    public static final class ProposeUpdateVmConfig
    extends ScriptFunctionCall {
        public final Bytes instruction_schedule;
        public final Bytes native_schedule;
        public final @Unsigned Long global_memory_per_byte_cost;
        public final @Unsigned Long global_memory_per_byte_write_cost;
        public final @Unsigned Long min_transaction_gas_units;
        public final @Unsigned Long large_transaction_cutoff;
        public final @Unsigned Long instrinsic_gas_per_byte;
        public final @Unsigned Long maximum_number_of_gas_units;
        public final @Unsigned Long min_price_per_gas_unit;
        public final @Unsigned Long max_price_per_gas_unit;
        public final @Unsigned Long max_transaction_size_in_bytes;
        public final @Unsigned Long gas_unit_scaling_factor;
        public final @Unsigned Long default_account_size;
        public final @Unsigned Long exec_delay;

        public ProposeUpdateVmConfig(Bytes instruction_schedule, Bytes native_schedule, @Unsigned Long global_memory_per_byte_cost, @Unsigned Long global_memory_per_byte_write_cost, @Unsigned Long min_transaction_gas_units, @Unsigned Long large_transaction_cutoff, @Unsigned Long instrinsic_gas_per_byte, @Unsigned Long maximum_number_of_gas_units, @Unsigned Long min_price_per_gas_unit, @Unsigned Long max_price_per_gas_unit, @Unsigned Long max_transaction_size_in_bytes, @Unsigned Long gas_unit_scaling_factor, @Unsigned Long default_account_size, @Unsigned Long exec_delay) {
            Objects.requireNonNull(instruction_schedule, "instruction_schedule must not be null");
            Objects.requireNonNull(native_schedule, "native_schedule must not be null");
            Objects.requireNonNull(global_memory_per_byte_cost, "global_memory_per_byte_cost must not be null");
            Objects.requireNonNull(global_memory_per_byte_write_cost, "global_memory_per_byte_write_cost must not be null");
            Objects.requireNonNull(min_transaction_gas_units, "min_transaction_gas_units must not be null");
            Objects.requireNonNull(large_transaction_cutoff, "large_transaction_cutoff must not be null");
            Objects.requireNonNull(instrinsic_gas_per_byte, "instrinsic_gas_per_byte must not be null");
            Objects.requireNonNull(maximum_number_of_gas_units, "maximum_number_of_gas_units must not be null");
            Objects.requireNonNull(min_price_per_gas_unit, "min_price_per_gas_unit must not be null");
            Objects.requireNonNull(max_price_per_gas_unit, "max_price_per_gas_unit must not be null");
            Objects.requireNonNull(max_transaction_size_in_bytes, "max_transaction_size_in_bytes must not be null");
            Objects.requireNonNull(gas_unit_scaling_factor, "gas_unit_scaling_factor must not be null");
            Objects.requireNonNull(default_account_size, "default_account_size must not be null");
            Objects.requireNonNull(exec_delay, "exec_delay must not be null");
            this.instruction_schedule = instruction_schedule;
            this.native_schedule = native_schedule;
            this.global_memory_per_byte_cost = global_memory_per_byte_cost;
            this.global_memory_per_byte_write_cost = global_memory_per_byte_write_cost;
            this.min_transaction_gas_units = min_transaction_gas_units;
            this.large_transaction_cutoff = large_transaction_cutoff;
            this.instrinsic_gas_per_byte = instrinsic_gas_per_byte;
            this.maximum_number_of_gas_units = maximum_number_of_gas_units;
            this.min_price_per_gas_unit = min_price_per_gas_unit;
            this.max_price_per_gas_unit = max_price_per_gas_unit;
            this.max_transaction_size_in_bytes = max_transaction_size_in_bytes;
            this.gas_unit_scaling_factor = gas_unit_scaling_factor;
            this.default_account_size = default_account_size;
            this.exec_delay = exec_delay;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProposeUpdateVmConfig other = (ProposeUpdateVmConfig)obj;
            if (!Objects.equals(this.instruction_schedule, other.instruction_schedule)) {
                return false;
            }
            if (!Objects.equals(this.native_schedule, other.native_schedule)) {
                return false;
            }
            if (!Objects.equals(this.global_memory_per_byte_cost, other.global_memory_per_byte_cost)) {
                return false;
            }
            if (!Objects.equals(this.global_memory_per_byte_write_cost, other.global_memory_per_byte_write_cost)) {
                return false;
            }
            if (!Objects.equals(this.min_transaction_gas_units, other.min_transaction_gas_units)) {
                return false;
            }
            if (!Objects.equals(this.large_transaction_cutoff, other.large_transaction_cutoff)) {
                return false;
            }
            if (!Objects.equals(this.instrinsic_gas_per_byte, other.instrinsic_gas_per_byte)) {
                return false;
            }
            if (!Objects.equals(this.maximum_number_of_gas_units, other.maximum_number_of_gas_units)) {
                return false;
            }
            if (!Objects.equals(this.min_price_per_gas_unit, other.min_price_per_gas_unit)) {
                return false;
            }
            if (!Objects.equals(this.max_price_per_gas_unit, other.max_price_per_gas_unit)) {
                return false;
            }
            if (!Objects.equals(this.max_transaction_size_in_bytes, other.max_transaction_size_in_bytes)) {
                return false;
            }
            if (!Objects.equals(this.gas_unit_scaling_factor, other.gas_unit_scaling_factor)) {
                return false;
            }
            if (!Objects.equals(this.default_account_size, other.default_account_size)) {
                return false;
            }
            return Objects.equals(this.exec_delay, other.exec_delay);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.instruction_schedule != null ? this.instruction_schedule.hashCode() : 0);
            value = 31 * value + (this.native_schedule != null ? this.native_schedule.hashCode() : 0);
            value = 31 * value + (this.global_memory_per_byte_cost != null ? this.global_memory_per_byte_cost.hashCode() : 0);
            value = 31 * value + (this.global_memory_per_byte_write_cost != null ? this.global_memory_per_byte_write_cost.hashCode() : 0);
            value = 31 * value + (this.min_transaction_gas_units != null ? this.min_transaction_gas_units.hashCode() : 0);
            value = 31 * value + (this.large_transaction_cutoff != null ? this.large_transaction_cutoff.hashCode() : 0);
            value = 31 * value + (this.instrinsic_gas_per_byte != null ? this.instrinsic_gas_per_byte.hashCode() : 0);
            value = 31 * value + (this.maximum_number_of_gas_units != null ? this.maximum_number_of_gas_units.hashCode() : 0);
            value = 31 * value + (this.min_price_per_gas_unit != null ? this.min_price_per_gas_unit.hashCode() : 0);
            value = 31 * value + (this.max_price_per_gas_unit != null ? this.max_price_per_gas_unit.hashCode() : 0);
            value = 31 * value + (this.max_transaction_size_in_bytes != null ? this.max_transaction_size_in_bytes.hashCode() : 0);
            value = 31 * value + (this.gas_unit_scaling_factor != null ? this.gas_unit_scaling_factor.hashCode() : 0);
            value = 31 * value + (this.default_account_size != null ? this.default_account_size.hashCode() : 0);
            value = 31 * value + (this.exec_delay != null ? this.exec_delay.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public Bytes instruction_schedule;
            public Bytes native_schedule;
            public @Unsigned Long global_memory_per_byte_cost;
            public @Unsigned Long global_memory_per_byte_write_cost;
            public @Unsigned Long min_transaction_gas_units;
            public @Unsigned Long large_transaction_cutoff;
            public @Unsigned Long instrinsic_gas_per_byte;
            public @Unsigned Long maximum_number_of_gas_units;
            public @Unsigned Long min_price_per_gas_unit;
            public @Unsigned Long max_price_per_gas_unit;
            public @Unsigned Long max_transaction_size_in_bytes;
            public @Unsigned Long gas_unit_scaling_factor;
            public @Unsigned Long default_account_size;
            public @Unsigned Long exec_delay;

            public ProposeUpdateVmConfig build() {
                return new ProposeUpdateVmConfig(this.instruction_schedule, this.native_schedule, this.global_memory_per_byte_cost, this.global_memory_per_byte_write_cost, this.min_transaction_gas_units, this.large_transaction_cutoff, this.instrinsic_gas_per_byte, this.maximum_number_of_gas_units, this.min_price_per_gas_unit, this.max_price_per_gas_unit, this.max_transaction_size_in_bytes, this.gas_unit_scaling_factor, this.default_account_size, this.exec_delay);
            }
        }
    }

    public static final class ProposeUpdateTxnTimeoutConfig
    extends ScriptFunctionCall {
        public final @Unsigned Long duration_seconds;
        public final @Unsigned Long exec_delay;

        public ProposeUpdateTxnTimeoutConfig(@Unsigned Long duration_seconds, @Unsigned Long exec_delay) {
            Objects.requireNonNull(duration_seconds, "duration_seconds must not be null");
            Objects.requireNonNull(exec_delay, "exec_delay must not be null");
            this.duration_seconds = duration_seconds;
            this.exec_delay = exec_delay;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProposeUpdateTxnTimeoutConfig other = (ProposeUpdateTxnTimeoutConfig)obj;
            if (!Objects.equals(this.duration_seconds, other.duration_seconds)) {
                return false;
            }
            return Objects.equals(this.exec_delay, other.exec_delay);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.duration_seconds != null ? this.duration_seconds.hashCode() : 0);
            value = 31 * value + (this.exec_delay != null ? this.exec_delay.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Long duration_seconds;
            public @Unsigned Long exec_delay;

            public ProposeUpdateTxnTimeoutConfig build() {
                return new ProposeUpdateTxnTimeoutConfig(this.duration_seconds, this.exec_delay);
            }
        }
    }

    public static final class ProposeUpdateTxnPublishOption
    extends ScriptFunctionCall {
        public final Boolean script_allowed;
        public final Boolean module_publishing_allowed;
        public final @Unsigned Long exec_delay;

        public ProposeUpdateTxnPublishOption(Boolean script_allowed, Boolean module_publishing_allowed, @Unsigned Long exec_delay) {
            Objects.requireNonNull(script_allowed, "script_allowed must not be null");
            Objects.requireNonNull(module_publishing_allowed, "module_publishing_allowed must not be null");
            Objects.requireNonNull(exec_delay, "exec_delay must not be null");
            this.script_allowed = script_allowed;
            this.module_publishing_allowed = module_publishing_allowed;
            this.exec_delay = exec_delay;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProposeUpdateTxnPublishOption other = (ProposeUpdateTxnPublishOption)obj;
            if (!Objects.equals(this.script_allowed, other.script_allowed)) {
                return false;
            }
            if (!Objects.equals(this.module_publishing_allowed, other.module_publishing_allowed)) {
                return false;
            }
            return Objects.equals(this.exec_delay, other.exec_delay);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.script_allowed != null ? this.script_allowed.hashCode() : 0);
            value = 31 * value + (this.module_publishing_allowed != null ? this.module_publishing_allowed.hashCode() : 0);
            value = 31 * value + (this.exec_delay != null ? this.exec_delay.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public Boolean script_allowed;
            public Boolean module_publishing_allowed;
            public @Unsigned Long exec_delay;

            public ProposeUpdateTxnPublishOption build() {
                return new ProposeUpdateTxnPublishOption(this.script_allowed, this.module_publishing_allowed, this.exec_delay);
            }
        }
    }

    public static final class ProposeUpdateRewardConfig
    extends ScriptFunctionCall {
        public final @Unsigned Long reward_delay;
        public final @Unsigned Long exec_delay;

        public ProposeUpdateRewardConfig(@Unsigned Long reward_delay, @Unsigned Long exec_delay) {
            Objects.requireNonNull(reward_delay, "reward_delay must not be null");
            Objects.requireNonNull(exec_delay, "exec_delay must not be null");
            this.reward_delay = reward_delay;
            this.exec_delay = exec_delay;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProposeUpdateRewardConfig other = (ProposeUpdateRewardConfig)obj;
            if (!Objects.equals(this.reward_delay, other.reward_delay)) {
                return false;
            }
            return Objects.equals(this.exec_delay, other.exec_delay);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.reward_delay != null ? this.reward_delay.hashCode() : 0);
            value = 31 * value + (this.exec_delay != null ? this.exec_delay.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Long reward_delay;
            public @Unsigned Long exec_delay;

            public ProposeUpdateRewardConfig build() {
                return new ProposeUpdateRewardConfig(this.reward_delay, this.exec_delay);
            }
        }
    }

    public static final class ProposeUpdateConsensusConfig
    extends ScriptFunctionCall {
        public final @Unsigned Long uncle_rate_target;
        public final @Unsigned Long base_block_time_target;
        public final @Unsigned @Int128 BigInteger base_reward_per_block;
        public final @Unsigned Long base_reward_per_uncle_percent;
        public final @Unsigned Long epoch_block_count;
        public final @Unsigned Long base_block_difficulty_window;
        public final @Unsigned Long min_block_time_target;
        public final @Unsigned Long max_block_time_target;
        public final @Unsigned Long base_max_uncles_per_block;
        public final @Unsigned Long base_block_gas_limit;
        public final @Unsigned Byte strategy;
        public final @Unsigned Long exec_delay;

        public ProposeUpdateConsensusConfig(@Unsigned Long uncle_rate_target, @Unsigned Long base_block_time_target, @Unsigned @Int128 BigInteger base_reward_per_block, @Unsigned Long base_reward_per_uncle_percent, @Unsigned Long epoch_block_count, @Unsigned Long base_block_difficulty_window, @Unsigned Long min_block_time_target, @Unsigned Long max_block_time_target, @Unsigned Long base_max_uncles_per_block, @Unsigned Long base_block_gas_limit, @Unsigned Byte strategy, @Unsigned Long exec_delay) {
            Objects.requireNonNull(uncle_rate_target, "uncle_rate_target must not be null");
            Objects.requireNonNull(base_block_time_target, "base_block_time_target must not be null");
            Objects.requireNonNull(base_reward_per_block, "base_reward_per_block must not be null");
            Objects.requireNonNull(base_reward_per_uncle_percent, "base_reward_per_uncle_percent must not be null");
            Objects.requireNonNull(epoch_block_count, "epoch_block_count must not be null");
            Objects.requireNonNull(base_block_difficulty_window, "base_block_difficulty_window must not be null");
            Objects.requireNonNull(min_block_time_target, "min_block_time_target must not be null");
            Objects.requireNonNull(max_block_time_target, "max_block_time_target must not be null");
            Objects.requireNonNull(base_max_uncles_per_block, "base_max_uncles_per_block must not be null");
            Objects.requireNonNull(base_block_gas_limit, "base_block_gas_limit must not be null");
            Objects.requireNonNull(strategy, "strategy must not be null");
            Objects.requireNonNull(exec_delay, "exec_delay must not be null");
            this.uncle_rate_target = uncle_rate_target;
            this.base_block_time_target = base_block_time_target;
            this.base_reward_per_block = base_reward_per_block;
            this.base_reward_per_uncle_percent = base_reward_per_uncle_percent;
            this.epoch_block_count = epoch_block_count;
            this.base_block_difficulty_window = base_block_difficulty_window;
            this.min_block_time_target = min_block_time_target;
            this.max_block_time_target = max_block_time_target;
            this.base_max_uncles_per_block = base_max_uncles_per_block;
            this.base_block_gas_limit = base_block_gas_limit;
            this.strategy = strategy;
            this.exec_delay = exec_delay;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProposeUpdateConsensusConfig other = (ProposeUpdateConsensusConfig)obj;
            if (!Objects.equals(this.uncle_rate_target, other.uncle_rate_target)) {
                return false;
            }
            if (!Objects.equals(this.base_block_time_target, other.base_block_time_target)) {
                return false;
            }
            if (!Objects.equals(this.base_reward_per_block, other.base_reward_per_block)) {
                return false;
            }
            if (!Objects.equals(this.base_reward_per_uncle_percent, other.base_reward_per_uncle_percent)) {
                return false;
            }
            if (!Objects.equals(this.epoch_block_count, other.epoch_block_count)) {
                return false;
            }
            if (!Objects.equals(this.base_block_difficulty_window, other.base_block_difficulty_window)) {
                return false;
            }
            if (!Objects.equals(this.min_block_time_target, other.min_block_time_target)) {
                return false;
            }
            if (!Objects.equals(this.max_block_time_target, other.max_block_time_target)) {
                return false;
            }
            if (!Objects.equals(this.base_max_uncles_per_block, other.base_max_uncles_per_block)) {
                return false;
            }
            if (!Objects.equals(this.base_block_gas_limit, other.base_block_gas_limit)) {
                return false;
            }
            if (!Objects.equals(this.strategy, other.strategy)) {
                return false;
            }
            return Objects.equals(this.exec_delay, other.exec_delay);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.uncle_rate_target != null ? this.uncle_rate_target.hashCode() : 0);
            value = 31 * value + (this.base_block_time_target != null ? this.base_block_time_target.hashCode() : 0);
            value = 31 * value + (this.base_reward_per_block != null ? this.base_reward_per_block.hashCode() : 0);
            value = 31 * value + (this.base_reward_per_uncle_percent != null ? this.base_reward_per_uncle_percent.hashCode() : 0);
            value = 31 * value + (this.epoch_block_count != null ? this.epoch_block_count.hashCode() : 0);
            value = 31 * value + (this.base_block_difficulty_window != null ? this.base_block_difficulty_window.hashCode() : 0);
            value = 31 * value + (this.min_block_time_target != null ? this.min_block_time_target.hashCode() : 0);
            value = 31 * value + (this.max_block_time_target != null ? this.max_block_time_target.hashCode() : 0);
            value = 31 * value + (this.base_max_uncles_per_block != null ? this.base_max_uncles_per_block.hashCode() : 0);
            value = 31 * value + (this.base_block_gas_limit != null ? this.base_block_gas_limit.hashCode() : 0);
            value = 31 * value + (this.strategy != null ? this.strategy.hashCode() : 0);
            value = 31 * value + (this.exec_delay != null ? this.exec_delay.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Long uncle_rate_target;
            public @Unsigned Long base_block_time_target;
            public @Unsigned @Int128 BigInteger base_reward_per_block;
            public @Unsigned Long base_reward_per_uncle_percent;
            public @Unsigned Long epoch_block_count;
            public @Unsigned Long base_block_difficulty_window;
            public @Unsigned Long min_block_time_target;
            public @Unsigned Long max_block_time_target;
            public @Unsigned Long base_max_uncles_per_block;
            public @Unsigned Long base_block_gas_limit;
            public @Unsigned Byte strategy;
            public @Unsigned Long exec_delay;

            public ProposeUpdateConsensusConfig build() {
                return new ProposeUpdateConsensusConfig(this.uncle_rate_target, this.base_block_time_target, this.base_reward_per_block, this.base_reward_per_uncle_percent, this.epoch_block_count, this.base_block_difficulty_window, this.min_block_time_target, this.max_block_time_target, this.base_max_uncles_per_block, this.base_block_gas_limit, this.strategy, this.exec_delay);
            }
        }
    }

    public static final class ProposeModuleUpgradeV2
    extends ScriptFunctionCall {
        public final TypeTag token;
        public final AccountAddress module_address;
        public final Bytes package_hash;
        public final @Unsigned Long version;
        public final @Unsigned Long exec_delay;
        public final Boolean enforced;

        public ProposeModuleUpgradeV2(TypeTag token, AccountAddress module_address, Bytes package_hash, @Unsigned Long version, @Unsigned Long exec_delay, Boolean enforced) {
            Objects.requireNonNull(token, "token must not be null");
            Objects.requireNonNull(module_address, "module_address must not be null");
            Objects.requireNonNull(package_hash, "package_hash must not be null");
            Objects.requireNonNull(version, "version must not be null");
            Objects.requireNonNull(exec_delay, "exec_delay must not be null");
            Objects.requireNonNull(enforced, "enforced must not be null");
            this.token = token;
            this.module_address = module_address;
            this.package_hash = package_hash;
            this.version = version;
            this.exec_delay = exec_delay;
            this.enforced = enforced;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProposeModuleUpgradeV2 other = (ProposeModuleUpgradeV2)obj;
            if (!Objects.equals(this.token, other.token)) {
                return false;
            }
            if (!Objects.equals(this.module_address, other.module_address)) {
                return false;
            }
            if (!Objects.equals(this.package_hash, other.package_hash)) {
                return false;
            }
            if (!Objects.equals(this.version, other.version)) {
                return false;
            }
            if (!Objects.equals(this.exec_delay, other.exec_delay)) {
                return false;
            }
            return Objects.equals(this.enforced, other.enforced);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token != null ? this.token.hashCode() : 0);
            value = 31 * value + (this.module_address != null ? this.module_address.hashCode() : 0);
            value = 31 * value + (this.package_hash != null ? this.package_hash.hashCode() : 0);
            value = 31 * value + (this.version != null ? this.version.hashCode() : 0);
            value = 31 * value + (this.exec_delay != null ? this.exec_delay.hashCode() : 0);
            value = 31 * value + (this.enforced != null ? this.enforced.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token;
            public AccountAddress module_address;
            public Bytes package_hash;
            public @Unsigned Long version;
            public @Unsigned Long exec_delay;
            public Boolean enforced;

            public ProposeModuleUpgradeV2 build() {
                return new ProposeModuleUpgradeV2(this.token, this.module_address, this.package_hash, this.version, this.exec_delay, this.enforced);
            }
        }
    }

    public static final class Propose
    extends ScriptFunctionCall {
        public final TypeTag token_t;
        public final @Unsigned Long voting_delay;
        public final @Unsigned Long voting_period;
        public final @Unsigned Byte voting_quorum_rate;
        public final @Unsigned Long min_action_delay;
        public final @Unsigned Long exec_delay;

        public Propose(TypeTag token_t, @Unsigned Long voting_delay, @Unsigned Long voting_period, @Unsigned Byte voting_quorum_rate, @Unsigned Long min_action_delay, @Unsigned Long exec_delay) {
            Objects.requireNonNull(token_t, "token_t must not be null");
            Objects.requireNonNull(voting_delay, "voting_delay must not be null");
            Objects.requireNonNull(voting_period, "voting_period must not be null");
            Objects.requireNonNull(voting_quorum_rate, "voting_quorum_rate must not be null");
            Objects.requireNonNull(min_action_delay, "min_action_delay must not be null");
            Objects.requireNonNull(exec_delay, "exec_delay must not be null");
            this.token_t = token_t;
            this.voting_delay = voting_delay;
            this.voting_period = voting_period;
            this.voting_quorum_rate = voting_quorum_rate;
            this.min_action_delay = min_action_delay;
            this.exec_delay = exec_delay;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Propose other = (Propose)obj;
            if (!Objects.equals(this.token_t, other.token_t)) {
                return false;
            }
            if (!Objects.equals(this.voting_delay, other.voting_delay)) {
                return false;
            }
            if (!Objects.equals(this.voting_period, other.voting_period)) {
                return false;
            }
            if (!Objects.equals(this.voting_quorum_rate, other.voting_quorum_rate)) {
                return false;
            }
            if (!Objects.equals(this.min_action_delay, other.min_action_delay)) {
                return false;
            }
            return Objects.equals(this.exec_delay, other.exec_delay);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token_t != null ? this.token_t.hashCode() : 0);
            value = 31 * value + (this.voting_delay != null ? this.voting_delay.hashCode() : 0);
            value = 31 * value + (this.voting_period != null ? this.voting_period.hashCode() : 0);
            value = 31 * value + (this.voting_quorum_rate != null ? this.voting_quorum_rate.hashCode() : 0);
            value = 31 * value + (this.min_action_delay != null ? this.min_action_delay.hashCode() : 0);
            value = 31 * value + (this.exec_delay != null ? this.exec_delay.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token_t;
            public @Unsigned Long voting_delay;
            public @Unsigned Long voting_period;
            public @Unsigned Byte voting_quorum_rate;
            public @Unsigned Long min_action_delay;
            public @Unsigned Long exec_delay;

            public Propose build() {
                return new Propose(this.token_t, this.voting_delay, this.voting_period, this.voting_quorum_rate, this.min_action_delay, this.exec_delay);
            }
        }
    }

    public static final class PeerToPeerWithMetadataV2
    extends ScriptFunctionCall {
        public final TypeTag token_type;
        public final AccountAddress payee;
        public final @Unsigned @Int128 BigInteger amount;
        public final Bytes metadata;

        public PeerToPeerWithMetadataV2(TypeTag token_type, AccountAddress payee, @Unsigned @Int128 BigInteger amount, Bytes metadata) {
            Objects.requireNonNull(token_type, "token_type must not be null");
            Objects.requireNonNull(payee, "payee must not be null");
            Objects.requireNonNull(amount, "amount must not be null");
            Objects.requireNonNull(metadata, "metadata must not be null");
            this.token_type = token_type;
            this.payee = payee;
            this.amount = amount;
            this.metadata = metadata;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PeerToPeerWithMetadataV2 other = (PeerToPeerWithMetadataV2)obj;
            if (!Objects.equals(this.token_type, other.token_type)) {
                return false;
            }
            if (!Objects.equals(this.payee, other.payee)) {
                return false;
            }
            if (!Objects.equals(this.amount, other.amount)) {
                return false;
            }
            return Objects.equals(this.metadata, other.metadata);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token_type != null ? this.token_type.hashCode() : 0);
            value = 31 * value + (this.payee != null ? this.payee.hashCode() : 0);
            value = 31 * value + (this.amount != null ? this.amount.hashCode() : 0);
            value = 31 * value + (this.metadata != null ? this.metadata.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token_type;
            public AccountAddress payee;
            public @Unsigned @Int128 BigInteger amount;
            public Bytes metadata;

            public PeerToPeerWithMetadataV2 build() {
                return new PeerToPeerWithMetadataV2(this.token_type, this.payee, this.amount, this.metadata);
            }
        }
    }

    public static final class PeerToPeerWithMetadata
    extends ScriptFunctionCall {
        public final TypeTag token_type;
        public final AccountAddress payee;
        public final Bytes _payee_auth_key;
        public final @Unsigned @Int128 BigInteger amount;
        public final Bytes metadata;

        public PeerToPeerWithMetadata(TypeTag token_type, AccountAddress payee, Bytes _payee_auth_key, @Unsigned @Int128 BigInteger amount, Bytes metadata) {
            Objects.requireNonNull(token_type, "token_type must not be null");
            Objects.requireNonNull(payee, "payee must not be null");
            Objects.requireNonNull(_payee_auth_key, "_payee_auth_key must not be null");
            Objects.requireNonNull(amount, "amount must not be null");
            Objects.requireNonNull(metadata, "metadata must not be null");
            this.token_type = token_type;
            this.payee = payee;
            this._payee_auth_key = _payee_auth_key;
            this.amount = amount;
            this.metadata = metadata;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PeerToPeerWithMetadata other = (PeerToPeerWithMetadata)obj;
            if (!Objects.equals(this.token_type, other.token_type)) {
                return false;
            }
            if (!Objects.equals(this.payee, other.payee)) {
                return false;
            }
            if (!Objects.equals(this._payee_auth_key, other._payee_auth_key)) {
                return false;
            }
            if (!Objects.equals(this.amount, other.amount)) {
                return false;
            }
            return Objects.equals(this.metadata, other.metadata);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token_type != null ? this.token_type.hashCode() : 0);
            value = 31 * value + (this.payee != null ? this.payee.hashCode() : 0);
            value = 31 * value + (this._payee_auth_key != null ? this._payee_auth_key.hashCode() : 0);
            value = 31 * value + (this.amount != null ? this.amount.hashCode() : 0);
            value = 31 * value + (this.metadata != null ? this.metadata.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token_type;
            public AccountAddress payee;
            public Bytes _payee_auth_key;
            public @Unsigned @Int128 BigInteger amount;
            public Bytes metadata;

            public PeerToPeerWithMetadata build() {
                return new PeerToPeerWithMetadata(this.token_type, this.payee, this._payee_auth_key, this.amount, this.metadata);
            }
        }
    }

    public static final class PeerToPeerV2
    extends ScriptFunctionCall {
        public final TypeTag token_type;
        public final AccountAddress payee;
        public final @Unsigned @Int128 BigInteger amount;

        public PeerToPeerV2(TypeTag token_type, AccountAddress payee, @Unsigned @Int128 BigInteger amount) {
            Objects.requireNonNull(token_type, "token_type must not be null");
            Objects.requireNonNull(payee, "payee must not be null");
            Objects.requireNonNull(amount, "amount must not be null");
            this.token_type = token_type;
            this.payee = payee;
            this.amount = amount;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PeerToPeerV2 other = (PeerToPeerV2)obj;
            if (!Objects.equals(this.token_type, other.token_type)) {
                return false;
            }
            if (!Objects.equals(this.payee, other.payee)) {
                return false;
            }
            return Objects.equals(this.amount, other.amount);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token_type != null ? this.token_type.hashCode() : 0);
            value = 31 * value + (this.payee != null ? this.payee.hashCode() : 0);
            value = 31 * value + (this.amount != null ? this.amount.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token_type;
            public AccountAddress payee;
            public @Unsigned @Int128 BigInteger amount;

            public PeerToPeerV2 build() {
                return new PeerToPeerV2(this.token_type, this.payee, this.amount);
            }
        }
    }

    public static final class PeerToPeerBatch
    extends ScriptFunctionCall {
        public final TypeTag token_type;
        public final Bytes _payeees;
        public final Bytes _payee_auth_keys;
        public final @Unsigned @Int128 BigInteger _amount;

        public PeerToPeerBatch(TypeTag token_type, Bytes _payeees, Bytes _payee_auth_keys, @Unsigned @Int128 BigInteger _amount) {
            Objects.requireNonNull(token_type, "token_type must not be null");
            Objects.requireNonNull(_payeees, "_payeees must not be null");
            Objects.requireNonNull(_payee_auth_keys, "_payee_auth_keys must not be null");
            Objects.requireNonNull(_amount, "_amount must not be null");
            this.token_type = token_type;
            this._payeees = _payeees;
            this._payee_auth_keys = _payee_auth_keys;
            this._amount = _amount;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PeerToPeerBatch other = (PeerToPeerBatch)obj;
            if (!Objects.equals(this.token_type, other.token_type)) {
                return false;
            }
            if (!Objects.equals(this._payeees, other._payeees)) {
                return false;
            }
            if (!Objects.equals(this._payee_auth_keys, other._payee_auth_keys)) {
                return false;
            }
            return Objects.equals(this._amount, other._amount);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token_type != null ? this.token_type.hashCode() : 0);
            value = 31 * value + (this._payeees != null ? this._payeees.hashCode() : 0);
            value = 31 * value + (this._payee_auth_keys != null ? this._payee_auth_keys.hashCode() : 0);
            value = 31 * value + (this._amount != null ? this._amount.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token_type;
            public Bytes _payeees;
            public Bytes _payee_auth_keys;
            public @Unsigned @Int128 BigInteger _amount;

            public PeerToPeerBatch build() {
                return new PeerToPeerBatch(this.token_type, this._payeees, this._payee_auth_keys, this._amount);
            }
        }
    }

    public static final class PeerToPeer
    extends ScriptFunctionCall {
        public final TypeTag token_type;
        public final AccountAddress payee;
        public final Bytes _payee_auth_key;
        public final @Unsigned @Int128 BigInteger amount;

        public PeerToPeer(TypeTag token_type, AccountAddress payee, Bytes _payee_auth_key, @Unsigned @Int128 BigInteger amount) {
            Objects.requireNonNull(token_type, "token_type must not be null");
            Objects.requireNonNull(payee, "payee must not be null");
            Objects.requireNonNull(_payee_auth_key, "_payee_auth_key must not be null");
            Objects.requireNonNull(amount, "amount must not be null");
            this.token_type = token_type;
            this.payee = payee;
            this._payee_auth_key = _payee_auth_key;
            this.amount = amount;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PeerToPeer other = (PeerToPeer)obj;
            if (!Objects.equals(this.token_type, other.token_type)) {
                return false;
            }
            if (!Objects.equals(this.payee, other.payee)) {
                return false;
            }
            if (!Objects.equals(this._payee_auth_key, other._payee_auth_key)) {
                return false;
            }
            return Objects.equals(this.amount, other.amount);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token_type != null ? this.token_type.hashCode() : 0);
            value = 31 * value + (this.payee != null ? this.payee.hashCode() : 0);
            value = 31 * value + (this._payee_auth_key != null ? this._payee_auth_key.hashCode() : 0);
            value = 31 * value + (this.amount != null ? this.amount.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token_type;
            public AccountAddress payee;
            public Bytes _payee_auth_key;
            public @Unsigned @Int128 BigInteger amount;

            public PeerToPeer build() {
                return new PeerToPeer(this.token_type, this.payee, this._payee_auth_key, this.amount);
            }
        }
    }

    public static final class InitializeV2
    extends ScriptFunctionCall {
        public final @Unsigned Long stdlib_version;
        public final @Unsigned Long reward_delay;
        public final @Unsigned @Int128 BigInteger total_stc_amount;
        public final @Unsigned @Int128 BigInteger pre_mine_stc_amount;
        public final @Unsigned @Int128 BigInteger time_mint_stc_amount;
        public final @Unsigned Long time_mint_stc_period;
        public final Bytes parent_hash;
        public final Bytes association_auth_key;
        public final Bytes genesis_auth_key;
        public final @Unsigned Byte chain_id;
        public final @Unsigned Long genesis_timestamp;
        public final @Unsigned Long uncle_rate_target;
        public final @Unsigned Long epoch_block_count;
        public final @Unsigned Long base_block_time_target;
        public final @Unsigned Long base_block_difficulty_window;
        public final @Unsigned @Int128 BigInteger base_reward_per_block;
        public final @Unsigned Long base_reward_per_uncle_percent;
        public final @Unsigned Long min_block_time_target;
        public final @Unsigned Long max_block_time_target;
        public final @Unsigned Long base_max_uncles_per_block;
        public final @Unsigned Long base_block_gas_limit;
        public final @Unsigned Byte strategy;
        public final Boolean script_allowed;
        public final Boolean module_publishing_allowed;
        public final Bytes instruction_schedule;
        public final Bytes native_schedule;
        public final @Unsigned Long global_memory_per_byte_cost;
        public final @Unsigned Long global_memory_per_byte_write_cost;
        public final @Unsigned Long min_transaction_gas_units;
        public final @Unsigned Long large_transaction_cutoff;
        public final @Unsigned Long instrinsic_gas_per_byte;
        public final @Unsigned Long maximum_number_of_gas_units;
        public final @Unsigned Long min_price_per_gas_unit;
        public final @Unsigned Long max_price_per_gas_unit;
        public final @Unsigned Long max_transaction_size_in_bytes;
        public final @Unsigned Long gas_unit_scaling_factor;
        public final @Unsigned Long default_account_size;
        public final @Unsigned Long voting_delay;
        public final @Unsigned Long voting_period;
        public final @Unsigned Byte voting_quorum_rate;
        public final @Unsigned Long min_action_delay;
        public final @Unsigned Long transaction_timeout;

        public InitializeV2(@Unsigned Long stdlib_version, @Unsigned Long reward_delay, @Unsigned @Int128 BigInteger total_stc_amount, @Unsigned @Int128 BigInteger pre_mine_stc_amount, @Unsigned @Int128 BigInteger time_mint_stc_amount, @Unsigned Long time_mint_stc_period, Bytes parent_hash, Bytes association_auth_key, Bytes genesis_auth_key, @Unsigned Byte chain_id, @Unsigned Long genesis_timestamp, @Unsigned Long uncle_rate_target, @Unsigned Long epoch_block_count, @Unsigned Long base_block_time_target, @Unsigned Long base_block_difficulty_window, @Unsigned @Int128 BigInteger base_reward_per_block, @Unsigned Long base_reward_per_uncle_percent, @Unsigned Long min_block_time_target, @Unsigned Long max_block_time_target, @Unsigned Long base_max_uncles_per_block, @Unsigned Long base_block_gas_limit, @Unsigned Byte strategy, Boolean script_allowed, Boolean module_publishing_allowed, Bytes instruction_schedule, Bytes native_schedule, @Unsigned Long global_memory_per_byte_cost, @Unsigned Long global_memory_per_byte_write_cost, @Unsigned Long min_transaction_gas_units, @Unsigned Long large_transaction_cutoff, @Unsigned Long instrinsic_gas_per_byte, @Unsigned Long maximum_number_of_gas_units, @Unsigned Long min_price_per_gas_unit, @Unsigned Long max_price_per_gas_unit, @Unsigned Long max_transaction_size_in_bytes, @Unsigned Long gas_unit_scaling_factor, @Unsigned Long default_account_size, @Unsigned Long voting_delay, @Unsigned Long voting_period, @Unsigned Byte voting_quorum_rate, @Unsigned Long min_action_delay, @Unsigned Long transaction_timeout) {
            Objects.requireNonNull(stdlib_version, "stdlib_version must not be null");
            Objects.requireNonNull(reward_delay, "reward_delay must not be null");
            Objects.requireNonNull(total_stc_amount, "total_stc_amount must not be null");
            Objects.requireNonNull(pre_mine_stc_amount, "pre_mine_stc_amount must not be null");
            Objects.requireNonNull(time_mint_stc_amount, "time_mint_stc_amount must not be null");
            Objects.requireNonNull(time_mint_stc_period, "time_mint_stc_period must not be null");
            Objects.requireNonNull(parent_hash, "parent_hash must not be null");
            Objects.requireNonNull(association_auth_key, "association_auth_key must not be null");
            Objects.requireNonNull(genesis_auth_key, "genesis_auth_key must not be null");
            Objects.requireNonNull(chain_id, "chain_id must not be null");
            Objects.requireNonNull(genesis_timestamp, "genesis_timestamp must not be null");
            Objects.requireNonNull(uncle_rate_target, "uncle_rate_target must not be null");
            Objects.requireNonNull(epoch_block_count, "epoch_block_count must not be null");
            Objects.requireNonNull(base_block_time_target, "base_block_time_target must not be null");
            Objects.requireNonNull(base_block_difficulty_window, "base_block_difficulty_window must not be null");
            Objects.requireNonNull(base_reward_per_block, "base_reward_per_block must not be null");
            Objects.requireNonNull(base_reward_per_uncle_percent, "base_reward_per_uncle_percent must not be null");
            Objects.requireNonNull(min_block_time_target, "min_block_time_target must not be null");
            Objects.requireNonNull(max_block_time_target, "max_block_time_target must not be null");
            Objects.requireNonNull(base_max_uncles_per_block, "base_max_uncles_per_block must not be null");
            Objects.requireNonNull(base_block_gas_limit, "base_block_gas_limit must not be null");
            Objects.requireNonNull(strategy, "strategy must not be null");
            Objects.requireNonNull(script_allowed, "script_allowed must not be null");
            Objects.requireNonNull(module_publishing_allowed, "module_publishing_allowed must not be null");
            Objects.requireNonNull(instruction_schedule, "instruction_schedule must not be null");
            Objects.requireNonNull(native_schedule, "native_schedule must not be null");
            Objects.requireNonNull(global_memory_per_byte_cost, "global_memory_per_byte_cost must not be null");
            Objects.requireNonNull(global_memory_per_byte_write_cost, "global_memory_per_byte_write_cost must not be null");
            Objects.requireNonNull(min_transaction_gas_units, "min_transaction_gas_units must not be null");
            Objects.requireNonNull(large_transaction_cutoff, "large_transaction_cutoff must not be null");
            Objects.requireNonNull(instrinsic_gas_per_byte, "instrinsic_gas_per_byte must not be null");
            Objects.requireNonNull(maximum_number_of_gas_units, "maximum_number_of_gas_units must not be null");
            Objects.requireNonNull(min_price_per_gas_unit, "min_price_per_gas_unit must not be null");
            Objects.requireNonNull(max_price_per_gas_unit, "max_price_per_gas_unit must not be null");
            Objects.requireNonNull(max_transaction_size_in_bytes, "max_transaction_size_in_bytes must not be null");
            Objects.requireNonNull(gas_unit_scaling_factor, "gas_unit_scaling_factor must not be null");
            Objects.requireNonNull(default_account_size, "default_account_size must not be null");
            Objects.requireNonNull(voting_delay, "voting_delay must not be null");
            Objects.requireNonNull(voting_period, "voting_period must not be null");
            Objects.requireNonNull(voting_quorum_rate, "voting_quorum_rate must not be null");
            Objects.requireNonNull(min_action_delay, "min_action_delay must not be null");
            Objects.requireNonNull(transaction_timeout, "transaction_timeout must not be null");
            this.stdlib_version = stdlib_version;
            this.reward_delay = reward_delay;
            this.total_stc_amount = total_stc_amount;
            this.pre_mine_stc_amount = pre_mine_stc_amount;
            this.time_mint_stc_amount = time_mint_stc_amount;
            this.time_mint_stc_period = time_mint_stc_period;
            this.parent_hash = parent_hash;
            this.association_auth_key = association_auth_key;
            this.genesis_auth_key = genesis_auth_key;
            this.chain_id = chain_id;
            this.genesis_timestamp = genesis_timestamp;
            this.uncle_rate_target = uncle_rate_target;
            this.epoch_block_count = epoch_block_count;
            this.base_block_time_target = base_block_time_target;
            this.base_block_difficulty_window = base_block_difficulty_window;
            this.base_reward_per_block = base_reward_per_block;
            this.base_reward_per_uncle_percent = base_reward_per_uncle_percent;
            this.min_block_time_target = min_block_time_target;
            this.max_block_time_target = max_block_time_target;
            this.base_max_uncles_per_block = base_max_uncles_per_block;
            this.base_block_gas_limit = base_block_gas_limit;
            this.strategy = strategy;
            this.script_allowed = script_allowed;
            this.module_publishing_allowed = module_publishing_allowed;
            this.instruction_schedule = instruction_schedule;
            this.native_schedule = native_schedule;
            this.global_memory_per_byte_cost = global_memory_per_byte_cost;
            this.global_memory_per_byte_write_cost = global_memory_per_byte_write_cost;
            this.min_transaction_gas_units = min_transaction_gas_units;
            this.large_transaction_cutoff = large_transaction_cutoff;
            this.instrinsic_gas_per_byte = instrinsic_gas_per_byte;
            this.maximum_number_of_gas_units = maximum_number_of_gas_units;
            this.min_price_per_gas_unit = min_price_per_gas_unit;
            this.max_price_per_gas_unit = max_price_per_gas_unit;
            this.max_transaction_size_in_bytes = max_transaction_size_in_bytes;
            this.gas_unit_scaling_factor = gas_unit_scaling_factor;
            this.default_account_size = default_account_size;
            this.voting_delay = voting_delay;
            this.voting_period = voting_period;
            this.voting_quorum_rate = voting_quorum_rate;
            this.min_action_delay = min_action_delay;
            this.transaction_timeout = transaction_timeout;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InitializeV2 other = (InitializeV2)obj;
            if (!Objects.equals(this.stdlib_version, other.stdlib_version)) {
                return false;
            }
            if (!Objects.equals(this.reward_delay, other.reward_delay)) {
                return false;
            }
            if (!Objects.equals(this.total_stc_amount, other.total_stc_amount)) {
                return false;
            }
            if (!Objects.equals(this.pre_mine_stc_amount, other.pre_mine_stc_amount)) {
                return false;
            }
            if (!Objects.equals(this.time_mint_stc_amount, other.time_mint_stc_amount)) {
                return false;
            }
            if (!Objects.equals(this.time_mint_stc_period, other.time_mint_stc_period)) {
                return false;
            }
            if (!Objects.equals(this.parent_hash, other.parent_hash)) {
                return false;
            }
            if (!Objects.equals(this.association_auth_key, other.association_auth_key)) {
                return false;
            }
            if (!Objects.equals(this.genesis_auth_key, other.genesis_auth_key)) {
                return false;
            }
            if (!Objects.equals(this.chain_id, other.chain_id)) {
                return false;
            }
            if (!Objects.equals(this.genesis_timestamp, other.genesis_timestamp)) {
                return false;
            }
            if (!Objects.equals(this.uncle_rate_target, other.uncle_rate_target)) {
                return false;
            }
            if (!Objects.equals(this.epoch_block_count, other.epoch_block_count)) {
                return false;
            }
            if (!Objects.equals(this.base_block_time_target, other.base_block_time_target)) {
                return false;
            }
            if (!Objects.equals(this.base_block_difficulty_window, other.base_block_difficulty_window)) {
                return false;
            }
            if (!Objects.equals(this.base_reward_per_block, other.base_reward_per_block)) {
                return false;
            }
            if (!Objects.equals(this.base_reward_per_uncle_percent, other.base_reward_per_uncle_percent)) {
                return false;
            }
            if (!Objects.equals(this.min_block_time_target, other.min_block_time_target)) {
                return false;
            }
            if (!Objects.equals(this.max_block_time_target, other.max_block_time_target)) {
                return false;
            }
            if (!Objects.equals(this.base_max_uncles_per_block, other.base_max_uncles_per_block)) {
                return false;
            }
            if (!Objects.equals(this.base_block_gas_limit, other.base_block_gas_limit)) {
                return false;
            }
            if (!Objects.equals(this.strategy, other.strategy)) {
                return false;
            }
            if (!Objects.equals(this.script_allowed, other.script_allowed)) {
                return false;
            }
            if (!Objects.equals(this.module_publishing_allowed, other.module_publishing_allowed)) {
                return false;
            }
            if (!Objects.equals(this.instruction_schedule, other.instruction_schedule)) {
                return false;
            }
            if (!Objects.equals(this.native_schedule, other.native_schedule)) {
                return false;
            }
            if (!Objects.equals(this.global_memory_per_byte_cost, other.global_memory_per_byte_cost)) {
                return false;
            }
            if (!Objects.equals(this.global_memory_per_byte_write_cost, other.global_memory_per_byte_write_cost)) {
                return false;
            }
            if (!Objects.equals(this.min_transaction_gas_units, other.min_transaction_gas_units)) {
                return false;
            }
            if (!Objects.equals(this.large_transaction_cutoff, other.large_transaction_cutoff)) {
                return false;
            }
            if (!Objects.equals(this.instrinsic_gas_per_byte, other.instrinsic_gas_per_byte)) {
                return false;
            }
            if (!Objects.equals(this.maximum_number_of_gas_units, other.maximum_number_of_gas_units)) {
                return false;
            }
            if (!Objects.equals(this.min_price_per_gas_unit, other.min_price_per_gas_unit)) {
                return false;
            }
            if (!Objects.equals(this.max_price_per_gas_unit, other.max_price_per_gas_unit)) {
                return false;
            }
            if (!Objects.equals(this.max_transaction_size_in_bytes, other.max_transaction_size_in_bytes)) {
                return false;
            }
            if (!Objects.equals(this.gas_unit_scaling_factor, other.gas_unit_scaling_factor)) {
                return false;
            }
            if (!Objects.equals(this.default_account_size, other.default_account_size)) {
                return false;
            }
            if (!Objects.equals(this.voting_delay, other.voting_delay)) {
                return false;
            }
            if (!Objects.equals(this.voting_period, other.voting_period)) {
                return false;
            }
            if (!Objects.equals(this.voting_quorum_rate, other.voting_quorum_rate)) {
                return false;
            }
            if (!Objects.equals(this.min_action_delay, other.min_action_delay)) {
                return false;
            }
            return Objects.equals(this.transaction_timeout, other.transaction_timeout);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.stdlib_version != null ? this.stdlib_version.hashCode() : 0);
            value = 31 * value + (this.reward_delay != null ? this.reward_delay.hashCode() : 0);
            value = 31 * value + (this.total_stc_amount != null ? this.total_stc_amount.hashCode() : 0);
            value = 31 * value + (this.pre_mine_stc_amount != null ? this.pre_mine_stc_amount.hashCode() : 0);
            value = 31 * value + (this.time_mint_stc_amount != null ? this.time_mint_stc_amount.hashCode() : 0);
            value = 31 * value + (this.time_mint_stc_period != null ? this.time_mint_stc_period.hashCode() : 0);
            value = 31 * value + (this.parent_hash != null ? this.parent_hash.hashCode() : 0);
            value = 31 * value + (this.association_auth_key != null ? this.association_auth_key.hashCode() : 0);
            value = 31 * value + (this.genesis_auth_key != null ? this.genesis_auth_key.hashCode() : 0);
            value = 31 * value + (this.chain_id != null ? this.chain_id.hashCode() : 0);
            value = 31 * value + (this.genesis_timestamp != null ? this.genesis_timestamp.hashCode() : 0);
            value = 31 * value + (this.uncle_rate_target != null ? this.uncle_rate_target.hashCode() : 0);
            value = 31 * value + (this.epoch_block_count != null ? this.epoch_block_count.hashCode() : 0);
            value = 31 * value + (this.base_block_time_target != null ? this.base_block_time_target.hashCode() : 0);
            value = 31 * value + (this.base_block_difficulty_window != null ? this.base_block_difficulty_window.hashCode() : 0);
            value = 31 * value + (this.base_reward_per_block != null ? this.base_reward_per_block.hashCode() : 0);
            value = 31 * value + (this.base_reward_per_uncle_percent != null ? this.base_reward_per_uncle_percent.hashCode() : 0);
            value = 31 * value + (this.min_block_time_target != null ? this.min_block_time_target.hashCode() : 0);
            value = 31 * value + (this.max_block_time_target != null ? this.max_block_time_target.hashCode() : 0);
            value = 31 * value + (this.base_max_uncles_per_block != null ? this.base_max_uncles_per_block.hashCode() : 0);
            value = 31 * value + (this.base_block_gas_limit != null ? this.base_block_gas_limit.hashCode() : 0);
            value = 31 * value + (this.strategy != null ? this.strategy.hashCode() : 0);
            value = 31 * value + (this.script_allowed != null ? this.script_allowed.hashCode() : 0);
            value = 31 * value + (this.module_publishing_allowed != null ? this.module_publishing_allowed.hashCode() : 0);
            value = 31 * value + (this.instruction_schedule != null ? this.instruction_schedule.hashCode() : 0);
            value = 31 * value + (this.native_schedule != null ? this.native_schedule.hashCode() : 0);
            value = 31 * value + (this.global_memory_per_byte_cost != null ? this.global_memory_per_byte_cost.hashCode() : 0);
            value = 31 * value + (this.global_memory_per_byte_write_cost != null ? this.global_memory_per_byte_write_cost.hashCode() : 0);
            value = 31 * value + (this.min_transaction_gas_units != null ? this.min_transaction_gas_units.hashCode() : 0);
            value = 31 * value + (this.large_transaction_cutoff != null ? this.large_transaction_cutoff.hashCode() : 0);
            value = 31 * value + (this.instrinsic_gas_per_byte != null ? this.instrinsic_gas_per_byte.hashCode() : 0);
            value = 31 * value + (this.maximum_number_of_gas_units != null ? this.maximum_number_of_gas_units.hashCode() : 0);
            value = 31 * value + (this.min_price_per_gas_unit != null ? this.min_price_per_gas_unit.hashCode() : 0);
            value = 31 * value + (this.max_price_per_gas_unit != null ? this.max_price_per_gas_unit.hashCode() : 0);
            value = 31 * value + (this.max_transaction_size_in_bytes != null ? this.max_transaction_size_in_bytes.hashCode() : 0);
            value = 31 * value + (this.gas_unit_scaling_factor != null ? this.gas_unit_scaling_factor.hashCode() : 0);
            value = 31 * value + (this.default_account_size != null ? this.default_account_size.hashCode() : 0);
            value = 31 * value + (this.voting_delay != null ? this.voting_delay.hashCode() : 0);
            value = 31 * value + (this.voting_period != null ? this.voting_period.hashCode() : 0);
            value = 31 * value + (this.voting_quorum_rate != null ? this.voting_quorum_rate.hashCode() : 0);
            value = 31 * value + (this.min_action_delay != null ? this.min_action_delay.hashCode() : 0);
            value = 31 * value + (this.transaction_timeout != null ? this.transaction_timeout.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Long stdlib_version;
            public @Unsigned Long reward_delay;
            public @Unsigned @Int128 BigInteger total_stc_amount;
            public @Unsigned @Int128 BigInteger pre_mine_stc_amount;
            public @Unsigned @Int128 BigInteger time_mint_stc_amount;
            public @Unsigned Long time_mint_stc_period;
            public Bytes parent_hash;
            public Bytes association_auth_key;
            public Bytes genesis_auth_key;
            public @Unsigned Byte chain_id;
            public @Unsigned Long genesis_timestamp;
            public @Unsigned Long uncle_rate_target;
            public @Unsigned Long epoch_block_count;
            public @Unsigned Long base_block_time_target;
            public @Unsigned Long base_block_difficulty_window;
            public @Unsigned @Int128 BigInteger base_reward_per_block;
            public @Unsigned Long base_reward_per_uncle_percent;
            public @Unsigned Long min_block_time_target;
            public @Unsigned Long max_block_time_target;
            public @Unsigned Long base_max_uncles_per_block;
            public @Unsigned Long base_block_gas_limit;
            public @Unsigned Byte strategy;
            public Boolean script_allowed;
            public Boolean module_publishing_allowed;
            public Bytes instruction_schedule;
            public Bytes native_schedule;
            public @Unsigned Long global_memory_per_byte_cost;
            public @Unsigned Long global_memory_per_byte_write_cost;
            public @Unsigned Long min_transaction_gas_units;
            public @Unsigned Long large_transaction_cutoff;
            public @Unsigned Long instrinsic_gas_per_byte;
            public @Unsigned Long maximum_number_of_gas_units;
            public @Unsigned Long min_price_per_gas_unit;
            public @Unsigned Long max_price_per_gas_unit;
            public @Unsigned Long max_transaction_size_in_bytes;
            public @Unsigned Long gas_unit_scaling_factor;
            public @Unsigned Long default_account_size;
            public @Unsigned Long voting_delay;
            public @Unsigned Long voting_period;
            public @Unsigned Byte voting_quorum_rate;
            public @Unsigned Long min_action_delay;
            public @Unsigned Long transaction_timeout;

            public InitializeV2 build() {
                return new InitializeV2(this.stdlib_version, this.reward_delay, this.total_stc_amount, this.pre_mine_stc_amount, this.time_mint_stc_amount, this.time_mint_stc_period, this.parent_hash, this.association_auth_key, this.genesis_auth_key, this.chain_id, this.genesis_timestamp, this.uncle_rate_target, this.epoch_block_count, this.base_block_time_target, this.base_block_difficulty_window, this.base_reward_per_block, this.base_reward_per_uncle_percent, this.min_block_time_target, this.max_block_time_target, this.base_max_uncles_per_block, this.base_block_gas_limit, this.strategy, this.script_allowed, this.module_publishing_allowed, this.instruction_schedule, this.native_schedule, this.global_memory_per_byte_cost, this.global_memory_per_byte_write_cost, this.min_transaction_gas_units, this.large_transaction_cutoff, this.instrinsic_gas_per_byte, this.maximum_number_of_gas_units, this.min_price_per_gas_unit, this.max_price_per_gas_unit, this.max_transaction_size_in_bytes, this.gas_unit_scaling_factor, this.default_account_size, this.voting_delay, this.voting_period, this.voting_quorum_rate, this.min_action_delay, this.transaction_timeout);
            }
        }
    }

    public static final class Initialize
    extends ScriptFunctionCall {
        public final @Unsigned Long stdlib_version;
        public final @Unsigned Long reward_delay;
        public final @Unsigned @Int128 BigInteger pre_mine_stc_amount;
        public final @Unsigned @Int128 BigInteger time_mint_stc_amount;
        public final @Unsigned Long time_mint_stc_period;
        public final Bytes parent_hash;
        public final Bytes association_auth_key;
        public final Bytes genesis_auth_key;
        public final @Unsigned Byte chain_id;
        public final @Unsigned Long genesis_timestamp;
        public final @Unsigned Long uncle_rate_target;
        public final @Unsigned Long epoch_block_count;
        public final @Unsigned Long base_block_time_target;
        public final @Unsigned Long base_block_difficulty_window;
        public final @Unsigned @Int128 BigInteger base_reward_per_block;
        public final @Unsigned Long base_reward_per_uncle_percent;
        public final @Unsigned Long min_block_time_target;
        public final @Unsigned Long max_block_time_target;
        public final @Unsigned Long base_max_uncles_per_block;
        public final @Unsigned Long base_block_gas_limit;
        public final @Unsigned Byte strategy;
        public final Boolean script_allowed;
        public final Boolean module_publishing_allowed;
        public final Bytes instruction_schedule;
        public final Bytes native_schedule;
        public final @Unsigned Long global_memory_per_byte_cost;
        public final @Unsigned Long global_memory_per_byte_write_cost;
        public final @Unsigned Long min_transaction_gas_units;
        public final @Unsigned Long large_transaction_cutoff;
        public final @Unsigned Long instrinsic_gas_per_byte;
        public final @Unsigned Long maximum_number_of_gas_units;
        public final @Unsigned Long min_price_per_gas_unit;
        public final @Unsigned Long max_price_per_gas_unit;
        public final @Unsigned Long max_transaction_size_in_bytes;
        public final @Unsigned Long gas_unit_scaling_factor;
        public final @Unsigned Long default_account_size;
        public final @Unsigned Long voting_delay;
        public final @Unsigned Long voting_period;
        public final @Unsigned Byte voting_quorum_rate;
        public final @Unsigned Long min_action_delay;
        public final @Unsigned Long transaction_timeout;

        public Initialize(@Unsigned Long stdlib_version, @Unsigned Long reward_delay, @Unsigned @Int128 BigInteger pre_mine_stc_amount, @Unsigned @Int128 BigInteger time_mint_stc_amount, @Unsigned Long time_mint_stc_period, Bytes parent_hash, Bytes association_auth_key, Bytes genesis_auth_key, @Unsigned Byte chain_id, @Unsigned Long genesis_timestamp, @Unsigned Long uncle_rate_target, @Unsigned Long epoch_block_count, @Unsigned Long base_block_time_target, @Unsigned Long base_block_difficulty_window, @Unsigned @Int128 BigInteger base_reward_per_block, @Unsigned Long base_reward_per_uncle_percent, @Unsigned Long min_block_time_target, @Unsigned Long max_block_time_target, @Unsigned Long base_max_uncles_per_block, @Unsigned Long base_block_gas_limit, @Unsigned Byte strategy, Boolean script_allowed, Boolean module_publishing_allowed, Bytes instruction_schedule, Bytes native_schedule, @Unsigned Long global_memory_per_byte_cost, @Unsigned Long global_memory_per_byte_write_cost, @Unsigned Long min_transaction_gas_units, @Unsigned Long large_transaction_cutoff, @Unsigned Long instrinsic_gas_per_byte, @Unsigned Long maximum_number_of_gas_units, @Unsigned Long min_price_per_gas_unit, @Unsigned Long max_price_per_gas_unit, @Unsigned Long max_transaction_size_in_bytes, @Unsigned Long gas_unit_scaling_factor, @Unsigned Long default_account_size, @Unsigned Long voting_delay, @Unsigned Long voting_period, @Unsigned Byte voting_quorum_rate, @Unsigned Long min_action_delay, @Unsigned Long transaction_timeout) {
            Objects.requireNonNull(stdlib_version, "stdlib_version must not be null");
            Objects.requireNonNull(reward_delay, "reward_delay must not be null");
            Objects.requireNonNull(pre_mine_stc_amount, "pre_mine_stc_amount must not be null");
            Objects.requireNonNull(time_mint_stc_amount, "time_mint_stc_amount must not be null");
            Objects.requireNonNull(time_mint_stc_period, "time_mint_stc_period must not be null");
            Objects.requireNonNull(parent_hash, "parent_hash must not be null");
            Objects.requireNonNull(association_auth_key, "association_auth_key must not be null");
            Objects.requireNonNull(genesis_auth_key, "genesis_auth_key must not be null");
            Objects.requireNonNull(chain_id, "chain_id must not be null");
            Objects.requireNonNull(genesis_timestamp, "genesis_timestamp must not be null");
            Objects.requireNonNull(uncle_rate_target, "uncle_rate_target must not be null");
            Objects.requireNonNull(epoch_block_count, "epoch_block_count must not be null");
            Objects.requireNonNull(base_block_time_target, "base_block_time_target must not be null");
            Objects.requireNonNull(base_block_difficulty_window, "base_block_difficulty_window must not be null");
            Objects.requireNonNull(base_reward_per_block, "base_reward_per_block must not be null");
            Objects.requireNonNull(base_reward_per_uncle_percent, "base_reward_per_uncle_percent must not be null");
            Objects.requireNonNull(min_block_time_target, "min_block_time_target must not be null");
            Objects.requireNonNull(max_block_time_target, "max_block_time_target must not be null");
            Objects.requireNonNull(base_max_uncles_per_block, "base_max_uncles_per_block must not be null");
            Objects.requireNonNull(base_block_gas_limit, "base_block_gas_limit must not be null");
            Objects.requireNonNull(strategy, "strategy must not be null");
            Objects.requireNonNull(script_allowed, "script_allowed must not be null");
            Objects.requireNonNull(module_publishing_allowed, "module_publishing_allowed must not be null");
            Objects.requireNonNull(instruction_schedule, "instruction_schedule must not be null");
            Objects.requireNonNull(native_schedule, "native_schedule must not be null");
            Objects.requireNonNull(global_memory_per_byte_cost, "global_memory_per_byte_cost must not be null");
            Objects.requireNonNull(global_memory_per_byte_write_cost, "global_memory_per_byte_write_cost must not be null");
            Objects.requireNonNull(min_transaction_gas_units, "min_transaction_gas_units must not be null");
            Objects.requireNonNull(large_transaction_cutoff, "large_transaction_cutoff must not be null");
            Objects.requireNonNull(instrinsic_gas_per_byte, "instrinsic_gas_per_byte must not be null");
            Objects.requireNonNull(maximum_number_of_gas_units, "maximum_number_of_gas_units must not be null");
            Objects.requireNonNull(min_price_per_gas_unit, "min_price_per_gas_unit must not be null");
            Objects.requireNonNull(max_price_per_gas_unit, "max_price_per_gas_unit must not be null");
            Objects.requireNonNull(max_transaction_size_in_bytes, "max_transaction_size_in_bytes must not be null");
            Objects.requireNonNull(gas_unit_scaling_factor, "gas_unit_scaling_factor must not be null");
            Objects.requireNonNull(default_account_size, "default_account_size must not be null");
            Objects.requireNonNull(voting_delay, "voting_delay must not be null");
            Objects.requireNonNull(voting_period, "voting_period must not be null");
            Objects.requireNonNull(voting_quorum_rate, "voting_quorum_rate must not be null");
            Objects.requireNonNull(min_action_delay, "min_action_delay must not be null");
            Objects.requireNonNull(transaction_timeout, "transaction_timeout must not be null");
            this.stdlib_version = stdlib_version;
            this.reward_delay = reward_delay;
            this.pre_mine_stc_amount = pre_mine_stc_amount;
            this.time_mint_stc_amount = time_mint_stc_amount;
            this.time_mint_stc_period = time_mint_stc_period;
            this.parent_hash = parent_hash;
            this.association_auth_key = association_auth_key;
            this.genesis_auth_key = genesis_auth_key;
            this.chain_id = chain_id;
            this.genesis_timestamp = genesis_timestamp;
            this.uncle_rate_target = uncle_rate_target;
            this.epoch_block_count = epoch_block_count;
            this.base_block_time_target = base_block_time_target;
            this.base_block_difficulty_window = base_block_difficulty_window;
            this.base_reward_per_block = base_reward_per_block;
            this.base_reward_per_uncle_percent = base_reward_per_uncle_percent;
            this.min_block_time_target = min_block_time_target;
            this.max_block_time_target = max_block_time_target;
            this.base_max_uncles_per_block = base_max_uncles_per_block;
            this.base_block_gas_limit = base_block_gas_limit;
            this.strategy = strategy;
            this.script_allowed = script_allowed;
            this.module_publishing_allowed = module_publishing_allowed;
            this.instruction_schedule = instruction_schedule;
            this.native_schedule = native_schedule;
            this.global_memory_per_byte_cost = global_memory_per_byte_cost;
            this.global_memory_per_byte_write_cost = global_memory_per_byte_write_cost;
            this.min_transaction_gas_units = min_transaction_gas_units;
            this.large_transaction_cutoff = large_transaction_cutoff;
            this.instrinsic_gas_per_byte = instrinsic_gas_per_byte;
            this.maximum_number_of_gas_units = maximum_number_of_gas_units;
            this.min_price_per_gas_unit = min_price_per_gas_unit;
            this.max_price_per_gas_unit = max_price_per_gas_unit;
            this.max_transaction_size_in_bytes = max_transaction_size_in_bytes;
            this.gas_unit_scaling_factor = gas_unit_scaling_factor;
            this.default_account_size = default_account_size;
            this.voting_delay = voting_delay;
            this.voting_period = voting_period;
            this.voting_quorum_rate = voting_quorum_rate;
            this.min_action_delay = min_action_delay;
            this.transaction_timeout = transaction_timeout;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Initialize other = (Initialize)obj;
            if (!Objects.equals(this.stdlib_version, other.stdlib_version)) {
                return false;
            }
            if (!Objects.equals(this.reward_delay, other.reward_delay)) {
                return false;
            }
            if (!Objects.equals(this.pre_mine_stc_amount, other.pre_mine_stc_amount)) {
                return false;
            }
            if (!Objects.equals(this.time_mint_stc_amount, other.time_mint_stc_amount)) {
                return false;
            }
            if (!Objects.equals(this.time_mint_stc_period, other.time_mint_stc_period)) {
                return false;
            }
            if (!Objects.equals(this.parent_hash, other.parent_hash)) {
                return false;
            }
            if (!Objects.equals(this.association_auth_key, other.association_auth_key)) {
                return false;
            }
            if (!Objects.equals(this.genesis_auth_key, other.genesis_auth_key)) {
                return false;
            }
            if (!Objects.equals(this.chain_id, other.chain_id)) {
                return false;
            }
            if (!Objects.equals(this.genesis_timestamp, other.genesis_timestamp)) {
                return false;
            }
            if (!Objects.equals(this.uncle_rate_target, other.uncle_rate_target)) {
                return false;
            }
            if (!Objects.equals(this.epoch_block_count, other.epoch_block_count)) {
                return false;
            }
            if (!Objects.equals(this.base_block_time_target, other.base_block_time_target)) {
                return false;
            }
            if (!Objects.equals(this.base_block_difficulty_window, other.base_block_difficulty_window)) {
                return false;
            }
            if (!Objects.equals(this.base_reward_per_block, other.base_reward_per_block)) {
                return false;
            }
            if (!Objects.equals(this.base_reward_per_uncle_percent, other.base_reward_per_uncle_percent)) {
                return false;
            }
            if (!Objects.equals(this.min_block_time_target, other.min_block_time_target)) {
                return false;
            }
            if (!Objects.equals(this.max_block_time_target, other.max_block_time_target)) {
                return false;
            }
            if (!Objects.equals(this.base_max_uncles_per_block, other.base_max_uncles_per_block)) {
                return false;
            }
            if (!Objects.equals(this.base_block_gas_limit, other.base_block_gas_limit)) {
                return false;
            }
            if (!Objects.equals(this.strategy, other.strategy)) {
                return false;
            }
            if (!Objects.equals(this.script_allowed, other.script_allowed)) {
                return false;
            }
            if (!Objects.equals(this.module_publishing_allowed, other.module_publishing_allowed)) {
                return false;
            }
            if (!Objects.equals(this.instruction_schedule, other.instruction_schedule)) {
                return false;
            }
            if (!Objects.equals(this.native_schedule, other.native_schedule)) {
                return false;
            }
            if (!Objects.equals(this.global_memory_per_byte_cost, other.global_memory_per_byte_cost)) {
                return false;
            }
            if (!Objects.equals(this.global_memory_per_byte_write_cost, other.global_memory_per_byte_write_cost)) {
                return false;
            }
            if (!Objects.equals(this.min_transaction_gas_units, other.min_transaction_gas_units)) {
                return false;
            }
            if (!Objects.equals(this.large_transaction_cutoff, other.large_transaction_cutoff)) {
                return false;
            }
            if (!Objects.equals(this.instrinsic_gas_per_byte, other.instrinsic_gas_per_byte)) {
                return false;
            }
            if (!Objects.equals(this.maximum_number_of_gas_units, other.maximum_number_of_gas_units)) {
                return false;
            }
            if (!Objects.equals(this.min_price_per_gas_unit, other.min_price_per_gas_unit)) {
                return false;
            }
            if (!Objects.equals(this.max_price_per_gas_unit, other.max_price_per_gas_unit)) {
                return false;
            }
            if (!Objects.equals(this.max_transaction_size_in_bytes, other.max_transaction_size_in_bytes)) {
                return false;
            }
            if (!Objects.equals(this.gas_unit_scaling_factor, other.gas_unit_scaling_factor)) {
                return false;
            }
            if (!Objects.equals(this.default_account_size, other.default_account_size)) {
                return false;
            }
            if (!Objects.equals(this.voting_delay, other.voting_delay)) {
                return false;
            }
            if (!Objects.equals(this.voting_period, other.voting_period)) {
                return false;
            }
            if (!Objects.equals(this.voting_quorum_rate, other.voting_quorum_rate)) {
                return false;
            }
            if (!Objects.equals(this.min_action_delay, other.min_action_delay)) {
                return false;
            }
            return Objects.equals(this.transaction_timeout, other.transaction_timeout);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.stdlib_version != null ? this.stdlib_version.hashCode() : 0);
            value = 31 * value + (this.reward_delay != null ? this.reward_delay.hashCode() : 0);
            value = 31 * value + (this.pre_mine_stc_amount != null ? this.pre_mine_stc_amount.hashCode() : 0);
            value = 31 * value + (this.time_mint_stc_amount != null ? this.time_mint_stc_amount.hashCode() : 0);
            value = 31 * value + (this.time_mint_stc_period != null ? this.time_mint_stc_period.hashCode() : 0);
            value = 31 * value + (this.parent_hash != null ? this.parent_hash.hashCode() : 0);
            value = 31 * value + (this.association_auth_key != null ? this.association_auth_key.hashCode() : 0);
            value = 31 * value + (this.genesis_auth_key != null ? this.genesis_auth_key.hashCode() : 0);
            value = 31 * value + (this.chain_id != null ? this.chain_id.hashCode() : 0);
            value = 31 * value + (this.genesis_timestamp != null ? this.genesis_timestamp.hashCode() : 0);
            value = 31 * value + (this.uncle_rate_target != null ? this.uncle_rate_target.hashCode() : 0);
            value = 31 * value + (this.epoch_block_count != null ? this.epoch_block_count.hashCode() : 0);
            value = 31 * value + (this.base_block_time_target != null ? this.base_block_time_target.hashCode() : 0);
            value = 31 * value + (this.base_block_difficulty_window != null ? this.base_block_difficulty_window.hashCode() : 0);
            value = 31 * value + (this.base_reward_per_block != null ? this.base_reward_per_block.hashCode() : 0);
            value = 31 * value + (this.base_reward_per_uncle_percent != null ? this.base_reward_per_uncle_percent.hashCode() : 0);
            value = 31 * value + (this.min_block_time_target != null ? this.min_block_time_target.hashCode() : 0);
            value = 31 * value + (this.max_block_time_target != null ? this.max_block_time_target.hashCode() : 0);
            value = 31 * value + (this.base_max_uncles_per_block != null ? this.base_max_uncles_per_block.hashCode() : 0);
            value = 31 * value + (this.base_block_gas_limit != null ? this.base_block_gas_limit.hashCode() : 0);
            value = 31 * value + (this.strategy != null ? this.strategy.hashCode() : 0);
            value = 31 * value + (this.script_allowed != null ? this.script_allowed.hashCode() : 0);
            value = 31 * value + (this.module_publishing_allowed != null ? this.module_publishing_allowed.hashCode() : 0);
            value = 31 * value + (this.instruction_schedule != null ? this.instruction_schedule.hashCode() : 0);
            value = 31 * value + (this.native_schedule != null ? this.native_schedule.hashCode() : 0);
            value = 31 * value + (this.global_memory_per_byte_cost != null ? this.global_memory_per_byte_cost.hashCode() : 0);
            value = 31 * value + (this.global_memory_per_byte_write_cost != null ? this.global_memory_per_byte_write_cost.hashCode() : 0);
            value = 31 * value + (this.min_transaction_gas_units != null ? this.min_transaction_gas_units.hashCode() : 0);
            value = 31 * value + (this.large_transaction_cutoff != null ? this.large_transaction_cutoff.hashCode() : 0);
            value = 31 * value + (this.instrinsic_gas_per_byte != null ? this.instrinsic_gas_per_byte.hashCode() : 0);
            value = 31 * value + (this.maximum_number_of_gas_units != null ? this.maximum_number_of_gas_units.hashCode() : 0);
            value = 31 * value + (this.min_price_per_gas_unit != null ? this.min_price_per_gas_unit.hashCode() : 0);
            value = 31 * value + (this.max_price_per_gas_unit != null ? this.max_price_per_gas_unit.hashCode() : 0);
            value = 31 * value + (this.max_transaction_size_in_bytes != null ? this.max_transaction_size_in_bytes.hashCode() : 0);
            value = 31 * value + (this.gas_unit_scaling_factor != null ? this.gas_unit_scaling_factor.hashCode() : 0);
            value = 31 * value + (this.default_account_size != null ? this.default_account_size.hashCode() : 0);
            value = 31 * value + (this.voting_delay != null ? this.voting_delay.hashCode() : 0);
            value = 31 * value + (this.voting_period != null ? this.voting_period.hashCode() : 0);
            value = 31 * value + (this.voting_quorum_rate != null ? this.voting_quorum_rate.hashCode() : 0);
            value = 31 * value + (this.min_action_delay != null ? this.min_action_delay.hashCode() : 0);
            value = 31 * value + (this.transaction_timeout != null ? this.transaction_timeout.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Long stdlib_version;
            public @Unsigned Long reward_delay;
            public @Unsigned @Int128 BigInteger pre_mine_stc_amount;
            public @Unsigned @Int128 BigInteger time_mint_stc_amount;
            public @Unsigned Long time_mint_stc_period;
            public Bytes parent_hash;
            public Bytes association_auth_key;
            public Bytes genesis_auth_key;
            public @Unsigned Byte chain_id;
            public @Unsigned Long genesis_timestamp;
            public @Unsigned Long uncle_rate_target;
            public @Unsigned Long epoch_block_count;
            public @Unsigned Long base_block_time_target;
            public @Unsigned Long base_block_difficulty_window;
            public @Unsigned @Int128 BigInteger base_reward_per_block;
            public @Unsigned Long base_reward_per_uncle_percent;
            public @Unsigned Long min_block_time_target;
            public @Unsigned Long max_block_time_target;
            public @Unsigned Long base_max_uncles_per_block;
            public @Unsigned Long base_block_gas_limit;
            public @Unsigned Byte strategy;
            public Boolean script_allowed;
            public Boolean module_publishing_allowed;
            public Bytes instruction_schedule;
            public Bytes native_schedule;
            public @Unsigned Long global_memory_per_byte_cost;
            public @Unsigned Long global_memory_per_byte_write_cost;
            public @Unsigned Long min_transaction_gas_units;
            public @Unsigned Long large_transaction_cutoff;
            public @Unsigned Long instrinsic_gas_per_byte;
            public @Unsigned Long maximum_number_of_gas_units;
            public @Unsigned Long min_price_per_gas_unit;
            public @Unsigned Long max_price_per_gas_unit;
            public @Unsigned Long max_transaction_size_in_bytes;
            public @Unsigned Long gas_unit_scaling_factor;
            public @Unsigned Long default_account_size;
            public @Unsigned Long voting_delay;
            public @Unsigned Long voting_period;
            public @Unsigned Byte voting_quorum_rate;
            public @Unsigned Long min_action_delay;
            public @Unsigned Long transaction_timeout;

            public Initialize build() {
                return new Initialize(this.stdlib_version, this.reward_delay, this.pre_mine_stc_amount, this.time_mint_stc_amount, this.time_mint_stc_period, this.parent_hash, this.association_auth_key, this.genesis_auth_key, this.chain_id, this.genesis_timestamp, this.uncle_rate_target, this.epoch_block_count, this.base_block_time_target, this.base_block_difficulty_window, this.base_reward_per_block, this.base_reward_per_uncle_percent, this.min_block_time_target, this.max_block_time_target, this.base_max_uncles_per_block, this.base_block_gas_limit, this.strategy, this.script_allowed, this.module_publishing_allowed, this.instruction_schedule, this.native_schedule, this.global_memory_per_byte_cost, this.global_memory_per_byte_write_cost, this.min_transaction_gas_units, this.large_transaction_cutoff, this.instrinsic_gas_per_byte, this.maximum_number_of_gas_units, this.min_price_per_gas_unit, this.max_price_per_gas_unit, this.max_transaction_size_in_bytes, this.gas_unit_scaling_factor, this.default_account_size, this.voting_delay, this.voting_period, this.voting_quorum_rate, this.min_action_delay, this.transaction_timeout);
            }
        }
    }

    public static final class ExecuteWithdrawProposal
    extends ScriptFunctionCall {
        public final TypeTag token_t;
        public final AccountAddress proposer_address;
        public final @Unsigned Long proposal_id;

        public ExecuteWithdrawProposal(TypeTag token_t, AccountAddress proposer_address, @Unsigned Long proposal_id) {
            Objects.requireNonNull(token_t, "token_t must not be null");
            Objects.requireNonNull(proposer_address, "proposer_address must not be null");
            Objects.requireNonNull(proposal_id, "proposal_id must not be null");
            this.token_t = token_t;
            this.proposer_address = proposer_address;
            this.proposal_id = proposal_id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExecuteWithdrawProposal other = (ExecuteWithdrawProposal)obj;
            if (!Objects.equals(this.token_t, other.token_t)) {
                return false;
            }
            if (!Objects.equals(this.proposer_address, other.proposer_address)) {
                return false;
            }
            return Objects.equals(this.proposal_id, other.proposal_id);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token_t != null ? this.token_t.hashCode() : 0);
            value = 31 * value + (this.proposer_address != null ? this.proposer_address.hashCode() : 0);
            value = 31 * value + (this.proposal_id != null ? this.proposal_id.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token_t;
            public AccountAddress proposer_address;
            public @Unsigned Long proposal_id;

            public ExecuteWithdrawProposal build() {
                return new ExecuteWithdrawProposal(this.token_t, this.proposer_address, this.proposal_id);
            }
        }
    }

    public static final class ExecuteOnChainConfigProposal
    extends ScriptFunctionCall {
        public final TypeTag config_t;
        public final @Unsigned Long proposal_id;

        public ExecuteOnChainConfigProposal(TypeTag config_t, @Unsigned Long proposal_id) {
            Objects.requireNonNull(config_t, "config_t must not be null");
            Objects.requireNonNull(proposal_id, "proposal_id must not be null");
            this.config_t = config_t;
            this.proposal_id = proposal_id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExecuteOnChainConfigProposal other = (ExecuteOnChainConfigProposal)obj;
            if (!Objects.equals(this.config_t, other.config_t)) {
                return false;
            }
            return Objects.equals(this.proposal_id, other.proposal_id);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.config_t != null ? this.config_t.hashCode() : 0);
            value = 31 * value + (this.proposal_id != null ? this.proposal_id.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag config_t;
            public @Unsigned Long proposal_id;

            public ExecuteOnChainConfigProposal build() {
                return new ExecuteOnChainConfigProposal(this.config_t, this.proposal_id);
            }
        }
    }

    public static final class Execute
    extends ScriptFunctionCall {
        public final TypeTag token_t;
        public final AccountAddress proposer_address;
        public final @Unsigned Long proposal_id;

        public Execute(TypeTag token_t, AccountAddress proposer_address, @Unsigned Long proposal_id) {
            Objects.requireNonNull(token_t, "token_t must not be null");
            Objects.requireNonNull(proposer_address, "proposer_address must not be null");
            Objects.requireNonNull(proposal_id, "proposal_id must not be null");
            this.token_t = token_t;
            this.proposer_address = proposer_address;
            this.proposal_id = proposal_id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Execute other = (Execute)obj;
            if (!Objects.equals(this.token_t, other.token_t)) {
                return false;
            }
            if (!Objects.equals(this.proposer_address, other.proposer_address)) {
                return false;
            }
            return Objects.equals(this.proposal_id, other.proposal_id);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token_t != null ? this.token_t.hashCode() : 0);
            value = 31 * value + (this.proposer_address != null ? this.proposer_address.hashCode() : 0);
            value = 31 * value + (this.proposal_id != null ? this.proposal_id.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token_t;
            public AccountAddress proposer_address;
            public @Unsigned Long proposal_id;

            public Execute build() {
                return new Execute(this.token_t, this.proposer_address, this.proposal_id);
            }
        }
    }

    public static final class EmptyScript
    extends ScriptFunctionCall {
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EmptyScript other = (EmptyScript)obj;
            return true;
        }

        public int hashCode() {
            int value = 7;
            return value;
        }

        public static final class Builder {
            public EmptyScript build() {
                return new EmptyScript();
            }
        }
    }

    public static final class DestroyTerminatedProposal
    extends ScriptFunctionCall {
        public final TypeTag token_t;
        public final TypeTag action_t;
        public final AccountAddress proposer_address;
        public final @Unsigned Long proposal_id;

        public DestroyTerminatedProposal(TypeTag token_t, TypeTag action_t, AccountAddress proposer_address, @Unsigned Long proposal_id) {
            Objects.requireNonNull(token_t, "token_t must not be null");
            Objects.requireNonNull(action_t, "action_t must not be null");
            Objects.requireNonNull(proposer_address, "proposer_address must not be null");
            Objects.requireNonNull(proposal_id, "proposal_id must not be null");
            this.token_t = token_t;
            this.action_t = action_t;
            this.proposer_address = proposer_address;
            this.proposal_id = proposal_id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DestroyTerminatedProposal other = (DestroyTerminatedProposal)obj;
            if (!Objects.equals(this.token_t, other.token_t)) {
                return false;
            }
            if (!Objects.equals(this.action_t, other.action_t)) {
                return false;
            }
            if (!Objects.equals(this.proposer_address, other.proposer_address)) {
                return false;
            }
            return Objects.equals(this.proposal_id, other.proposal_id);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token_t != null ? this.token_t.hashCode() : 0);
            value = 31 * value + (this.action_t != null ? this.action_t.hashCode() : 0);
            value = 31 * value + (this.proposer_address != null ? this.proposer_address.hashCode() : 0);
            value = 31 * value + (this.proposal_id != null ? this.proposal_id.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token_t;
            public TypeTag action_t;
            public AccountAddress proposer_address;
            public @Unsigned Long proposal_id;

            public DestroyTerminatedProposal build() {
                return new DestroyTerminatedProposal(this.token_t, this.action_t, this.proposer_address, this.proposal_id);
            }
        }
    }

    public static final class CreateAccountWithInitialAmountV2
    extends ScriptFunctionCall {
        public final TypeTag token_type;
        public final AccountAddress fresh_address;
        public final @Unsigned @Int128 BigInteger initial_amount;

        public CreateAccountWithInitialAmountV2(TypeTag token_type, AccountAddress fresh_address, @Unsigned @Int128 BigInteger initial_amount) {
            Objects.requireNonNull(token_type, "token_type must not be null");
            Objects.requireNonNull(fresh_address, "fresh_address must not be null");
            Objects.requireNonNull(initial_amount, "initial_amount must not be null");
            this.token_type = token_type;
            this.fresh_address = fresh_address;
            this.initial_amount = initial_amount;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CreateAccountWithInitialAmountV2 other = (CreateAccountWithInitialAmountV2)obj;
            if (!Objects.equals(this.token_type, other.token_type)) {
                return false;
            }
            if (!Objects.equals(this.fresh_address, other.fresh_address)) {
                return false;
            }
            return Objects.equals(this.initial_amount, other.initial_amount);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token_type != null ? this.token_type.hashCode() : 0);
            value = 31 * value + (this.fresh_address != null ? this.fresh_address.hashCode() : 0);
            value = 31 * value + (this.initial_amount != null ? this.initial_amount.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token_type;
            public AccountAddress fresh_address;
            public @Unsigned @Int128 BigInteger initial_amount;

            public CreateAccountWithInitialAmountV2 build() {
                return new CreateAccountWithInitialAmountV2(this.token_type, this.fresh_address, this.initial_amount);
            }
        }
    }

    public static final class CreateAccountWithInitialAmount
    extends ScriptFunctionCall {
        public final TypeTag token_type;
        public final AccountAddress fresh_address;
        public final Bytes _auth_key;
        public final @Unsigned @Int128 BigInteger initial_amount;

        public CreateAccountWithInitialAmount(TypeTag token_type, AccountAddress fresh_address, Bytes _auth_key, @Unsigned @Int128 BigInteger initial_amount) {
            Objects.requireNonNull(token_type, "token_type must not be null");
            Objects.requireNonNull(fresh_address, "fresh_address must not be null");
            Objects.requireNonNull(_auth_key, "_auth_key must not be null");
            Objects.requireNonNull(initial_amount, "initial_amount must not be null");
            this.token_type = token_type;
            this.fresh_address = fresh_address;
            this._auth_key = _auth_key;
            this.initial_amount = initial_amount;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CreateAccountWithInitialAmount other = (CreateAccountWithInitialAmount)obj;
            if (!Objects.equals(this.token_type, other.token_type)) {
                return false;
            }
            if (!Objects.equals(this.fresh_address, other.fresh_address)) {
                return false;
            }
            if (!Objects.equals(this._auth_key, other._auth_key)) {
                return false;
            }
            return Objects.equals(this.initial_amount, other.initial_amount);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token_type != null ? this.token_type.hashCode() : 0);
            value = 31 * value + (this.fresh_address != null ? this.fresh_address.hashCode() : 0);
            value = 31 * value + (this._auth_key != null ? this._auth_key.hashCode() : 0);
            value = 31 * value + (this.initial_amount != null ? this.initial_amount.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token_type;
            public AccountAddress fresh_address;
            public Bytes _auth_key;
            public @Unsigned @Int128 BigInteger initial_amount;

            public CreateAccountWithInitialAmount build() {
                return new CreateAccountWithInitialAmount(this.token_type, this.fresh_address, this._auth_key, this.initial_amount);
            }
        }
    }

    public static final class ConvertTwoPhaseUpgradeToTwoPhaseUpgradeV2
    extends ScriptFunctionCall {
        public final AccountAddress package_address;

        public ConvertTwoPhaseUpgradeToTwoPhaseUpgradeV2(AccountAddress package_address) {
            Objects.requireNonNull(package_address, "package_address must not be null");
            this.package_address = package_address;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConvertTwoPhaseUpgradeToTwoPhaseUpgradeV2 other = (ConvertTwoPhaseUpgradeToTwoPhaseUpgradeV2)obj;
            return Objects.equals(this.package_address, other.package_address);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.package_address != null ? this.package_address.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public AccountAddress package_address;

            public ConvertTwoPhaseUpgradeToTwoPhaseUpgradeV2 build() {
                return new ConvertTwoPhaseUpgradeToTwoPhaseUpgradeV2(this.package_address);
            }
        }
    }

    public static final class CastVote
    extends ScriptFunctionCall {
        public final TypeTag token;
        public final TypeTag action_t;
        public final AccountAddress proposer_address;
        public final @Unsigned Long proposal_id;
        public final Boolean agree;
        public final @Unsigned @Int128 BigInteger votes;

        public CastVote(TypeTag token, TypeTag action_t, AccountAddress proposer_address, @Unsigned Long proposal_id, Boolean agree, @Unsigned @Int128 BigInteger votes) {
            Objects.requireNonNull(token, "token must not be null");
            Objects.requireNonNull(action_t, "action_t must not be null");
            Objects.requireNonNull(proposer_address, "proposer_address must not be null");
            Objects.requireNonNull(proposal_id, "proposal_id must not be null");
            Objects.requireNonNull(agree, "agree must not be null");
            Objects.requireNonNull(votes, "votes must not be null");
            this.token = token;
            this.action_t = action_t;
            this.proposer_address = proposer_address;
            this.proposal_id = proposal_id;
            this.agree = agree;
            this.votes = votes;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CastVote other = (CastVote)obj;
            if (!Objects.equals(this.token, other.token)) {
                return false;
            }
            if (!Objects.equals(this.action_t, other.action_t)) {
                return false;
            }
            if (!Objects.equals(this.proposer_address, other.proposer_address)) {
                return false;
            }
            if (!Objects.equals(this.proposal_id, other.proposal_id)) {
                return false;
            }
            if (!Objects.equals(this.agree, other.agree)) {
                return false;
            }
            return Objects.equals(this.votes, other.votes);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token != null ? this.token.hashCode() : 0);
            value = 31 * value + (this.action_t != null ? this.action_t.hashCode() : 0);
            value = 31 * value + (this.proposer_address != null ? this.proposer_address.hashCode() : 0);
            value = 31 * value + (this.proposal_id != null ? this.proposal_id.hashCode() : 0);
            value = 31 * value + (this.agree != null ? this.agree.hashCode() : 0);
            value = 31 * value + (this.votes != null ? this.votes.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token;
            public TypeTag action_t;
            public AccountAddress proposer_address;
            public @Unsigned Long proposal_id;
            public Boolean agree;
            public @Unsigned @Int128 BigInteger votes;

            public CastVote build() {
                return new CastVote(this.token, this.action_t, this.proposer_address, this.proposal_id, this.agree, this.votes);
            }
        }
    }

    public static final class CancelUpgradePlan
    extends ScriptFunctionCall {
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CancelUpgradePlan other = (CancelUpgradePlan)obj;
            return true;
        }

        public int hashCode() {
            int value = 7;
            return value;
        }

        public static final class Builder {
            public CancelUpgradePlan build() {
                return new CancelUpgradePlan();
            }
        }
    }

    public static final class AcceptToken
    extends ScriptFunctionCall {
        public final TypeTag token_type;

        public AcceptToken(TypeTag token_type) {
            Objects.requireNonNull(token_type, "token_type must not be null");
            this.token_type = token_type;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AcceptToken other = (AcceptToken)obj;
            return Objects.equals(this.token_type, other.token_type);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.token_type != null ? this.token_type.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public TypeTag token_type;

            public AcceptToken build() {
                return new AcceptToken(this.token_type);
            }
        }
    }
}

