/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.Bytes;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.Int128;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Unsigned;
import java.math.BigInteger;
import java.util.Objects;
import org.starcoin.types.AccountAddress;

public abstract class TransactionArgument {
    public static TransactionArgument deserialize(Deserializer deserializer) throws DeserializationError {
        int index = deserializer.deserialize_variant_index();
        switch (index) {
            case 0: {
                return U8.load(deserializer);
            }
            case 1: {
                return U64.load(deserializer);
            }
            case 2: {
                return U128.load(deserializer);
            }
            case 3: {
                return Address.load(deserializer);
            }
            case 4: {
                return U8Vector.load(deserializer);
            }
            case 5: {
                return Bool.load(deserializer);
            }
        }
        throw new DeserializationError("Unknown variant index for TransactionArgument: " + index);
    }

    public static TransactionArgument bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        TransactionArgument value = TransactionArgument.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public abstract void serialize(Serializer var1) throws SerializationError;

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public static final class Bool
    extends TransactionArgument {
        public final Boolean value;

        public Bool(Boolean value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        static Bool load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = deserializer.deserialize_bool();
            deserializer.decrease_container_depth();
            return builder.build();
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(5);
            serializer.serialize_bool(this.value);
            serializer.decrease_container_depth();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Bool other = (Bool)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public Boolean value;

            public Bool build() {
                return new Bool(this.value);
            }
        }
    }

    public static final class U8Vector
    extends TransactionArgument {
        public final Bytes value;

        public U8Vector(Bytes value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        static U8Vector load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = deserializer.deserialize_bytes();
            deserializer.decrease_container_depth();
            return builder.build();
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(4);
            serializer.serialize_bytes(this.value);
            serializer.decrease_container_depth();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            U8Vector other = (U8Vector)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public Bytes value;

            public U8Vector build() {
                return new U8Vector(this.value);
            }
        }
    }

    public static final class Address
    extends TransactionArgument {
        public final AccountAddress value;

        public Address(AccountAddress value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        static Address load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = AccountAddress.deserialize(deserializer);
            deserializer.decrease_container_depth();
            return builder.build();
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(3);
            this.value.serialize(serializer);
            serializer.decrease_container_depth();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Address other = (Address)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public AccountAddress value;

            public Address build() {
                return new Address(this.value);
            }
        }
    }

    public static final class U128
    extends TransactionArgument {
        public final @Unsigned @Int128 BigInteger value;

        public U128(@Unsigned @Int128 BigInteger value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        static U128 load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = deserializer.deserialize_u128();
            deserializer.decrease_container_depth();
            return builder.build();
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(2);
            serializer.serialize_u128(this.value);
            serializer.decrease_container_depth();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            U128 other = (U128)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned @Int128 BigInteger value;

            public U128 build() {
                return new U128(this.value);
            }
        }
    }

    public static final class U64
    extends TransactionArgument {
        public final @Unsigned Long value;

        public U64(@Unsigned Long value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        static U64 load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = deserializer.deserialize_u64();
            deserializer.decrease_container_depth();
            return builder.build();
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(1);
            serializer.serialize_u64(this.value);
            serializer.decrease_container_depth();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            U64 other = (U64)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Long value;

            public U64 build() {
                return new U64(this.value);
            }
        }
    }

    public static final class U8
    extends TransactionArgument {
        public final @Unsigned Byte value;

        public U8(@Unsigned Byte value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
        }

        static U8 load(Deserializer deserializer) throws DeserializationError {
            deserializer.increase_container_depth();
            Builder builder = new Builder();
            builder.value = deserializer.deserialize_u8();
            deserializer.decrease_container_depth();
            return builder.build();
        }

        @Override
        public void serialize(Serializer serializer) throws SerializationError {
            serializer.increase_container_depth();
            serializer.serialize_variant_index(0);
            serializer.serialize_u8(this.value);
            serializer.decrease_container_depth();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            U8 other = (U8)obj;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int value = 7;
            value = 31 * value + (this.value != null ? this.value.hashCode() : 0);
            return value;
        }

        public static final class Builder {
            public @Unsigned Byte value;

            public U8 build() {
                return new U8(this.value);
            }
        }
    }
}

