/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types.event;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Unsigned;
import java.util.Objects;
import org.starcoin.types.AccountAddress;

public final class ProposalCreatedEvent {
    public final @Unsigned Long proposal_id;
    public final AccountAddress proposer;

    public ProposalCreatedEvent(@Unsigned Long proposal_id, AccountAddress proposer) {
        Objects.requireNonNull(proposal_id, "proposal_id must not be null");
        Objects.requireNonNull(proposer, "proposer must not be null");
        this.proposal_id = proposal_id;
        this.proposer = proposer;
    }

    public static ProposalCreatedEvent deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.proposal_id = deserializer.deserialize_u64();
        builder.proposer = AccountAddress.deserialize(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static ProposalCreatedEvent bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        ProposalCreatedEvent value = ProposalCreatedEvent.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        serializer.serialize_u64(this.proposal_id);
        this.proposer.serialize(serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProposalCreatedEvent other = (ProposalCreatedEvent)obj;
        if (!Objects.equals(this.proposal_id, other.proposal_id)) {
            return false;
        }
        return Objects.equals(this.proposer, other.proposer);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.proposal_id != null ? this.proposal_id.hashCode() : 0);
        value = 31 * value + (this.proposer != null ? this.proposer.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public @Unsigned Long proposal_id;
        public AccountAddress proposer;

        public ProposalCreatedEvent build() {
            return new ProposalCreatedEvent(this.proposal_id, this.proposer);
        }
    }
}

