/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types.event;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.Int128;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Unsigned;
import java.math.BigInteger;
import java.util.Objects;
import org.starcoin.types.AccountAddress;

public final class VoteChangedEvent {
    public final @Unsigned Long proposal_id;
    public final AccountAddress voter;
    public final AccountAddress proposer;
    public final Boolean agree;
    public final @Unsigned @Int128 BigInteger vote;

    public VoteChangedEvent(@Unsigned Long proposal_id, AccountAddress voter, AccountAddress proposer, Boolean agree, @Unsigned @Int128 BigInteger vote) {
        Objects.requireNonNull(proposal_id, "proposal_id must not be null");
        Objects.requireNonNull(voter, "voter must not be null");
        Objects.requireNonNull(proposer, "proposer must not be null");
        Objects.requireNonNull(agree, "agree must not be null");
        Objects.requireNonNull(vote, "vote must not be null");
        this.proposal_id = proposal_id;
        this.voter = voter;
        this.proposer = proposer;
        this.agree = agree;
        this.vote = vote;
    }

    public static VoteChangedEvent deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.proposal_id = deserializer.deserialize_u64();
        builder.voter = AccountAddress.deserialize(deserializer);
        builder.proposer = AccountAddress.deserialize(deserializer);
        builder.agree = deserializer.deserialize_bool();
        builder.vote = deserializer.deserialize_u128();
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static VoteChangedEvent bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        VoteChangedEvent value = VoteChangedEvent.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        serializer.serialize_u64(this.proposal_id);
        this.voter.serialize(serializer);
        this.proposer.serialize(serializer);
        serializer.serialize_bool(this.agree);
        serializer.serialize_u128(this.vote);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VoteChangedEvent other = (VoteChangedEvent)obj;
        if (!Objects.equals(this.proposal_id, other.proposal_id)) {
            return false;
        }
        if (!Objects.equals(this.voter, other.voter)) {
            return false;
        }
        if (!Objects.equals(this.proposer, other.proposer)) {
            return false;
        }
        if (!Objects.equals(this.agree, other.agree)) {
            return false;
        }
        return Objects.equals(this.vote, other.vote);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.proposal_id != null ? this.proposal_id.hashCode() : 0);
        value = 31 * value + (this.voter != null ? this.voter.hashCode() : 0);
        value = 31 * value + (this.proposer != null ? this.proposer.hashCode() : 0);
        value = 31 * value + (this.agree != null ? this.agree.hashCode() : 0);
        value = 31 * value + (this.vote != null ? this.vote.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public @Unsigned Long proposal_id;
        public AccountAddress voter;
        public AccountAddress proposer;
        public Boolean agree;
        public @Unsigned @Int128 BigInteger vote;

        public VoteChangedEvent build() {
            return new VoteChangedEvent(this.proposal_id, this.voter, this.proposer, this.agree, this.vote);
        }
    }
}

