/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.utils;

import com.google.common.primitives.Bytes;
import com.novi.serde.DeserializationError;
import com.novi.serde.SerializationError;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.starcoin.types.AccountAddress;
import org.starcoin.types.AccountResource;
import org.starcoin.types.AuthenticationKey;
import org.starcoin.types.ChainId;
import org.starcoin.types.Ed25519PrivateKey;
import org.starcoin.types.Ed25519PublicKey;
import org.starcoin.types.Ed25519Signature;
import org.starcoin.types.MultiEd25519PublicKey;
import org.starcoin.types.MultiEd25519Signature;
import org.starcoin.types.RawUserTransaction;
import org.starcoin.types.SignedMessage;
import org.starcoin.types.SignedUserTransaction;
import org.starcoin.types.SigningMessage;
import org.starcoin.types.TransactionAuthenticator;
import org.starcoin.types.TransactionPayload;
import org.starcoin.utils.HashUtils;
import org.starcoin.utils.Hex;

public class SignatureUtils {
    public static final String GAS_TOKEN_CODE_STC = "0x1::STC::STC";

    public static String getTransactionHash(Ed25519PrivateKey ed25519PrivateKey, Integer chainId, AccountAddress accountAddress, BigInteger accountSeqNumber, TransactionPayload payload, BigInteger gasPrice, BigInteger gasLimit, Long expirationTimestampSecs) {
        SignedUserTransaction signedUserTransaction = SignatureUtils.createSignedUserTransaction(ed25519PrivateKey, chainId, accountAddress, accountSeqNumber, payload, gasPrice, gasLimit, expirationTimestampSecs);
        byte[] signedMessage = signedUserTransaction.bcsSerialize();
        return HashUtils.hashStarcoinSignedUserTransaction(signedMessage);
    }

    public static SignedUserTransaction createSignedUserTransaction(Ed25519PrivateKey ed25519PrivateKey, Integer chainId, AccountAddress accountAddress, BigInteger accountSeqNumber, TransactionPayload payload, BigInteger gasPrice, BigInteger gasLimit, Long expirationTimestampSecs) {
        RawUserTransaction rawUserTransaction = SignatureUtils.createRawUserTransaction(chainId, accountAddress, accountSeqNumber, payload, gasPrice, gasLimit, expirationTimestampSecs);
        return SignatureUtils.signTxn(ed25519PrivateKey, rawUserTransaction);
    }

    public static RawUserTransaction createRawUserTransaction(Integer chainId, AccountAddress accountAddress, BigInteger accountSeqNumber, TransactionPayload payload, BigInteger gasPrice, BigInteger gasLimit, Long expirationTimestampSecs) {
        ChainId chainIdObj = new ChainId(chainId.byteValue());
        return new RawUserTransaction(accountAddress, accountSeqNumber.longValue(), payload, gasLimit.longValue(), gasPrice.longValue(), GAS_TOKEN_CODE_STC, expirationTimestampSecs, chainIdObj);
    }

    public static SignedUserTransaction signTxn(Ed25519PrivateKey privateKey, RawUserTransaction rawUserTransaction) {
        byte[] bytes = Bytes.concat((byte[][])new byte[][]{HashUtils.hashWithStarcoinPrefix("RawUserTransaction"), rawUserTransaction.bcsSerialize()});
        byte[] signRst = SignatureUtils.ed25519Sign(privateKey, bytes);
        Ed25519PublicKey publicKey = SignatureUtils.getPublicKey(privateKey);
        Ed25519Signature signature = new Ed25519Signature(new com.novi.serde.Bytes(signRst));
        TransactionAuthenticator.Ed25519 transactionAuthenticator = new TransactionAuthenticator.Ed25519(publicKey, signature);
        SignedUserTransaction signedUserTransaction = new SignedUserTransaction(rawUserTransaction, transactionAuthenticator);
        return signedUserTransaction;
    }

    public static String signPersonalBcsSerializedMessage(Ed25519PrivateKey privateKey, String serializedMessageHex) {
        SigningMessage signingMessage = SigningMessage.bcsDeserialize(Hex.decode(serializedMessageHex));
        byte[] signRst = SignatureUtils.ed25519Sign(privateKey, SigningMessage.hashBytes(signingMessage));
        return Hex.encode(signRst);
    }

    public static String signPersonalMessage(Ed25519PrivateKey privateKey, String message) {
        com.novi.serde.Bytes signingBytes = com.novi.serde.Bytes.valueOf(message.getBytes(StandardCharsets.UTF_8));
        SigningMessage signingMessage = new SigningMessage(signingBytes.toList());
        byte[] signRst = SignatureUtils.ed25519Sign(privateKey, SigningMessage.hashBytes(signingMessage));
        return Hex.encode(signRst);
    }

    public static boolean signedMessageCheckAccount(SignedMessage signedMessage, ChainId chainId, AccountResource accountResource) throws DeserializationError, SerializationError {
        com.novi.serde.Bytes serdeBytes;
        AuthenticationKey authenticationKeyInMessage = TransactionAuthenticator.authenticationKey(signedMessage.authenticator);
        if (accountResource == null) {
            return signedMessage.account.equals(authenticationKeyInMessage.derivedAddress());
        }
        if (signedMessage.chain_id.equals(chainId) && (serdeBytes = com.novi.serde.Bytes.fromList(accountResource.authentication_key)) != null) {
            AuthenticationKey authenticationKeyOnChain = new AuthenticationKey(serdeBytes);
            return authenticationKeyOnChain.equals(authenticationKeyInMessage);
        }
        return false;
    }

    public static boolean signedMessageCheckSignature(SignedMessage signedMessage) throws SerializationError, DeserializationError {
        return SignatureUtils.signingMessageCheckSignature(signedMessage.message, signedMessage.authenticator);
    }

    static boolean signingMessageCheckSignature(SigningMessage message, TransactionAuthenticator authenticator) throws SerializationError, DeserializationError {
        if (authenticator instanceof TransactionAuthenticator.Ed25519) {
            Ed25519PublicKey publicKey = ((TransactionAuthenticator.Ed25519)authenticator).public_key;
            Ed25519Signature ed25519Signature = ((TransactionAuthenticator.Ed25519)authenticator).signature;
            return SignatureUtils.ed25519Verify(publicKey, SigningMessage.hashBytes(message), ed25519Signature.value.content());
        }
        if (authenticator instanceof TransactionAuthenticator.MultiEd25519) {
            MultiEd25519PublicKey publicKey = ((TransactionAuthenticator.MultiEd25519)authenticator).public_key;
            MultiEd25519Signature multiEd25519Signature = ((TransactionAuthenticator.MultiEd25519)authenticator).signature;
            return SignatureUtils.multiEd25519Verify(publicKey, SigningMessage.hashBytes(message), multiEd25519Signature.value.content());
        }
        return false;
    }

    public static Ed25519PublicKey getPublicKey(Ed25519PrivateKey privateKey) {
        Ed25519PrivateKeyParameters key = new Ed25519PrivateKeyParameters(privateKey.value.content(), 0);
        Ed25519PublicKeyParameters publicKeyParameters = key.generatePublicKey();
        Ed25519PublicKey publicKey = new Ed25519PublicKey(new com.novi.serde.Bytes(publicKeyParameters.getEncoded()));
        return publicKey;
    }

    public static byte[] ed25519Sign(Ed25519PrivateKey privateKey, byte[] data) {
        Ed25519PrivateKeyParameters key = new Ed25519PrivateKeyParameters(privateKey.value.content(), 0);
        Ed25519Signer signer = new Ed25519Signer();
        signer.init(true, (CipherParameters)key);
        signer.update(data, 0, data.length);
        byte[] rst = signer.generateSignature();
        return rst;
    }

    public static boolean ed25519Verify(Ed25519PublicKey publicKey, byte[] signingMessage, byte[] signature) {
        Ed25519PublicKeyParameters key = new Ed25519PublicKeyParameters(publicKey.value.content(), 0);
        Ed25519Signer signer = new Ed25519Signer();
        signer.init(false, (CipherParameters)key);
        signer.update(signingMessage, 0, signingMessage.length);
        return signer.verifySignature(signature);
    }

    public static boolean multiEd25519Verify(MultiEd25519PublicKey publicKey, byte[] signingMessage, byte[] signature) {
        Ed25519PublicKeyParameters key = new Ed25519PublicKeyParameters(publicKey.value.content(), 0);
        Ed25519Signer signer = new Ed25519Signer();
        signer.init(false, (CipherParameters)key);
        signer.update(signingMessage, 0, signingMessage.length);
        return signer.verifySignature(signature);
    }

    public static Ed25519PrivateKey strToPrivateKey(String privateKeyString) {
        return new Ed25519PrivateKey(new com.novi.serde.Bytes(Hex.decode(privateKeyString)));
    }
}

