/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import org.starcoin.types.AccountAddress;
import org.starcoin.types.Identifier;
import org.starcoin.types.StructTag;
import org.starcoin.types.TypeTag;
import org.starcoin.utils.Hex;

public class StructTagDeserializer
extends StdDeserializer<StructTag> {
    public StructTagDeserializer() {
        super(StructTag.class);
    }

    public StructTag deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        StructTag structTag = null;
        AccountAddress address = null;
        Identifier module = null;
        Identifier name = null;
        ArrayList<TypeTag> type_params = new ArrayList<TypeTag>();
        while (!jsonParser.isClosed()) {
            String token = jsonParser.nextTextValue();
            if (token == null) continue;
            switch (jsonParser.getCurrentName()) {
                case "struct_tag_type": {
                    String[] tokens = token.split("::");
                    address = AccountAddress.valueOf(Hex.decode(tokens[0]));
                    module = new Identifier(tokens[1]);
                    name = new Identifier(tokens[2]);
                    break;
                }
            }
        }
        if (address != null && module != null & name != null) {
            structTag = new StructTag(address, module, name, type_params);
        }
        return structTag;
    }
}

