/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.jsonrpc;

public class JSONRPC2Error {
    public static final JSONRPC2Error PARSE_ERROR = new JSONRPC2Error(-32700, "JSON parse error");
    public static final JSONRPC2Error INVALID_REQUEST = new JSONRPC2Error(-32600, "Invalid request");
    public static final JSONRPC2Error METHOD_NOT_FOUND = new JSONRPC2Error(-32601, "Method not found");
    public static final JSONRPC2Error INVALID_PARAMS = new JSONRPC2Error(-32602, "Invalid parameters");
    public static final JSONRPC2Error INTERNAL_ERROR = new JSONRPC2Error(-32603, "Internal error");
    private static final long serialVersionUID = 4682571044532698806L;
    private int code;
    private Object data;
    private String message;

    public JSONRPC2Error() {
    }

    public JSONRPC2Error(int code, String message) {
        this(code, message, null);
    }

    public JSONRPC2Error(int code, String message, Object data) {
        this.message = message;
        this.code = code;
        this.data = data;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public JSONRPC2Error appendMessage(String apx) {
        return new JSONRPC2Error(this.code, this.getMessage() + apx, this.data);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof JSONRPC2Error && this.code == ((JSONRPC2Error)object).getCode();
    }

    public String toString() {
        return "JSONRPC2Error{code=" + this.code + ", data=" + this.data + ", message='" + this.message + '\'' + '}';
    }
}

