/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.Objects;
import org.starcoin.types.AccountAddress;
import org.starcoin.types.DataPath;

public final class AccessPath {
    public final AccountAddress field0;
    public final DataPath field1;

    public AccessPath(AccountAddress field0, DataPath field1) {
        Objects.requireNonNull(field0, "field0 must not be null");
        Objects.requireNonNull(field1, "field1 must not be null");
        this.field0 = field0;
        this.field1 = field1;
    }

    public static AccessPath deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.field0 = AccountAddress.deserialize(deserializer);
        builder.field1 = DataPath.deserialize(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static AccessPath bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        AccessPath value = AccessPath.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        this.field0.serialize(serializer);
        this.field1.serialize(serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessPath other = (AccessPath)obj;
        if (!Objects.equals(this.field0, other.field0)) {
            return false;
        }
        return Objects.equals(this.field1, other.field1);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.field0 != null ? this.field0.hashCode() : 0);
        value = 31 * value + (this.field1 != null ? this.field1.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public AccountAddress field0;
        public DataPath field1;

        public AccessPath build() {
            return new AccessPath(this.field0, this.field1);
        }
    }
}

