/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Unsigned;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.starcoin.types.EventHandle;
import org.starcoin.types.KeyRotationCapabilityResource;
import org.starcoin.types.TraitHelpers;
import org.starcoin.types.WithdrawCapabilityResource;

public final class AccountResource {
    public final List<@Unsigned Byte> authentication_key;
    public final Optional<WithdrawCapabilityResource> withdrawal_capability;
    public final Optional<KeyRotationCapabilityResource> key_rotation_capability;
    public final EventHandle withdraw_events;
    public final EventHandle deposit_events;
    public final EventHandle accept_token_events;
    public final @Unsigned Long sequence_number;

    public AccountResource(List<@Unsigned Byte> authentication_key, Optional<WithdrawCapabilityResource> withdrawal_capability, Optional<KeyRotationCapabilityResource> key_rotation_capability, EventHandle withdraw_events, EventHandle deposit_events, EventHandle accept_token_events, @Unsigned Long sequence_number) {
        Objects.requireNonNull(authentication_key, "authentication_key must not be null");
        Objects.requireNonNull(withdrawal_capability, "withdrawal_capability must not be null");
        Objects.requireNonNull(key_rotation_capability, "key_rotation_capability must not be null");
        Objects.requireNonNull(withdraw_events, "withdraw_events must not be null");
        Objects.requireNonNull(deposit_events, "deposit_events must not be null");
        Objects.requireNonNull(accept_token_events, "accept_token_events must not be null");
        Objects.requireNonNull(sequence_number, "sequence_number must not be null");
        this.authentication_key = authentication_key;
        this.withdrawal_capability = withdrawal_capability;
        this.key_rotation_capability = key_rotation_capability;
        this.withdraw_events = withdraw_events;
        this.deposit_events = deposit_events;
        this.accept_token_events = accept_token_events;
        this.sequence_number = sequence_number;
    }

    public static AccountResource deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.authentication_key = TraitHelpers.deserialize_vector_u8(deserializer);
        builder.withdrawal_capability = TraitHelpers.deserialize_option_WithdrawCapabilityResource(deserializer);
        builder.key_rotation_capability = TraitHelpers.deserialize_option_KeyRotationCapabilityResource(deserializer);
        builder.withdraw_events = EventHandle.deserialize(deserializer);
        builder.deposit_events = EventHandle.deserialize(deserializer);
        builder.accept_token_events = EventHandle.deserialize(deserializer);
        builder.sequence_number = deserializer.deserialize_u64();
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static AccountResource bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        AccountResource value = AccountResource.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        TraitHelpers.serialize_vector_u8(this.authentication_key, serializer);
        TraitHelpers.serialize_option_WithdrawCapabilityResource(this.withdrawal_capability, serializer);
        TraitHelpers.serialize_option_KeyRotationCapabilityResource(this.key_rotation_capability, serializer);
        this.withdraw_events.serialize(serializer);
        this.deposit_events.serialize(serializer);
        this.accept_token_events.serialize(serializer);
        serializer.serialize_u64(this.sequence_number);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccountResource other = (AccountResource)obj;
        if (!Objects.equals(this.authentication_key, other.authentication_key)) {
            return false;
        }
        if (!Objects.equals(this.withdrawal_capability, other.withdrawal_capability)) {
            return false;
        }
        if (!Objects.equals(this.key_rotation_capability, other.key_rotation_capability)) {
            return false;
        }
        if (!Objects.equals(this.withdraw_events, other.withdraw_events)) {
            return false;
        }
        if (!Objects.equals(this.deposit_events, other.deposit_events)) {
            return false;
        }
        if (!Objects.equals(this.accept_token_events, other.accept_token_events)) {
            return false;
        }
        return Objects.equals(this.sequence_number, other.sequence_number);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.authentication_key != null ? this.authentication_key.hashCode() : 0);
        value = 31 * value + (this.withdrawal_capability != null ? this.withdrawal_capability.hashCode() : 0);
        value = 31 * value + (this.key_rotation_capability != null ? this.key_rotation_capability.hashCode() : 0);
        value = 31 * value + (this.withdraw_events != null ? this.withdraw_events.hashCode() : 0);
        value = 31 * value + (this.deposit_events != null ? this.deposit_events.hashCode() : 0);
        value = 31 * value + (this.accept_token_events != null ? this.accept_token_events.hashCode() : 0);
        value = 31 * value + (this.sequence_number != null ? this.sequence_number.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public List<@Unsigned Byte> authentication_key;
        public Optional<WithdrawCapabilityResource> withdrawal_capability;
        public Optional<KeyRotationCapabilityResource> key_rotation_capability;
        public EventHandle withdraw_events;
        public EventHandle deposit_events;
        public EventHandle accept_token_events;
        public @Unsigned Long sequence_number;

        public AccountResource build() {
            return new AccountResource(this.authentication_key, this.withdrawal_capability, this.key_rotation_capability, this.withdraw_events, this.deposit_events, this.accept_token_events, this.sequence_number);
        }
    }
}

