/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.serde.ArrayLen;
import com.novi.serde.Bytes;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import com.novi.serde.Tuple2;
import com.novi.serde.Unsigned;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.starcoin.types.AccessPath;
import org.starcoin.types.AccountAddress;
import org.starcoin.types.ArgumentABI;
import org.starcoin.types.AuthenticationKey;
import org.starcoin.types.KeyRotationCapabilityResource;
import org.starcoin.types.Module;
import org.starcoin.types.ScriptFunction;
import org.starcoin.types.TypeArgumentABI;
import org.starcoin.types.TypeTag;
import org.starcoin.types.WithdrawCapabilityResource;
import org.starcoin.types.WriteOp;

final class TraitHelpers {
    TraitHelpers() {
    }

    static void serialize_array16_u8_array(@ArrayLen(length=16) List<@Unsigned Byte> value, Serializer serializer) throws SerializationError {
        if (value.size() != 16) {
            throw new IllegalArgumentException("Invalid length for fixed-size array: " + value.size() + " instead of " + 16);
        }
        for (Byte item : value) {
            serializer.serialize_u8(item);
        }
    }

    static @ArrayLen(length=16) List<@Unsigned Byte> deserialize_array16_u8_array(Deserializer deserializer) throws DeserializationError {
        ArrayList<@Unsigned Byte> obj = new ArrayList<Byte>(16);
        for (long i = 0L; i < 16L; ++i) {
            obj.add(deserializer.deserialize_u8());
        }
        return obj;
    }

    static void serialize_option_bytes(Optional<Bytes> value, Serializer serializer) throws SerializationError {
        if (value.isPresent()) {
            serializer.serialize_option_tag(true);
            serializer.serialize_bytes(value.get());
        } else {
            serializer.serialize_option_tag(false);
        }
    }

    static Optional<Bytes> deserialize_option_bytes(Deserializer deserializer) throws DeserializationError {
        boolean tag = deserializer.deserialize_option_tag();
        if (!tag) {
            return Optional.empty();
        }
        return Optional.of(deserializer.deserialize_bytes());
    }

    static void serialize_option_str(Optional<String> value, Serializer serializer) throws SerializationError {
        if (value.isPresent()) {
            serializer.serialize_option_tag(true);
            serializer.serialize_str(value.get());
        } else {
            serializer.serialize_option_tag(false);
        }
    }

    static Optional<String> deserialize_option_str(Deserializer deserializer) throws DeserializationError {
        boolean tag = deserializer.deserialize_option_tag();
        if (!tag) {
            return Optional.empty();
        }
        return Optional.of(deserializer.deserialize_str());
    }

    static void serialize_option_u64(Optional<@Unsigned Long> value, Serializer serializer) throws SerializationError {
        if (value.isPresent()) {
            serializer.serialize_option_tag(true);
            serializer.serialize_u64(value.get());
        } else {
            serializer.serialize_option_tag(false);
        }
    }

    static Optional<@Unsigned Long> deserialize_option_u64(Deserializer deserializer) throws DeserializationError {
        boolean tag = deserializer.deserialize_option_tag();
        if (!tag) {
            return Optional.empty();
        }
        return Optional.of(deserializer.deserialize_u64());
    }

    static void serialize_vector_AccountAddress(List<AccountAddress> value, Serializer serializer) throws SerializationError {
        serializer.serialize_len(value.size());
        for (AccountAddress item : value) {
            item.serialize(serializer);
        }
    }

    static List<AccountAddress> deserialize_vector_AccountAddress(Deserializer deserializer) throws DeserializationError {
        long length = deserializer.deserialize_len();
        ArrayList<AccountAddress> obj = new ArrayList<AccountAddress>((int)length);
        for (long i = 0L; i < length; ++i) {
            obj.add(AccountAddress.deserialize(deserializer));
        }
        return obj;
    }

    static void serialize_vector_str(List<String> value, Serializer serializer) throws SerializationError {
        serializer.serialize_len(value.size());
        for (String item : value) {
            serializer.serialize_str(item);
        }
    }

    static List<String> deserialize_vector_str(Deserializer deserializer) throws DeserializationError {
        long length = deserializer.deserialize_len();
        ArrayList<String> obj = new ArrayList<String>((int)length);
        for (long i = 0L; i < length; ++i) {
            obj.add(deserializer.deserialize_str());
        }
        return obj;
    }

    static void serialize_option_AuthenticationKey(Optional<AuthenticationKey> value, Serializer serializer) throws SerializationError {
        if (value.isPresent()) {
            serializer.serialize_option_tag(true);
            value.get().serialize(serializer);
        } else {
            serializer.serialize_option_tag(false);
        }
    }

    static Optional<AuthenticationKey> deserialize_option_AuthenticationKey(Deserializer deserializer) throws DeserializationError {
        boolean tag = deserializer.deserialize_option_tag();
        if (!tag) {
            return Optional.empty();
        }
        return Optional.of(AuthenticationKey.deserialize(deserializer));
    }

    static void serialize_option_KeyRotationCapabilityResource(Optional<KeyRotationCapabilityResource> value, Serializer serializer) throws SerializationError {
        if (value.isPresent()) {
            serializer.serialize_option_tag(true);
            value.get().serialize(serializer);
        } else {
            serializer.serialize_option_tag(false);
        }
    }

    static Optional<KeyRotationCapabilityResource> deserialize_option_KeyRotationCapabilityResource(Deserializer deserializer) throws DeserializationError {
        boolean tag = deserializer.deserialize_option_tag();
        if (!tag) {
            return Optional.empty();
        }
        return Optional.of(KeyRotationCapabilityResource.deserialize(deserializer));
    }

    static void serialize_option_ScriptFunction(Optional<ScriptFunction> value, Serializer serializer) throws SerializationError {
        if (value.isPresent()) {
            serializer.serialize_option_tag(true);
            value.get().serialize(serializer);
        } else {
            serializer.serialize_option_tag(false);
        }
    }

    static Optional<ScriptFunction> deserialize_option_ScriptFunction(Deserializer deserializer) throws DeserializationError {
        boolean tag = deserializer.deserialize_option_tag();
        if (!tag) {
            return Optional.empty();
        }
        return Optional.of(ScriptFunction.deserialize(deserializer));
    }

    static void serialize_option_WithdrawCapabilityResource(Optional<WithdrawCapabilityResource> value, Serializer serializer) throws SerializationError {
        if (value.isPresent()) {
            serializer.serialize_option_tag(true);
            value.get().serialize(serializer);
        } else {
            serializer.serialize_option_tag(false);
        }
    }

    static Optional<WithdrawCapabilityResource> deserialize_option_WithdrawCapabilityResource(Deserializer deserializer) throws DeserializationError {
        boolean tag = deserializer.deserialize_option_tag();
        if (!tag) {
            return Optional.empty();
        }
        return Optional.of(WithdrawCapabilityResource.deserialize(deserializer));
    }

    static void serialize_tuple2_AccessPath_WriteOp(Tuple2<AccessPath, WriteOp> value, Serializer serializer) throws SerializationError {
        ((AccessPath)value.field0).serialize(serializer);
        ((WriteOp)value.field1).serialize(serializer);
    }

    static Tuple2<AccessPath, WriteOp> deserialize_tuple2_AccessPath_WriteOp(Deserializer deserializer) throws DeserializationError {
        return new Tuple2<AccessPath, WriteOp>(AccessPath.deserialize(deserializer), WriteOp.deserialize(deserializer));
    }

    static void serialize_vector_ArgumentABI(List<ArgumentABI> value, Serializer serializer) throws SerializationError {
        serializer.serialize_len(value.size());
        for (ArgumentABI item : value) {
            item.serialize(serializer);
        }
    }

    static List<ArgumentABI> deserialize_vector_ArgumentABI(Deserializer deserializer) throws DeserializationError {
        long length = deserializer.deserialize_len();
        ArrayList<ArgumentABI> obj = new ArrayList<ArgumentABI>((int)length);
        for (long i = 0L; i < length; ++i) {
            obj.add(ArgumentABI.deserialize(deserializer));
        }
        return obj;
    }

    static void serialize_vector_Module(List<Module> value, Serializer serializer) throws SerializationError {
        serializer.serialize_len(value.size());
        for (Module item : value) {
            item.serialize(serializer);
        }
    }

    static List<Module> deserialize_vector_Module(Deserializer deserializer) throws DeserializationError {
        long length = deserializer.deserialize_len();
        ArrayList<Module> obj = new ArrayList<Module>((int)length);
        for (long i = 0L; i < length; ++i) {
            obj.add(Module.deserialize(deserializer));
        }
        return obj;
    }

    static void serialize_vector_TypeArgumentABI(List<TypeArgumentABI> value, Serializer serializer) throws SerializationError {
        serializer.serialize_len(value.size());
        for (TypeArgumentABI item : value) {
            item.serialize(serializer);
        }
    }

    static List<TypeArgumentABI> deserialize_vector_TypeArgumentABI(Deserializer deserializer) throws DeserializationError {
        long length = deserializer.deserialize_len();
        ArrayList<TypeArgumentABI> obj = new ArrayList<TypeArgumentABI>((int)length);
        for (long i = 0L; i < length; ++i) {
            obj.add(TypeArgumentABI.deserialize(deserializer));
        }
        return obj;
    }

    static void serialize_vector_TypeTag(List<TypeTag> value, Serializer serializer) throws SerializationError {
        serializer.serialize_len(value.size());
        for (TypeTag item : value) {
            item.serialize(serializer);
        }
    }

    static List<TypeTag> deserialize_vector_TypeTag(Deserializer deserializer) throws DeserializationError {
        long length = deserializer.deserialize_len();
        ArrayList<TypeTag> obj = new ArrayList<TypeTag>((int)length);
        for (long i = 0L; i < length; ++i) {
            obj.add(TypeTag.deserialize(deserializer));
        }
        return obj;
    }

    static void serialize_vector_bytes(List<Bytes> value, Serializer serializer) throws SerializationError {
        serializer.serialize_len(value.size());
        for (Bytes item : value) {
            serializer.serialize_bytes(item);
        }
    }

    static List<Bytes> deserialize_vector_bytes(Deserializer deserializer) throws DeserializationError {
        long length = deserializer.deserialize_len();
        ArrayList<Bytes> obj = new ArrayList<Bytes>((int)length);
        for (long i = 0L; i < length; ++i) {
            obj.add(deserializer.deserialize_bytes());
        }
        return obj;
    }

    static void serialize_vector_tuple2_AccessPath_WriteOp(List<Tuple2<AccessPath, WriteOp>> value, Serializer serializer) throws SerializationError {
        serializer.serialize_len(value.size());
        for (Tuple2<AccessPath, WriteOp> item : value) {
            TraitHelpers.serialize_tuple2_AccessPath_WriteOp(item, serializer);
        }
    }

    static List<Tuple2<AccessPath, WriteOp>> deserialize_vector_tuple2_AccessPath_WriteOp(Deserializer deserializer) throws DeserializationError {
        long length = deserializer.deserialize_len();
        ArrayList<Tuple2<AccessPath, WriteOp>> obj = new ArrayList<Tuple2<AccessPath, WriteOp>>((int)length);
        for (long i = 0L; i < length; ++i) {
            obj.add(TraitHelpers.deserialize_tuple2_AccessPath_WriteOp(deserializer));
        }
        return obj;
    }

    static void serialize_vector_u8(List<@Unsigned Byte> value, Serializer serializer) throws SerializationError {
        serializer.serialize_len(value.size());
        for (Byte item : value) {
            serializer.serialize_u8(item);
        }
    }

    static List<@Unsigned Byte> deserialize_vector_u8(Deserializer deserializer) throws DeserializationError {
        long length = deserializer.deserialize_len();
        ArrayList<@Unsigned Byte> obj = new ArrayList<Byte>((int)length);
        for (long i = 0L; i < length; ++i) {
            obj.add(deserializer.deserialize_u8());
        }
        return obj;
    }
}

