/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.stategen.framework.util.CollectionUtil;
import org.stategen.framework.util.ReflectionUtil;

public class EnumUtil {
    public static String getDescIfIsEnum(ResolvedType resolvedType) {
        Class erasedType = resolvedType.getErasedType();
        if (Enum.class.isAssignableFrom(erasedType)) {
            Object[] enums;
            Object[] fields = erasedType.getDeclaredFields();
            ArrayList<Object> fieldList = new ArrayList<Object>();
            if (CollectionUtil.isNotEmpty((Object[])fields)) {
                for (Object field : fields) {
                    Class<?> type;
                    if ((((Field)field).getModifiers() & 8) != 0 || erasedType == (type = ((Field)field).getType()) || type.isArray() && erasedType == type.getComponentType()) continue;
                    fieldList.add(field);
                }
            }
            if (CollectionUtil.isNotEmpty((Object[])(enums = (Enum[])erasedType.getEnumConstants()))) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < enums.length; ++i) {
                    Object enm = enums[i];
                    String name = ((Enum)enm).name();
                    sb.append(name);
                    if (CollectionUtil.isNotEmpty(fieldList)) {
                        sb.append('(');
                        for (int ii = 0; ii < fieldList.size(); ++ii) {
                            Field field = (Field)fieldList.get(ii);
                            Object valueObj = ReflectionUtil.getFieldValue((Object)enm, (Field)field);
                            if (valueObj != null) {
                                String value = valueObj.toString();
                                sb.append(value);
                            }
                            if (ii >= fieldList.size() - 1) continue;
                            sb.append(',');
                        }
                        sb.append(")");
                    }
                    if (i >= enums.length - 1) continue;
                    sb.append("; ");
                }
                sb.append(".");
                return sb.toString();
            }
        }
        return null;
    }
}

