/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.stategen.framework.util.StringUtil;
import springfox.documentation.schema.EnumUtil;
import springfox.documentation.schema.Enums;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.parameter.ParameterAnnotationReader;
import springfox.documentation.swagger.schema.ApiModelProperties;

@Component(value="swaggerParameterDescriptionReader")
@Order(value=-2147482648)
public class ApiParamParameterBuilder
implements ParameterBuilderPlugin {
    static final Logger logger = LoggerFactory.getLogger(ApiParamParameterBuilder.class);

    public void apply(ParameterContext context) {
        MethodParameter methodParameter = context.methodParameter();
        Optional<ApiParam> apiParam = this.findApiParam(methodParameter);
        context.parameterBuilder().allowableValues(this.allowableValues(methodParameter, (String)apiParam.transform(this.toAllowableValue()).or((Object)"")));
        if (apiParam.isPresent()) {
            Optional typeOptional = context.parameterBuilder().build().getType();
            ResolvedType resolvedType = (ResolvedType)typeOptional.get();
            String enumDescs = EnumUtil.getDescIfIsEnum(resolvedType);
            context.parameterBuilder().name(Strings.emptyToNull((String)((ApiParam)apiParam.get()).name()));
            if (StringUtil.isNotEmpty((String)enumDescs)) {
                context.parameterBuilder().description(Strings.emptyToNull((String)(((ApiParam)apiParam.get()).value() + ":" + enumDescs)));
            } else {
                context.parameterBuilder().description(Strings.emptyToNull((String)((ApiParam)apiParam.get()).value()));
            }
            context.parameterBuilder().parameterAccess(Strings.emptyToNull((String)((ApiParam)apiParam.get()).access()));
            context.parameterBuilder().defaultValue(Strings.emptyToNull((String)((ApiParam)apiParam.get()).defaultValue()));
            context.parameterBuilder().allowMultiple(((ApiParam)apiParam.get()).allowMultiple());
            context.parameterBuilder().required(((ApiParam)apiParam.get()).required());
        }
    }

    @VisibleForTesting
    Optional<ApiParam> findApiParam(MethodParameter methodParameter) {
        return ParameterAnnotationReader.apiParam((MethodParameter)methodParameter);
    }

    private Function<ApiParam, String> toAllowableValue() {
        return new Function<ApiParam, String>(){

            public String apply(ApiParam input) {
                return input.allowableValues();
            }
        };
    }

    private AllowableValues allowableValues(MethodParameter methodParameter, String allowableValueString) {
        AllowableValues allowableValues = null;
        if (!Strings.isNullOrEmpty((String)allowableValueString)) {
            allowableValues = ApiModelProperties.allowableValueFromString((String)allowableValueString);
        } else {
            if (methodParameter.getParameterType().isEnum()) {
                allowableValues = Enums.allowableValues((Class)methodParameter.getParameterType());
            }
            if (methodParameter.getParameterType().isArray()) {
                allowableValues = Enums.allowableValues(methodParameter.getParameterType().getComponentType());
            }
        }
        return allowableValues;
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply((DocumentationType)delimiter);
    }
}

