/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.walletsdk.toml;

import com.google.gson.annotations.SerializedName;
import io.ktor.http.URLProtocol;
import io.ktor.http.URLUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.Network;
import org.stellar.walletsdk.exception.ValidationException;
import org.stellar.walletsdk.toml.InfoContact;
import org.stellar.walletsdk.toml.InfoCurrency;
import org.stellar.walletsdk.toml.InfoDocumentation;
import org.stellar.walletsdk.toml.InfoServices;
import org.stellar.walletsdk.toml.InfoValidator;
import org.stellar.walletsdk.toml.Sep10;
import org.stellar.walletsdk.toml.Sep12;
import org.stellar.walletsdk.toml.Sep24;
import org.stellar.walletsdk.toml.Sep31;
import org.stellar.walletsdk.toml.Sep6;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u00d1\u0001\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u000e\u0012\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u000e\u0012\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u001aJ\u000b\u00106\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u00107\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u00108\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000eH\u00c6\u0003J\u000b\u00109\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010:\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010;\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010<\u001a\u0004\u0018\u00010\u0013H\u00c6\u0003J\u0011\u0010=\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u000eH\u00c6\u0003J\u0011\u0010>\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u000eH\u00c6\u0003J\u0011\u0010?\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u000eH\u00c6\u0003J\u000b\u0010@\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010A\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010B\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010C\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010D\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010E\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010F\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010G\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u00f9\u0001\u0010H\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0010\b\u0002\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u000e2\u0010\b\u0002\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u000e2\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u000eH\u00c6\u0001J\u0013\u0010I\u001a\u00020&2\b\u0010J\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010K\u001a\u00020LH\u00d6\u0001J\u001a\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u00032\b\u0010P\u001a\u0004\u0018\u00010\u0003H\u0002J\t\u0010Q\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010R\u001a\u00020N2\u0006\u0010S\u001a\u00020TR\u001e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u001e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001eR\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00138\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001eR\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001eR\u0018\u0010\t\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001eR\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001eR\u001e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001cR\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001eR\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u001eR\u0018\u0010\b\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u001eR\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u001eR\u001e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001cR\u0018\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u001eR\u0018\u0010\n\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001e\u00a8\u0006U"}, d2={"Lorg/stellar/walletsdk/toml/TomlInfo;", "", "version", "", "networkPassphrase", "federationServer", "authServer", "transferServer", "transferServerSep24", "kycServer", "webAuthEndpoint", "signingKey", "horizonUrl", "accounts", "", "uriRequestSigningKey", "directPaymentServer", "anchorQuoteServer", "documentation", "Lorg/stellar/walletsdk/toml/InfoDocumentation;", "principals", "Lorg/stellar/walletsdk/toml/InfoContact;", "currencies", "Lorg/stellar/walletsdk/toml/InfoCurrency;", "validators", "Lorg/stellar/walletsdk/toml/InfoValidator;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/stellar/walletsdk/toml/InfoDocumentation;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAccounts", "()Ljava/util/List;", "getAnchorQuoteServer", "()Ljava/lang/String;", "getAuthServer", "getCurrencies", "getDirectPaymentServer", "getDocumentation", "()Lorg/stellar/walletsdk/toml/InfoDocumentation;", "getFederationServer", "hasAuth", "", "getHorizonUrl", "getKycServer", "getNetworkPassphrase", "getPrincipals", "services", "Lorg/stellar/walletsdk/toml/InfoServices;", "getServices", "()Lorg/stellar/walletsdk/toml/InfoServices;", "getSigningKey", "getTransferServer", "getTransferServerSep24", "getUriRequestSigningKey", "getValidators", "getVersion", "getWebAuthEndpoint", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "requireSecure", "", "name", "url", "toString", "validate", "network", "Lorg/stellar/sdk/Network;", "wallet-sdk"})
public final class TomlInfo {
    @SerializedName(value="VERSION")
    @Nullable
    private final String version;
    @SerializedName(value="NETWORK_PASSPHRASE")
    @Nullable
    private final String networkPassphrase;
    @SerializedName(value="FEDERATION_SERVER")
    @Nullable
    private final String federationServer;
    @SerializedName(value="AUTH_SERVER")
    @Nullable
    private final String authServer;
    @SerializedName(value="TRANSFER_SERVER")
    @Nullable
    private final String transferServer;
    @SerializedName(value="TRANSFER_SERVER_SEP0024")
    @Nullable
    private final String transferServerSep24;
    @SerializedName(value="KYC_SERVER")
    @Nullable
    private final String kycServer;
    @SerializedName(value="WEB_AUTH_ENDPOINT")
    @Nullable
    private final String webAuthEndpoint;
    @SerializedName(value="SIGNING_KEY")
    @Nullable
    private final String signingKey;
    @SerializedName(value="HORIZON_URL")
    @Nullable
    private final String horizonUrl;
    @SerializedName(value="ACCOUNTS")
    @Nullable
    private final List<String> accounts;
    @SerializedName(value="URI_REQUEST_SIGNING_KEY")
    @Nullable
    private final String uriRequestSigningKey;
    @SerializedName(value="DIRECT_PAYMENT_SERVER")
    @Nullable
    private final String directPaymentServer;
    @SerializedName(value="ANCHOR_QUOTE_SERVER")
    @Nullable
    private final String anchorQuoteServer;
    @SerializedName(value="DOCUMENTATION")
    @Nullable
    private final InfoDocumentation documentation;
    @SerializedName(value="PRINCIPALS")
    @Nullable
    private final List<InfoContact> principals;
    @SerializedName(value="CURRENCIES")
    @Nullable
    private final List<InfoCurrency> currencies;
    @SerializedName(value="VALIDATORS")
    @Nullable
    private final List<InfoValidator> validators;
    private final boolean hasAuth;
    @NotNull
    private final InfoServices services;

    public TomlInfo(@Nullable String version, @Nullable String networkPassphrase, @Nullable String federationServer, @Nullable String authServer, @Nullable String transferServer, @Nullable String transferServerSep24, @Nullable String kycServer, @Nullable String webAuthEndpoint, @Nullable String signingKey, @Nullable String horizonUrl, @Nullable List<String> accounts, @Nullable String uriRequestSigningKey, @Nullable String directPaymentServer, @Nullable String anchorQuoteServer, @Nullable InfoDocumentation documentation, @Nullable List<InfoContact> principals, @Nullable List<InfoCurrency> currencies, @Nullable List<InfoValidator> validators) {
        this.version = version;
        this.networkPassphrase = networkPassphrase;
        this.federationServer = federationServer;
        this.authServer = authServer;
        this.transferServer = transferServer;
        this.transferServerSep24 = transferServerSep24;
        this.kycServer = kycServer;
        this.webAuthEndpoint = webAuthEndpoint;
        this.signingKey = signingKey;
        this.horizonUrl = horizonUrl;
        this.accounts = accounts;
        this.uriRequestSigningKey = uriRequestSigningKey;
        this.directPaymentServer = directPaymentServer;
        this.anchorQuoteServer = anchorQuoteServer;
        this.documentation = documentation;
        this.principals = principals;
        this.currencies = currencies;
        this.validators = validators;
        this.hasAuth = this.webAuthEndpoint != null && this.signingKey != null;
        this.services = new InfoServices(this.transferServer != null ? new Sep6(this.transferServer, this.anchorQuoteServer) : null, this.hasAuth ? new Sep10(String.valueOf(this.webAuthEndpoint), String.valueOf(this.signingKey)) : null, this.kycServer != null ? new Sep12(this.kycServer.toString(), String.valueOf(this.signingKey)) : null, this.transferServerSep24 != null ? new Sep24(this.transferServerSep24, this.hasAuth) : null, this.directPaymentServer != null ? new Sep31(this.directPaymentServer, this.hasAuth, this.kycServer, this.anchorQuoteServer) : null);
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    @Nullable
    public final String getNetworkPassphrase() {
        return this.networkPassphrase;
    }

    @Nullable
    public final String getFederationServer() {
        return this.federationServer;
    }

    @Nullable
    public final String getAuthServer() {
        return this.authServer;
    }

    @Nullable
    public final String getTransferServer() {
        return this.transferServer;
    }

    @Nullable
    public final String getTransferServerSep24() {
        return this.transferServerSep24;
    }

    @Nullable
    public final String getKycServer() {
        return this.kycServer;
    }

    @Nullable
    public final String getWebAuthEndpoint() {
        return this.webAuthEndpoint;
    }

    @Nullable
    public final String getSigningKey() {
        return this.signingKey;
    }

    @Nullable
    public final String getHorizonUrl() {
        return this.horizonUrl;
    }

    @Nullable
    public final List<String> getAccounts() {
        return this.accounts;
    }

    @Nullable
    public final String getUriRequestSigningKey() {
        return this.uriRequestSigningKey;
    }

    @Nullable
    public final String getDirectPaymentServer() {
        return this.directPaymentServer;
    }

    @Nullable
    public final String getAnchorQuoteServer() {
        return this.anchorQuoteServer;
    }

    @Nullable
    public final InfoDocumentation getDocumentation() {
        return this.documentation;
    }

    @Nullable
    public final List<InfoContact> getPrincipals() {
        return this.principals;
    }

    @Nullable
    public final List<InfoCurrency> getCurrencies() {
        return this.currencies;
    }

    @Nullable
    public final List<InfoValidator> getValidators() {
        return this.validators;
    }

    @NotNull
    public final InfoServices getServices() {
        return this.services;
    }

    public final void validate(@NotNull Network network) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        if (!Intrinsics.areEqual((Object)network, (Object)Network.PUBLIC)) {
            return;
        }
        this.requireSecure("TRANSFER_SERVER", this.transferServer);
        this.requireSecure("TRANSFER_SERVER_SEP0024", this.transferServerSep24);
        this.requireSecure("FEDERATION_SERVER", this.federationServer);
        this.requireSecure("AUTH_SERVER", this.authServer);
        this.requireSecure("KYC_SERVER", this.kycServer);
        this.requireSecure("WEB_AUTH_ENDPOINT", this.webAuthEndpoint);
        this.requireSecure("DIRECT_PAYMENT_SERVER", this.directPaymentServer);
        this.requireSecure("ANCHOR_QUOTE_SERVER", this.anchorQuoteServer);
    }

    private final void requireSecure(String name, String url) {
        if (url != null && !Intrinsics.areEqual((Object)URLUtilsKt.URLBuilder((String)url).getProtocol().getName(), (Object)URLProtocol.Companion.getHTTPS().getName())) {
            throw new ValidationException("TOML file contains url using http protocol for " + name + ": " + url + ". Http urls are prohibited in production environment. Please notify anchor owner.");
        }
    }

    @Nullable
    public final String component1() {
        return this.version;
    }

    @Nullable
    public final String component2() {
        return this.networkPassphrase;
    }

    @Nullable
    public final String component3() {
        return this.federationServer;
    }

    @Nullable
    public final String component4() {
        return this.authServer;
    }

    @Nullable
    public final String component5() {
        return this.transferServer;
    }

    @Nullable
    public final String component6() {
        return this.transferServerSep24;
    }

    @Nullable
    public final String component7() {
        return this.kycServer;
    }

    @Nullable
    public final String component8() {
        return this.webAuthEndpoint;
    }

    @Nullable
    public final String component9() {
        return this.signingKey;
    }

    @Nullable
    public final String component10() {
        return this.horizonUrl;
    }

    @Nullable
    public final List<String> component11() {
        return this.accounts;
    }

    @Nullable
    public final String component12() {
        return this.uriRequestSigningKey;
    }

    @Nullable
    public final String component13() {
        return this.directPaymentServer;
    }

    @Nullable
    public final String component14() {
        return this.anchorQuoteServer;
    }

    @Nullable
    public final InfoDocumentation component15() {
        return this.documentation;
    }

    @Nullable
    public final List<InfoContact> component16() {
        return this.principals;
    }

    @Nullable
    public final List<InfoCurrency> component17() {
        return this.currencies;
    }

    @Nullable
    public final List<InfoValidator> component18() {
        return this.validators;
    }

    @NotNull
    public final TomlInfo copy(@Nullable String version, @Nullable String networkPassphrase, @Nullable String federationServer, @Nullable String authServer, @Nullable String transferServer, @Nullable String transferServerSep24, @Nullable String kycServer, @Nullable String webAuthEndpoint, @Nullable String signingKey, @Nullable String horizonUrl, @Nullable List<String> accounts, @Nullable String uriRequestSigningKey, @Nullable String directPaymentServer, @Nullable String anchorQuoteServer, @Nullable InfoDocumentation documentation, @Nullable List<InfoContact> principals, @Nullable List<InfoCurrency> currencies, @Nullable List<InfoValidator> validators) {
        return new TomlInfo(version, networkPassphrase, federationServer, authServer, transferServer, transferServerSep24, kycServer, webAuthEndpoint, signingKey, horizonUrl, accounts, uriRequestSigningKey, directPaymentServer, anchorQuoteServer, documentation, principals, currencies, validators);
    }

    public static /* synthetic */ TomlInfo copy$default(TomlInfo tomlInfo, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, List list, String string11, String string12, String string13, InfoDocumentation infoDocumentation, List list2, List list3, List list4, int n, Object object) {
        if ((n & 1) != 0) {
            string = tomlInfo.version;
        }
        if ((n & 2) != 0) {
            string2 = tomlInfo.networkPassphrase;
        }
        if ((n & 4) != 0) {
            string3 = tomlInfo.federationServer;
        }
        if ((n & 8) != 0) {
            string4 = tomlInfo.authServer;
        }
        if ((n & 0x10) != 0) {
            string5 = tomlInfo.transferServer;
        }
        if ((n & 0x20) != 0) {
            string6 = tomlInfo.transferServerSep24;
        }
        if ((n & 0x40) != 0) {
            string7 = tomlInfo.kycServer;
        }
        if ((n & 0x80) != 0) {
            string8 = tomlInfo.webAuthEndpoint;
        }
        if ((n & 0x100) != 0) {
            string9 = tomlInfo.signingKey;
        }
        if ((n & 0x200) != 0) {
            string10 = tomlInfo.horizonUrl;
        }
        if ((n & 0x400) != 0) {
            list = tomlInfo.accounts;
        }
        if ((n & 0x800) != 0) {
            string11 = tomlInfo.uriRequestSigningKey;
        }
        if ((n & 0x1000) != 0) {
            string12 = tomlInfo.directPaymentServer;
        }
        if ((n & 0x2000) != 0) {
            string13 = tomlInfo.anchorQuoteServer;
        }
        if ((n & 0x4000) != 0) {
            infoDocumentation = tomlInfo.documentation;
        }
        if ((n & 0x8000) != 0) {
            list2 = tomlInfo.principals;
        }
        if ((n & 0x10000) != 0) {
            list3 = tomlInfo.currencies;
        }
        if ((n & 0x20000) != 0) {
            list4 = tomlInfo.validators;
        }
        return tomlInfo.copy(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, list, string11, string12, string13, infoDocumentation, list2, list3, list4);
    }

    @NotNull
    public String toString() {
        return "TomlInfo(version=" + this.version + ", networkPassphrase=" + this.networkPassphrase + ", federationServer=" + this.federationServer + ", authServer=" + this.authServer + ", transferServer=" + this.transferServer + ", transferServerSep24=" + this.transferServerSep24 + ", kycServer=" + this.kycServer + ", webAuthEndpoint=" + this.webAuthEndpoint + ", signingKey=" + this.signingKey + ", horizonUrl=" + this.horizonUrl + ", accounts=" + this.accounts + ", uriRequestSigningKey=" + this.uriRequestSigningKey + ", directPaymentServer=" + this.directPaymentServer + ", anchorQuoteServer=" + this.anchorQuoteServer + ", documentation=" + this.documentation + ", principals=" + this.principals + ", currencies=" + this.currencies + ", validators=" + this.validators + ")";
    }

    public int hashCode() {
        int result2 = this.version == null ? 0 : this.version.hashCode();
        result2 = result2 * 31 + (this.networkPassphrase == null ? 0 : this.networkPassphrase.hashCode());
        result2 = result2 * 31 + (this.federationServer == null ? 0 : this.federationServer.hashCode());
        result2 = result2 * 31 + (this.authServer == null ? 0 : this.authServer.hashCode());
        result2 = result2 * 31 + (this.transferServer == null ? 0 : this.transferServer.hashCode());
        result2 = result2 * 31 + (this.transferServerSep24 == null ? 0 : this.transferServerSep24.hashCode());
        result2 = result2 * 31 + (this.kycServer == null ? 0 : this.kycServer.hashCode());
        result2 = result2 * 31 + (this.webAuthEndpoint == null ? 0 : this.webAuthEndpoint.hashCode());
        result2 = result2 * 31 + (this.signingKey == null ? 0 : this.signingKey.hashCode());
        result2 = result2 * 31 + (this.horizonUrl == null ? 0 : this.horizonUrl.hashCode());
        result2 = result2 * 31 + (this.accounts == null ? 0 : ((Object)this.accounts).hashCode());
        result2 = result2 * 31 + (this.uriRequestSigningKey == null ? 0 : this.uriRequestSigningKey.hashCode());
        result2 = result2 * 31 + (this.directPaymentServer == null ? 0 : this.directPaymentServer.hashCode());
        result2 = result2 * 31 + (this.anchorQuoteServer == null ? 0 : this.anchorQuoteServer.hashCode());
        result2 = result2 * 31 + (this.documentation == null ? 0 : this.documentation.hashCode());
        result2 = result2 * 31 + (this.principals == null ? 0 : ((Object)this.principals).hashCode());
        result2 = result2 * 31 + (this.currencies == null ? 0 : ((Object)this.currencies).hashCode());
        result2 = result2 * 31 + (this.validators == null ? 0 : ((Object)this.validators).hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TomlInfo)) {
            return false;
        }
        TomlInfo tomlInfo = (TomlInfo)other;
        if (!Intrinsics.areEqual((Object)this.version, (Object)tomlInfo.version)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.networkPassphrase, (Object)tomlInfo.networkPassphrase)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.federationServer, (Object)tomlInfo.federationServer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.authServer, (Object)tomlInfo.authServer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.transferServer, (Object)tomlInfo.transferServer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.transferServerSep24, (Object)tomlInfo.transferServerSep24)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.kycServer, (Object)tomlInfo.kycServer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.webAuthEndpoint, (Object)tomlInfo.webAuthEndpoint)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.signingKey, (Object)tomlInfo.signingKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.horizonUrl, (Object)tomlInfo.horizonUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.accounts, tomlInfo.accounts)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.uriRequestSigningKey, (Object)tomlInfo.uriRequestSigningKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.directPaymentServer, (Object)tomlInfo.directPaymentServer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.anchorQuoteServer, (Object)tomlInfo.anchorQuoteServer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.documentation, (Object)tomlInfo.documentation)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.principals, tomlInfo.principals)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.currencies, tomlInfo.currencies)) {
            return false;
        }
        return Intrinsics.areEqual(this.validators, tomlInfo.validators);
    }
}

