/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.walletsdk.asset;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.AssetTypePoolShare;
import org.stellar.walletsdk.asset.AssetIdKt;
import org.stellar.walletsdk.asset.IssuedAssetId;
import org.stellar.walletsdk.asset.NativeAssetId;
import org.stellar.walletsdk.asset.StellarAssetId;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0000\u001a\n\u0010\n\u001a\u00020\t*\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006*\n\u0010\u000b\"\u00020\f2\u00020\f\u00a8\u0006\r"}, d2={"FIAT_SCHEME", "", "STELLAR_SCHEME", "log", "Lmu/KLogger;", "getLog", "()Lmu/KLogger;", "toAsset", "Lorg/stellar/sdk/Asset;", "Lorg/stellar/walletsdk/asset/StellarAssetId;", "toAssetId", "XLM", "Lorg/stellar/walletsdk/asset/NativeAssetId;", "wallet-sdk"})
public final class AssetIdKt {
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);
    @NotNull
    public static final String STELLAR_SCHEME = "stellar";
    @NotNull
    public static final String FIAT_SCHEME = "iso4217";

    @NotNull
    public static final KLogger getLog() {
        return log;
    }

    @NotNull
    public static final Asset toAsset(@NotNull StellarAssetId $this$toAsset) {
        Intrinsics.checkNotNullParameter((Object)$this$toAsset, (String)"<this>");
        Asset asset = Asset.create((String)$this$toAsset.getId());
        Intrinsics.checkNotNullExpressionValue((Object)asset, (String)"create(this.id)");
        return asset;
    }

    @NotNull
    public static final StellarAssetId toAssetId(@NotNull Asset $this$toAssetId) {
        StellarAssetId stellarAssetId;
        Intrinsics.checkNotNullParameter((Object)$this$toAssetId, (String)"<this>");
        Asset asset = $this$toAssetId;
        if (asset instanceof AssetTypeNative) {
            stellarAssetId = NativeAssetId.INSTANCE;
        } else if (asset instanceof AssetTypeCreditAlphaNum) {
            String string = ((AssetTypeCreditAlphaNum)$this$toAssetId).getCode();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.code");
            String string2 = ((AssetTypeCreditAlphaNum)$this$toAssetId).getIssuer();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.issuer");
            stellarAssetId = new IssuedAssetId(string, string2);
        } else {
            if (asset instanceof AssetTypePoolShare) {
                throw new UnsupportedOperationException("Unsupported asset type");
            }
            throw new UnsupportedOperationException("Unknown asset type");
        }
        return stellarAssetId;
    }
}

