/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.walletsdk.auth;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import java.security.Key;
import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stellar.walletsdk.auth.AuthHeaderSigner;
import org.stellar.walletsdk.horizon.AccountKeyPair;
import org.stellar.walletsdk.horizon.SigningKeyPair;
import org.stellar.walletsdk.util.UtilKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0012\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rJ9\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013R\u001f\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0014"}, d2={"Lorg/stellar/walletsdk/auth/DefaultAuthHeaderSigner;", "Lorg/stellar/walletsdk/auth/AuthHeaderSigner;", "expiration", "Lkotlin/time/Duration;", "(JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getExpiration-UwyO8pc", "()J", "J", "createBuilder", "Lio/jsonwebtoken/JwtBuilder;", "timeExp", "Ljava/time/Instant;", "claims", "", "", "createToken", "clientDomain", "issuer", "Lorg/stellar/walletsdk/horizon/AccountKeyPair;", "(Ljava/util/Map;Ljava/lang/String;Lorg/stellar/walletsdk/horizon/AccountKeyPair;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "wallet-sdk"})
@SourceDebugExtension(value={"SMAP\nAuthHeaderSigner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthHeaderSigner.kt\norg/stellar/walletsdk/auth/DefaultAuthHeaderSigner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,111:1\n1#2:112\n215#3,2:113\n*S KotlinDebug\n*F\n+ 1 AuthHeaderSigner.kt\norg/stellar/walletsdk/auth/DefaultAuthHeaderSigner\n*L\n52#1:113,2\n*E\n"})
public class DefaultAuthHeaderSigner
implements AuthHeaderSigner {
    private final long expiration;

    private DefaultAuthHeaderSigner(long expiration) {
        this.expiration = expiration;
    }

    public /* synthetic */ DefaultAuthHeaderSigner(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.MINUTES);
        }
        this(l, null);
    }

    public long getExpiration-UwyO8pc() {
        return this.expiration;
    }

    @Override
    @Nullable
    public Object createToken(@NotNull Map<String, String> claims, @Nullable String clientDomain, @Nullable AccountKeyPair issuer, @NotNull Continuation<? super String> $completion) {
        return DefaultAuthHeaderSigner.createToken$suspendImpl(this, claims, clientDomain, issuer, $completion);
    }

    static /* synthetic */ Object createToken$suspendImpl(DefaultAuthHeaderSigner $this, Map<String, String> claims, String clientDomain, AccountKeyPair issuer, Continuation<? super String> $completion) {
        if (!(issuer != null)) {
            boolean $i$a$-require-DefaultAuthHeaderSigner$createToken$42 = false;
            String $i$a$-require-DefaultAuthHeaderSigner$createToken$42 = "Default signer can't sign headers for client domain.";
            throw new IllegalArgumentException($i$a$-require-DefaultAuthHeaderSigner$createToken$42.toString());
        }
        if (!(issuer instanceof SigningKeyPair)) {
            boolean $i$a$-require-DefaultAuthHeaderSigner$createToken$52 = false;
            String $i$a$-require-DefaultAuthHeaderSigner$createToken$52 = "SigningKeyPair must be provided to .auth() method in order to sign headers";
            throw new IllegalArgumentException($i$a$-require-DefaultAuthHeaderSigner$createToken$52.toString());
        }
        Instant timeExp = Instant.ofEpochSecond(Clock.System.INSTANCE.now().plus-LRDsOJo($this.getExpiration-UwyO8pc()).getEpochSeconds());
        Intrinsics.checkNotNullExpressionValue((Object)timeExp, (String)"timeExp");
        JwtBuilder builder = $this.createBuilder(timeExp, claims);
        builder.signWith((Key)UtilKt.toJava((SigningKeyPair)issuer).getPrivate(), (SecureDigestAlgorithm)Jwts.SIG.EdDSA);
        String string = builder.compact();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.compact()");
        return string;
    }

    @NotNull
    public final JwtBuilder createBuilder(@NotNull Instant timeExp, @NotNull Map<String, String> claims) {
        JwtBuilder jwtBuilder;
        Intrinsics.checkNotNullParameter((Object)timeExp, (String)"timeExp");
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        JwtBuilder builder = jwtBuilder = Jwts.builder().issuedAt(Date.from(Instant.now())).expiration(Date.from(timeExp));
        boolean bl = false;
        Map<String, String> $this$forEach$iv = claims;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl2 = false;
            builder.claim(it.getKey(), (Object)it.getValue());
        }
        JwtBuilder jwtBuilder2 = jwtBuilder;
        Intrinsics.checkNotNullExpressionValue((Object)jwtBuilder2, (String)"builder().issuedAt(Date.\u2026it.key, it.value) }\n    }");
        return jwtBuilder2;
    }

    public /* synthetic */ DefaultAuthHeaderSigner(long expiration, DefaultConstructorMarker $constructor_marker) {
        this(expiration);
    }
}

