/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.walletsdk.horizon;

import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.Network;
import org.stellar.sdk.Server;
import org.stellar.sdk.responses.AccountResponse;
import org.stellar.sdk.responses.operations.OperationResponse;
import org.stellar.walletsdk.Config;
import org.stellar.walletsdk.Order;
import org.stellar.walletsdk.extension.ServerKt;
import org.stellar.walletsdk.horizon.AccountServiceKt;
import org.stellar.walletsdk.horizon.SigningKeyPair;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJO\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J#\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lorg/stellar/walletsdk/horizon/AccountService;", "", "cfg", "Lorg/stellar/walletsdk/Config;", "(Lorg/stellar/walletsdk/Config;)V", "network", "Lorg/stellar/sdk/Network;", "server", "Lorg/stellar/sdk/Server;", "createKeyPair", "Lorg/stellar/walletsdk/horizon/SigningKeyPair;", "getHistory", "", "Lorg/stellar/sdk/responses/operations/OperationResponse;", "accountAddress", "", "limit", "", "order", "Lorg/stellar/walletsdk/Order;", "cursor", "includeFailed", "", "(Ljava/lang/String;Ljava/lang/Integer;Lorg/stellar/walletsdk/Order;Ljava/lang/String;Ljava/lang/Boolean;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getInfo", "Lorg/stellar/sdk/responses/AccountResponse;", "serverInstance", "(Ljava/lang/String;Lorg/stellar/sdk/Server;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "wallet-sdk"})
public final class AccountService {
    @NotNull
    private final Config cfg;
    @NotNull
    private final Server server;
    @NotNull
    private final Network network;

    public AccountService(@NotNull Config cfg) {
        Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
        this.cfg = cfg;
        this.server = this.cfg.getStellar().getServer();
        this.network = this.cfg.getStellar().getNetwork();
    }

    @NotNull
    public final SigningKeyPair createKeyPair() {
        KeyPair keyPair = KeyPair.random();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"random()");
        return new SigningKeyPair(keyPair);
    }

    @Nullable
    public final Object getInfo(@NotNull String accountAddress, @NotNull Server serverInstance, @NotNull Continuation<? super AccountResponse> $completion) {
        return ServerKt.accountByAddress(serverInstance, accountAddress, $completion);
    }

    public static /* synthetic */ Object getInfo$default(AccountService accountService, String string, Server server, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            server = accountService.server;
        }
        return accountService.getInfo(string, server, (Continuation<? super AccountResponse>)continuation);
    }

    @Nullable
    public final Object getHistory(@NotNull String accountAddress, @Nullable Integer limit, @Nullable Order order, @Nullable String cursor, @Nullable Boolean includeFailed, @NotNull Continuation<? super List<? extends OperationResponse>> $completion) {
        AccountServiceKt.access$getLog$p().debug((Function0)new Function0<Object>(accountAddress, limit, order, cursor, includeFailed){
            final /* synthetic */ String $accountAddress;
            final /* synthetic */ Integer $limit;
            final /* synthetic */ Order $order;
            final /* synthetic */ String $cursor;
            final /* synthetic */ Boolean $includeFailed;
            {
                this.$accountAddress = $accountAddress;
                this.$limit = $limit;
                this.$order = $order;
                this.$cursor = $cursor;
                this.$includeFailed = $includeFailed;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Account history: accountAddress = " + this.$accountAddress + ", limit = " + this.$limit + ", order = " + this.$order + ", cursor = " + this.$cursor + ", includeFailed = " + this.$includeFailed;
            }
        });
        return ServerKt.accountOperations(this.server, accountAddress, limit, order, cursor, includeFailed, $completion);
    }

    public static /* synthetic */ Object getHistory$default(AccountService accountService, String string, Integer n, Order order, String string2, Boolean bl, Continuation continuation, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            order = Order.DESC;
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = null;
        }
        return accountService.getHistory(string, n, order, string2, bl, (Continuation<? super List<? extends OperationResponse>>)continuation);
    }
}

