/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.walletsdk.horizon;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.AbstractTransaction;
import org.stellar.sdk.KeyPair;
import org.stellar.walletsdk.horizon.AccountKeyPair;
import org.stellar.walletsdk.horizon.AccountKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u001d\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u0002H\u0014\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/stellar/walletsdk/horizon/SigningKeyPair;", "Lorg/stellar/walletsdk/horizon/AccountKeyPair;", "keyPair", "Lorg/stellar/sdk/KeyPair;", "(Lorg/stellar/sdk/KeyPair;)V", "getKeyPair", "()Lorg/stellar/sdk/KeyPair;", "secretKey", "", "getSecretKey", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "sign", "T", "Lorg/stellar/sdk/AbstractTransaction;", "transaction", "(Lorg/stellar/sdk/AbstractTransaction;)Lorg/stellar/sdk/AbstractTransaction;", "toString", "Companion", "wallet-sdk"})
@SourceDebugExtension(value={"SMAP\nAccount.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Account.kt\norg/stellar/walletsdk/horizon/SigningKeyPair\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class SigningKeyPair
implements AccountKeyPair {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KeyPair keyPair;

    public SigningKeyPair(@NotNull KeyPair keyPair) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        this.keyPair = keyPair;
        if (!this.getKeyPair().canSign()) {
            boolean bl = false;
            String string = "This keypair doesn't have private key and can't sign";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    @NotNull
    public final String getSecretKey() {
        char[] cArray = this.getKeyPair().getSecretSeed();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"keyPair.secretSeed");
        return StringsKt.concatToString((char[])cArray);
    }

    @NotNull
    public final <T extends AbstractTransaction> T sign(@NotNull T transaction2) {
        Intrinsics.checkNotNullParameter(transaction2, (String)"transaction");
        return AccountKt.sign(transaction2, this);
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(SigningKeyPair.class).getSimpleName() + "(address=" + this.getAddress() + ")";
    }

    @Override
    @NotNull
    public String getAddress() {
        return AccountKeyPair.DefaultImpls.getAddress(this);
    }

    @Override
    @NotNull
    public byte[] getPublicKey() {
        return AccountKeyPair.DefaultImpls.getPublicKey(this);
    }

    @NotNull
    public final KeyPair component1() {
        return this.keyPair;
    }

    @NotNull
    public final SigningKeyPair copy(@NotNull KeyPair keyPair) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        return new SigningKeyPair(keyPair);
    }

    public static /* synthetic */ SigningKeyPair copy$default(SigningKeyPair signingKeyPair, KeyPair keyPair, int n, Object object) {
        if ((n & 1) != 0) {
            keyPair = signingKeyPair.keyPair;
        }
        return signingKeyPair.copy(keyPair);
    }

    public int hashCode() {
        return this.keyPair.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SigningKeyPair)) {
            return false;
        }
        SigningKeyPair signingKeyPair = (SigningKeyPair)other;
        return Intrinsics.areEqual((Object)this.keyPair, (Object)signingKeyPair.keyPair);
    }

    @JvmStatic
    @NotNull
    public static final SigningKeyPair fromSecret(@NotNull String secret) {
        return Companion.fromSecret(secret);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/stellar/walletsdk/horizon/SigningKeyPair$Companion;", "", "()V", "fromSecret", "Lorg/stellar/walletsdk/horizon/SigningKeyPair;", "secret", "", "wallet-sdk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SigningKeyPair fromSecret(@NotNull String secret) {
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            KeyPair keyPair = KeyPair.fromSecretSeed((String)secret);
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"fromSecretSeed(secret)");
            return new SigningKeyPair(keyPair);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

